/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base;

import java.io.Serializable;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class Pair<A, B>
implements Comparable<Pair<A, B>>,
Serializable {
    private static final long serialVersionUID = 1884389166059435494L;
    public final A first;
    public final B second;

    public Pair(A first, B second) {
        this.first = first;
        this.second = second;
    }

    public A getFirst() {
        return this.first;
    }

    public B getSecond() {
        return this.second;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        return Objects.equals(this.first, pair.first) && Objects.equals(this.second, pair.second);
    }

    public int hashCode() {
        int result = this.first != null ? this.first.hashCode() : 0;
        result = 31 * result + (this.second != null ? this.second.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(@NotNull Pair<A, B> o) {
        if (this.first == null) {
            if (o.first != null) {
                return -1;
            }
        } else {
            if (o.first == null) {
                return 1;
            }
            int firstResult = ((Comparable)this.first).compareTo(o.first);
            if (firstResult != 0) {
                return firstResult;
            }
        }
        if (this.second == null) {
            if (o.second == null) {
                return 0;
            }
            return -1;
        }
        if (o.second == null) {
            return 1;
        }
        return ((Comparable)this.second).compareTo(o.second);
    }
}

