/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base;

import io.deephaven.base.MathUtil;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.function.Consumer;

public class RingBuffer<E>
implements Iterable<E> {
    private Object[] storage;
    private int indexMask;
    private int head;
    private int tail;

    private void grow() {
        Object[] newStorage = new Object[this.storage.length << 1];
        if (this.tail > this.head) {
            System.arraycopy(this.storage, this.head, newStorage, 0, this.tail - this.head);
            this.tail -= this.head;
        } else {
            System.arraycopy(this.storage, this.head, newStorage, 0, this.storage.length - this.head);
            System.arraycopy(this.storage, 0, newStorage, this.storage.length - this.head, this.tail);
            this.tail += this.storage.length - this.head;
        }
        this.head = 0;
        this.storage = newStorage;
        this.indexMask = this.storage.length - 1;
    }

    public boolean isFull() {
        return (this.tail + 1 & this.indexMask) == this.head;
    }

    public RingBuffer(int capacity) {
        int log2cap = MathUtil.ceilLog2(capacity + 1);
        this.storage = new Object[1 << log2cap];
        this.indexMask = this.storage.length - 1;
        this.head = 0;
        this.tail = 0;
    }

    public boolean isEmpty() {
        return this.tail == this.head;
    }

    public int size() {
        return this.tail >= this.head ? this.tail - this.head : this.tail + (this.storage.length - this.head);
    }

    public void clear() {
        this.head = 0;
        this.tail = 0;
        Arrays.fill(this.storage, null);
    }

    public int capacity() {
        return this.storage.length - 1;
    }

    public boolean add(E e) {
        if (this.isFull()) {
            this.grow();
        }
        this.storage[this.tail] = e;
        this.tail = this.tail + 1 & this.indexMask;
        return true;
    }

    public boolean addFirst(E e) {
        if (this.isFull()) {
            this.grow();
        }
        this.head = this.head - 1 & this.indexMask;
        this.storage[this.head] = e;
        return true;
    }

    public E addOverwrite(E e) {
        E result = null;
        if (this.isFull()) {
            result = this.remove();
        }
        this.storage[this.tail] = e;
        this.tail = this.tail + 1 & this.indexMask;
        return result;
    }

    public boolean offer(E e) {
        if (this.isFull()) {
            return false;
        }
        this.storage[this.tail] = e;
        this.tail = this.tail + 1 & this.indexMask;
        return true;
    }

    public boolean offerFirst(E e) {
        if (this.isFull()) {
            return false;
        }
        this.head = this.head - 1 & this.indexMask;
        this.storage[this.head] = e;
        return true;
    }

    public E remove() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object e = this.storage[this.head];
        this.storage[this.head] = null;
        this.head = this.head + 1 & this.indexMask;
        return (E)e;
    }

    public E poll() {
        if (this.isEmpty()) {
            return null;
        }
        Object e = this.storage[this.head];
        this.storage[this.head] = null;
        this.head = this.head + 1 & this.indexMask;
        return (E)e;
    }

    public E element() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return (E)this.storage[this.head];
    }

    public E peek() {
        if (this.isEmpty()) {
            return null;
        }
        return (E)this.storage[this.head];
    }

    public E peek(int offset) {
        if (offset >= this.size()) {
            return null;
        }
        return (E)this.storage[this.head + offset & this.indexMask];
    }

    public E front() {
        return this.front(0);
    }

    public E front(int offset) {
        if (offset >= this.size()) {
            throw new NoSuchElementException();
        }
        return (E)this.storage[this.head + offset & this.indexMask];
    }

    public E removeAtSwapLast(int offset) {
        if (offset >= this.size()) {
            throw new NoSuchElementException();
        }
        int index = this.head + offset & this.indexMask;
        Object removed = this.storage[index];
        this.tail = this.tail - 1 & this.indexMask;
        if (index != this.tail) {
            this.storage[index] = this.storage[this.tail];
        }
        return (E)removed;
    }

    public E back() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return (E)(this.tail == 0 ? this.storage[this.storage.length - 1] : this.storage[this.tail - 1]);
    }

    public E peekLast() {
        if (this.isEmpty()) {
            return null;
        }
        return (E)(this.tail == 0 ? this.storage[this.storage.length - 1] : this.storage[this.tail - 1]);
    }

    public E peekLast(int offset) {
        if (offset >= this.size()) {
            return null;
        }
        return (E)this.storage[this.tail - 1 - offset & this.indexMask];
    }

    public Iterator iterator() {
        return new Iterator();
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        int L = this.size();
        for (int i = 0; i < L; ++i) {
            action.accept(this.storage[this.head + i & this.indexMask]);
        }
    }

    public class Iterator
    implements java.util.Iterator<E> {
        int count = -1;

        @Override
        public boolean hasNext() {
            return this.count + 1 < RingBuffer.this.size();
        }

        @Override
        public E next() {
            ++this.count;
            return RingBuffer.this.storage[RingBuffer.this.head + this.count & RingBuffer.this.indexMask];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

