/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base;

import io.deephaven.base.LockFreeArrayQueue;
import io.deephaven.base.MathUtil;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;

public class UnfairMutex {
    private final int spinsUntilPark;
    private final LockFreeArrayQueue<Thread> threads;
    private final AtomicReference<Thread> leader;

    public UnfairMutex(int spinsUntilPark) {
        this(spinsUntilPark, 1022);
    }

    public UnfairMutex(int spinsUntilPark, int threadCapacity) {
        int capacityPower = Math.max(MathUtil.ceilLog2(threadCapacity + 2), 10);
        this.threads = new LockFreeArrayQueue(capacityPower);
        this.leader = new AtomicReference<Object>(null);
        this.spinsUntilPark = spinsUntilPark;
    }

    public void lock() {
        boolean wasInterrupted = false;
        Thread me = Thread.currentThread();
        int unfairSpins = 0;
        while (++unfairSpins < this.spinsUntilPark) {
            if (!this.leader.compareAndSet(null, me)) continue;
            return;
        }
        while (!this.threads.enqueue(me)) {
        }
        int spins = 0;
        boolean peekNotMe = true;
        while (peekNotMe && (peekNotMe = this.threads.peek() != me) || !this.leader.compareAndSet(null, me)) {
            if (++spins % this.spinsUntilPark != 0) continue;
            LockSupport.park(this);
            if (!Thread.interrupted()) continue;
            wasInterrupted = true;
        }
        Thread t = this.threads.dequeue();
        if (t != me) {
            throw new IllegalStateException("Failed to dequeue myself, got " + String.valueOf(t));
        }
        if (wasInterrupted) {
            me.interrupt();
        }
    }

    public void unlock() {
        Thread me = Thread.currentThread();
        if (!this.leader.compareAndSet(me, null)) {
            throw new IllegalStateException("wrong thread called handoff");
        }
        LockSupport.unpark(this.threads.peek());
    }

    public Thread getOwner() {
        return this.leader.get();
    }
}

