/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base;

import io.deephaven.base.AtomicUtil;
import io.deephaven.base.LockFreeArrayQueue;
import io.deephaven.base.verify.Assert;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;

public class UnfairSemaphore {
    private final LockFreeArrayQueue<Thread> threads;
    private final AtomicInteger resource;
    private final int spinsUntilPark;

    public UnfairSemaphore(int resources, int spinsUntilPark) {
        this.spinsUntilPark = spinsUntilPark;
        this.threads = new LockFreeArrayQueue(12);
        this.resource = new AtomicInteger(resources);
    }

    public boolean acquire(int toAcquire) {
        return this.acquire(toAcquire, true);
    }

    public int acquireAll() {
        int acquired = this.tryAcquireAll();
        if (acquired <= 0) {
            this.acquire(1, false);
            acquired = 1 + this.tryAcquireAll();
        }
        return acquired;
    }

    public int tryAcquireAll() {
        return AtomicUtil.getAndSetIfGreaterThan(this.resource, 0, 0);
    }

    public boolean tryAcquire(int toAcquire) {
        return this.getAndDecreaseIfCan(toAcquire) >= toAcquire;
    }

    private int getAndDecreaseIfCan(int toAcquire) {
        return AtomicUtil.getAndDecreaseIfGreaterThan(this.resource, toAcquire, toAcquire - 1);
    }

    public int release(int toRelease) {
        int r = this.resource.addAndGet(toRelease);
        LockSupport.unpark(this.threads.peek());
        return r;
    }

    public int releaseNoUnpark(int toRelease) {
        return this.resource.addAndGet(toRelease);
    }

    public int availablePermits() {
        return this.resource.get();
    }

    public int forceAcquire(int toAcquire) {
        return this.resource.addAndGet(-toAcquire);
    }

    private boolean acquire(int toAcquire, boolean doUnpark) {
        int resourcesAvailable;
        int unfairSpins = 0;
        while (unfairSpins++ < this.spinsUntilPark) {
            if (!this.tryAcquire(toAcquire)) continue;
            return true;
        }
        boolean wasInterrupted = false;
        Thread me = Thread.currentThread();
        Assert.eqTrue(this.threads.enqueue(me), "threads.enqueue(me)");
        int spins = 0;
        boolean peekNotMe = true;
        while (peekNotMe && (peekNotMe = this.threads.peek() != me) || (resourcesAvailable = this.getAndDecreaseIfCan(toAcquire)) < toAcquire) {
            if (++spins % this.spinsUntilPark != 0) continue;
            LockSupport.park(this);
            if (!Thread.interrupted()) continue;
            wasInterrupted = true;
        }
        Thread t = this.threads.dequeue();
        if (t != me) {
            throw new IllegalStateException("Failed to dequeue myself, got " + String.valueOf(t));
        }
        int remainingResources = resourcesAvailable - toAcquire;
        if (doUnpark && remainingResources > 0) {
            LockSupport.unpark(this.threads.peek());
        }
        if (wasInterrupted) {
            me.interrupt();
        }
        return false;
    }
}

