/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.array;

import io.deephaven.base.ArrayUtil;
import io.deephaven.base.Copyable;
import io.deephaven.base.verify.Assert;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.function.Supplier;

public class FastArray<T> {
    protected final Class<? extends T> clazz;
    protected final Supplier<? extends T> newInstance;
    protected int length;
    protected T[] array;

    public FastArray(Class<? extends T> clazz) {
        this(clazz, () -> {
            try {
                return clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public FastArray(Class<? extends T> clazz, int initialSize) {
        this(clazz, () -> {
            try {
                return clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }, initialSize, true);
    }

    public FastArray(Class<? extends T> clazz, Supplier<? extends T> newInstance) {
        this(clazz, newInstance, 0, true);
    }

    public FastArray(Class<? extends T> clazz, Supplier<? extends T> newInstance, int initialSize, boolean preallocate) {
        this.clazz = clazz;
        this.newInstance = newInstance;
        this.length = 0;
        this.array = (Object[])Array.newInstance(clazz, initialSize);
        if (preallocate) {
            for (int i = 0; i < initialSize; ++i) {
                this.next();
            }
            this.quickReset();
        }
    }

    public Supplier<? extends T> getNewInstance() {
        return this.newInstance;
    }

    public FastArray(Supplier<? extends T> newInstance) {
        this(newInstance.get().getClass(), newInstance);
    }

    public final void add(T t) {
        Assert.neqNull(t, "t");
        this.fastAdd(t);
    }

    public final void add(T[] t, int startIndex, int len) {
        for (int i = 0; i < len; ++i) {
            Assert.neqNull(t[startIndex + i], "t[startIndex + i]");
        }
        this.fastAdd(t, startIndex, len);
    }

    public final boolean addUnique(T t) {
        for (int i = 0; i < this.length; ++i) {
            if (this.array[i] != t) continue;
            return false;
        }
        this.fastAdd(t);
        return true;
    }

    public final void fastAdd(T t) {
        this.array = ArrayUtil.put(this.array, this.length, t, this.clazz);
        ++this.length;
    }

    public final void fastAdd(T[] t, int startIndex, int len) {
        this.array = ArrayUtil.put(this.array, this.length, t, startIndex, len, this.clazz);
        this.length += len;
    }

    public final T next() {
        T t;
        if (this.length >= this.array.length || (t = this.array[this.length]) == null) {
            t = this.newInstance.get();
        }
        this.fastAdd(t);
        return t;
    }

    public final T pop() {
        return this.length > 0 ? (T)this.array[--this.length] : null;
    }

    public final void quickReset() {
        this.length = 0;
    }

    public final void normalReset() {
        this.normalReset(null);
    }

    public final void fullReset() {
        this.fullReset(null);
    }

    public final void normalReset(T resetValue) {
        for (int i = 0; i < this.length; ++i) {
            this.array[i] = resetValue;
        }
        this.length = 0;
    }

    public static <C extends Copyable<C>> void copyNormalReset(FastArray<C> THIS, C resetValue) {
        for (int i = 0; i < THIS.length; ++i) {
            ((Copyable[])THIS.array)[i].copyValues(resetValue);
        }
        THIS.length = 0;
    }

    public final void fullReset(T resetValue) {
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = resetValue;
        }
        this.length = 0;
    }

    public static <C extends Copyable<C>> void copyFullReset(FastArray<C> THIS, C resetValue) {
        for (int i = 0; i < ((Copyable[])THIS.array).length; ++i) {
            ((Copyable[])THIS.array)[i].copyValues(resetValue);
        }
        THIS.length = 0;
    }

    public final void arrayReset() {
        this.length = 0;
        this.array = (Object[])Array.newInstance(this.clazz, 0);
    }

    public final int getLength() {
        return this.length;
    }

    public final T[] getUnsafeArray() {
        return this.array;
    }

    public T removeThisIndex(int index) {
        if (index >= this.length) {
            throw new IllegalArgumentException("you tried to remove this index: " + index + " when the array is only this long: " + this.length);
        }
        if (index < 0) {
            throw new IllegalArgumentException("you tried to remove this index: " + index + " when we can only remove positive indices");
        }
        T t = this.array[index];
        for (int i = index; i < this.length - 1; ++i) {
            this.array[i] = this.array[i + 1];
        }
        --this.length;
        this.array[this.length] = null;
        return t;
    }

    public T removeThisIndexDontCareAboutOrder(int index) {
        if (index >= this.length) {
            throw new IllegalArgumentException("you tried to remove this index: " + index + " when the array is only this long: " + this.length);
        }
        if (index < 0) {
            throw new IllegalArgumentException("you tried to remove this index: " + index + " when we can only remove positive indices");
        }
        T t = this.array[index];
        --this.length;
        this.array[index] = this.array[this.length];
        this.array[this.length] = null;
        return t;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FastArray other = (FastArray)o;
        if (this.clazz != null ? !this.clazz.equals(other.clazz) : other.clazz != null) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        return ArrayUtil.equals(this.array, other.array, 0, 0, this.length);
    }

    public int hashCode() {
        int result = this.length;
        result = 31 * result + ArrayUtil.hashCode(this.array, 0, this.length);
        return result;
    }

    public String toString() {
        return this.toStringXml("");
    }

    public String toStringXml(String pre) {
        StringBuilder msg = new StringBuilder();
        String extra = "   ";
        msg.append(pre).append("<FastArray>\n");
        msg.append(pre).append(extra).append("<length>").append(this.length).append("</length>\n");
        msg.append(pre).append(extra).append("<array>\n");
        for (int i = 0; i < this.array.length; ++i) {
            msg.append(pre).append(extra).append(extra).append("<index>").append(i).append("</index>\n");
            msg.append(pre).append(extra).append(extra).append("<entry>\n");
            if (this.array[i] == null) {
                msg.append(pre).append(extra).append(extra).append(extra).append("null");
            } else {
                msg.append(this.array[i].toString());
            }
            msg.append(pre).append(extra).append("</entry>\n");
        }
        msg.append(pre).append(extra).append("</array>\n");
        msg.append(pre).append("</FastArray>\n");
        return msg.toString();
    }

    public static <C> void copyValuesShallow(FastArray<C> THIS, FastArray<C> right) {
        if (THIS != right) {
            THIS.length = right.length;
            THIS.array = ArrayUtil.ensureSizeNoCopy(THIS.array, THIS.length, THIS.clazz);
            System.arraycopy(right.array, 0, THIS.array, 0, THIS.length);
        }
    }

    public static <C> FastArray<C> cloneShallow(FastArray<C> THIS) {
        FastArray clone = new FastArray(THIS.clazz, THIS.newInstance);
        FastArray.copyValuesShallow(clone, THIS);
        return clone;
    }

    public static <C extends Copyable<C>> void copyValuesDeep(FastArray<C> THIS, FastArray<C> right) {
        Assert.eqTrue(FastArray.maybeCopyValuesDeep(THIS, right), "maybeCopyValuesDeep(THIS, right)");
    }

    public static <C extends Copyable<C>> boolean maybeCopyValuesDeep(FastArray<C> THIS, FastArray<C> right) {
        if (THIS == right) {
            return true;
        }
        THIS.length = right.length;
        THIS.array = ArrayUtil.ensureSize((Copyable[])THIS.array, THIS.length, THIS.clazz);
        for (int i = 0; i < THIS.length; ++i) {
            Copyable rightItem = ((Copyable[])right.array)[i];
            if (rightItem == null) {
                return false;
            }
            if (((Copyable[])THIS.array)[i] == null) {
                ((Copyable[])THIS.array)[i] = (Copyable)rightItem.safeClone();
                continue;
            }
            ((Copyable[])THIS.array)[i].copyValues(rightItem);
        }
        return THIS.length == right.length;
    }

    public static <C extends Copyable<C>> FastArray<C> cloneDeep(FastArray<C> THIS) {
        FastArray clone = new FastArray(THIS.clazz, THIS.newInstance);
        FastArray.copyValuesDeep(clone, THIS);
        return clone;
    }

    public static <C extends Externalizable> void writeExternal(FastArray<C> THIS, ObjectOutput out) throws IOException {
        FastArray.writeExternal(THIS, out, THIS.getLength());
    }

    public static <C extends Externalizable> void writeExternal(FastArray<C> THIS, ObjectOutput out, int maxToWrite) throws IOException {
        maxToWrite = Math.min(maxToWrite, THIS.getLength());
        out.writeInt(maxToWrite);
        for (int i = 0; i < maxToWrite; ++i) {
            ((Externalizable[])THIS.array)[i].writeExternal(out);
        }
    }

    public static <C extends Externalizable> void readExternal(FastArray<C> THIS, ObjectInput in) throws IOException, ClassNotFoundException {
        THIS.quickReset();
        int len = in.readInt();
        for (int i = 0; i < len; ++i) {
            ((Externalizable)THIS.next()).readExternal(in);
        }
    }

    public static <C> void writeExternal(FastArray<C> THIS, ObjectOutput out, WriteExternalFunction<C> writeExternalFunction) throws IOException {
        if (THIS == null) {
            throw new IllegalArgumentException("FastArray.writeExternal(): THIS was null and is not supported");
        }
        out.writeInt(THIS.length);
        for (int i = 0; i < THIS.length; ++i) {
            writeExternalFunction.writeExternal(out, THIS.array[i]);
        }
    }

    public static <C> void readExternal(FastArray<C> THIS, ObjectInput in, ReadExternalFunction<C> readExternalFunction) throws IOException, ClassNotFoundException {
        if (THIS == null) {
            throw new IllegalArgumentException("FastArray.readExternal(): THIS was null and is not supported");
        }
        THIS.quickReset();
        int len = in.readInt();
        for (int i = 0; i < len; ++i) {
            readExternalFunction.readExternal(in, THIS.next());
        }
    }

    public static interface WriteExternalFunction<C> {
        public void writeExternal(ObjectOutput var1, C var2) throws IOException;
    }

    public static interface ReadExternalFunction<C> {
        public void readExternal(ObjectInput var1, C var2) throws IOException, ClassNotFoundException;
    }
}

