/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.classloaders;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MapBackedClassLoader
extends ClassLoader {
    private final Map<String, byte[]> classData = new HashMap<String, byte[]>();

    public synchronized void addClassData(@NotNull String name, @NotNull byte[] data) {
        this.classData.put(name, data);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz == null) {
            try {
                clazz = this.findClass(name);
            }
            catch (ClassNotFoundException e) {
                clazz = this.getParent().loadClass(name);
            }
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    @Override
    protected synchronized Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] clazzData = this.classData.get(name);
        if (clazzData != null) {
            return this.defineClass(name, clazzData, 0, clazzData.length);
        }
        throw new ClassNotFoundException();
    }
}

