/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.map;

import io.deephaven.base.Copyable;
import io.deephaven.base.array.FastArray;
import io.deephaven.base.map.KeyValuePairLongToObject;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.function.Supplier;

public class FastArrayMapLongToObject<V extends Externalizable & Copyable<V>>
implements Copyable<FastArrayMapLongToObject<V>> {
    private FastArray<KeyValuePairLongToObject<V>> array;

    public FastArrayMapLongToObject() {
    }

    public FastArrayMapLongToObject(Supplier<? extends KeyValuePairLongToObject<V>> newInstance) {
        this.array = new FastArray<KeyValuePairLongToObject<V>>(newInstance);
    }

    public FastArray<KeyValuePairLongToObject<V>> getArray() {
        return this.array;
    }

    public int size() {
        return this.array.getLength();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    private int findThisKeyIndex(long key) {
        for (int i = 0; i < this.array.getLength(); ++i) {
            if (this.array.getUnsafeArray()[i].getKey() != key) continue;
            return i;
        }
        return -1;
    }

    public boolean containsKey(long key) {
        return this.findThisKeyIndex(key) >= 0;
    }

    public V get(long key) {
        int index = this.findThisKeyIndex(key);
        if (index < 0) {
            return null;
        }
        return this.array.getUnsafeArray()[index].getValue();
    }

    public V put(long key, V value) {
        int index = this.findThisKeyIndex(key);
        if (index >= 0) {
            V oldValue = this.array.getUnsafeArray()[index].getValue();
            this.array.getUnsafeArray()[index].setValue(value);
            return oldValue;
        }
        KeyValuePairLongToObject<V> newItem = new KeyValuePairLongToObject<V>(key, value);
        this.insertNewlyAllocatedItemIntoArray(newItem);
        return null;
    }

    private void insertNewlyAllocatedItemIntoArray(KeyValuePairLongToObject<V> item) {
        this.array.add(item);
        this.sortArray();
    }

    private void sortArray() {
        Arrays.sort(this.array.getUnsafeArray(), 0, this.array.getLength());
    }

    public V remove(long key) {
        int index = this.findThisKeyIndex(key);
        if (index >= 0) {
            V oldValue = this.array.getUnsafeArray()[index].getValue();
            this.array.removeThisIndex(index);
            return oldValue;
        }
        return null;
    }

    public void clear() {
        this.array.quickReset();
    }

    public FastArrayMapLongToObject<V> cloneDeep() {
        FastArrayMapLongToObject<V> copy = new FastArrayMapLongToObject<V>();
        copy.array = FastArray.cloneDeep(this.getArray());
        return copy;
    }

    public static <V extends Externalizable & Copyable<V>> void writeExternal(FastArrayMapLongToObject<V> THIS, ObjectOutput out, FastArray.WriteExternalFunction<KeyValuePairLongToObject<V>> writeExternalFunction) throws IOException {
        if (THIS == null) {
            throw new IllegalArgumentException("FastArrayMapLongToObject.writeExternal(): THIS was null and is not supported");
        }
        out.writeInt(THIS.array.getLength());
        for (int i = 0; i < THIS.array.getLength(); ++i) {
            writeExternalFunction.writeExternal(out, THIS.array.getUnsafeArray()[i]);
        }
    }

    public static <V extends Externalizable & Copyable<V>> void readExternal(FastArrayMapLongToObject<V> THIS, ObjectInput in, FastArray.ReadExternalFunction<KeyValuePairLongToObject<V>> readExternalFunction) throws IOException, ClassNotFoundException {
        if (THIS == null) {
            throw new IllegalArgumentException("FastArrayMapLongToObject.readExternal(): THIS was null and is not supported");
        }
        THIS.array.quickReset();
        int len = in.readInt();
        for (int i = 0; i < len; ++i) {
            KeyValuePairLongToObject<V> nextKeyValuePair = THIS.array.next();
            readExternalFunction.readExternal(in, nextKeyValuePair);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FastArrayMapLongToObject)) {
            return false;
        }
        FastArrayMapLongToObject that = (FastArrayMapLongToObject)o;
        return !(this.array != null ? !this.array.equals(that.array) : that.array != null);
    }

    public int hashCode() {
        return this.array != null ? this.array.hashCode() : 0;
    }

    public String toString() {
        return this.toStringXml("");
    }

    public String toStringXml(String pre) {
        StringBuilder msg = new StringBuilder();
        String extra = "   ";
        msg.append(pre).append("<FastArrayMapLongToObject>\n");
        msg.append(pre).append(extra).append("<array>\n");
        msg.append(this.array.toStringXml(pre + extra));
        msg.append(pre).append(extra).append("</array>\n");
        msg.append(pre).append("</FastArrayMapLongToObject>\n");
        return msg.toString();
    }

    @Override
    public void copyValues(FastArrayMapLongToObject<V> other) {
        FastArray.copyValuesDeep(this.array, other.array);
    }

    @Override
    public FastArrayMapLongToObject<V> safeClone() {
        FastArrayMapLongToObject<V> result = new FastArrayMapLongToObject<V>(this.array.getNewInstance());
        for (int i = 0; i < this.array.getLength(); ++i) {
            KeyValuePairLongToObject<V> pair = this.array.getUnsafeArray()[i];
            result.put(pair.getKey(), pair.getValue());
        }
        return result;
    }
}

