/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.map;

import io.deephaven.base.Copyable;
import io.deephaven.base.SafeCloneable;
import java.io.Externalizable;

public class KeyValuePair<K extends Externalizable & Comparable<K>, V extends Externalizable & Copyable<V>>
implements Comparable<KeyValuePair<K, V>>,
Copyable<KeyValuePair<K, V>> {
    private K key;
    private V value;

    public KeyValuePair() {
    }

    public KeyValuePair(K key, V value) {
        if (key == null) {
            throw new IllegalArgumentException("key can not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value can not be null");
        }
        this.key = key;
        this.value = value;
    }

    public K getKey() {
        return this.key;
    }

    public void setKey(K key) {
        this.key = key;
    }

    public V getValue() {
        return this.value;
    }

    public void setValue(V value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyValuePair)) {
            return false;
        }
        KeyValuePair that = (KeyValuePair)o;
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(KeyValuePair<K, V> o) {
        return ((Comparable)this.key).compareTo(o.key);
    }

    public String toString() {
        return "KeyValuePair: " + String.valueOf(this.key) + " " + String.valueOf(this.value);
    }

    @Override
    public void copyValues(KeyValuePair<K, V> other) {
        if (other.key == null) {
            this.key = null;
        } else if (this.key == null) {
            this.key = (Externalizable)((SafeCloneable)other.key).safeClone();
        } else {
            ((Copyable)this.key).copyValues(other.key);
        }
        if (other.value == null) {
            this.value = null;
        } else if (this.value == null) {
            this.value = (Externalizable)((SafeCloneable)other.value).safeClone();
        } else {
            ((Copyable)this.value).copyValues(other.value);
        }
    }

    public Object clone() {
        throw new UnsupportedOperationException("You should not be calling this method");
    }

    @Override
    public KeyValuePair<K, V> safeClone() {
        return new KeyValuePair<Externalizable, Externalizable>((Externalizable)((SafeCloneable)this.key).safeClone(), (Externalizable)((SafeCloneable)this.value).safeClone());
    }
}

