/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.map;

import io.deephaven.base.Copyable;
import io.deephaven.base.SafeCloneable;
import java.io.Externalizable;

public class KeyValuePairLongToObject<V extends Externalizable & Copyable<V>>
implements Comparable<KeyValuePairLongToObject<V>>,
Copyable<KeyValuePairLongToObject<V>> {
    private long key;
    private V value;

    public KeyValuePairLongToObject() {
    }

    public KeyValuePairLongToObject(long key, V value) {
        if (value == null) {
            throw new IllegalArgumentException("value can not be null");
        }
        this.key = key;
        this.value = value;
    }

    public long getKey() {
        return this.key;
    }

    public void setKey(long key) {
        this.key = key;
    }

    public V getValue() {
        return this.value;
    }

    public void setValue(V value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyValuePairLongToObject)) {
            return false;
        }
        KeyValuePairLongToObject that = (KeyValuePairLongToObject)o;
        if (this.key != that.key) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = (int)(this.key ^ this.key >>> 32);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(KeyValuePairLongToObject<V> o) {
        if (this.key < o.key) {
            return -1;
        }
        if (this.key > o.key) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "KeyValuePair: " + this.key + " " + String.valueOf(this.value);
    }

    @Override
    public void copyValues(KeyValuePairLongToObject<V> other) {
        this.key = other.key;
        ((Copyable)this.value).copyValues(other.getValue());
    }

    public Object clone() {
        throw new UnsupportedOperationException("You should not be calling this method");
    }

    @Override
    public KeyValuePairLongToObject<V> safeClone() {
        return new KeyValuePairLongToObject<Externalizable>(this.key, (Externalizable)((SafeCloneable)this.value).safeClone());
    }
}

