/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.reference;

import io.deephaven.base.reference.SimpleReference;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PooledObjectReference<REFERENT_TYPE>
implements SimpleReference<REFERENT_TYPE> {
    private static final AtomicIntegerFieldUpdater<PooledObjectReference> STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(PooledObjectReference.class, "state");
    private static final int AVAILABLE_ZERO_PERMITS = 1;
    private static final int CLEARED_ZERO_PERMITS = 0;
    private static final int STATE_AVAILABLE_BIT = 1;
    private static final int STATE_PERMIT_ACQUIRE_QUANTITY = 2;
    private static final int STATE_PERMIT_RELEASE_QUANTITY = -2;
    private volatile REFERENT_TYPE referent;
    private volatile int state = 1;

    private static boolean stateAllowsAcquire(int currentState) {
        return currentState > 0;
    }

    private static boolean stateIsAvailable(int currentState) {
        return (currentState & 1) != 0;
    }

    private static boolean stateIsCleared(int currentState) {
        return (currentState & 1) == 0;
    }

    private static int calculateNewStateForClear(int currentState) {
        return currentState ^ 1;
    }

    private static int calculateNewStateForAcquire(int currentState) {
        return currentState + 2;
    }

    private boolean tryUpdateState(int currentState, int newState) {
        return STATE_UPDATER.compareAndSet(this, currentState, newState);
    }

    private int decrementOutstandingPermits() {
        return STATE_UPDATER.addAndGet(this, -2);
    }

    protected PooledObjectReference(@NotNull REFERENT_TYPE referent) {
        this.referent = Objects.requireNonNull(referent, "referent");
    }

    @Override
    public final REFERENT_TYPE get() {
        return this.referent;
    }

    public final boolean acquire() {
        int currentState;
        while (PooledObjectReference.stateAllowsAcquire(currentState = this.state)) {
            int newState = PooledObjectReference.calculateNewStateForAcquire(currentState);
            if (!this.tryUpdateState(currentState, newState)) continue;
            return true;
        }
        return false;
    }

    public final boolean acquireIfAvailable() {
        int currentState;
        while (PooledObjectReference.stateAllowsAcquire(currentState = this.state) && PooledObjectReference.stateIsAvailable(currentState)) {
            int newState = PooledObjectReference.calculateNewStateForAcquire(currentState);
            if (!this.tryUpdateState(currentState, newState)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public final REFERENT_TYPE acquireAndGet() {
        return this.acquire() ? (REFERENT_TYPE)this.referent : null;
    }

    public final void release() {
        int newState = this.decrementOutstandingPermits();
        if (newState < 0) {
            throw new IllegalStateException(String.valueOf(this) + " released more than acquired");
        }
        this.maybeReturnReferentToPool(newState);
    }

    @Override
    public final void clear() {
        int currentState;
        while (PooledObjectReference.stateIsAvailable(currentState = this.state)) {
            int newState = PooledObjectReference.calculateNewStateForClear(currentState);
            if (!this.tryUpdateState(currentState, newState)) continue;
            this.maybeReturnReferentToPool(newState);
            return;
        }
    }

    protected abstract void returnReferentToPool(@NotNull REFERENT_TYPE var1);

    private void maybeReturnReferentToPool(int newState) {
        if (PooledObjectReference.stateAllowsAcquire(newState)) {
            return;
        }
        REFERENT_TYPE localReferent = this.referent;
        this.referent = null;
        this.returnReferentToPool(localReferent);
    }
}

