/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.reference;

import io.deephaven.base.reference.SimpleReference;
import io.deephaven.base.reference.WeakSimpleReference;

public abstract class WeakReferenceWrapper<T>
implements SimpleReference<T> {
    private final SimpleReference<T> wrappedReference;

    protected WeakReferenceWrapper(T wrappedReferent) {
        this.wrappedReference = WeakReferenceWrapper.maybeCreateWeakReference(wrappedReferent);
    }

    @Override
    public final T get() {
        if (this.wrappedReference.get() == null) {
            return null;
        }
        return (T)this;
    }

    @Override
    public final void clear() {
        this.wrappedReference.clear();
    }

    protected final T getWrapped() {
        return this.wrappedReference.get();
    }

    public static <T> SimpleReference<T> maybeCreateWeakReference(T referent) {
        if (referent instanceof WeakReferenceWrapper) {
            return (SimpleReference)referent;
        }
        return new WeakSimpleReference<T>(referent);
    }
}

