/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.ringbuffer;

import io.deephaven.base.MathUtil;
import io.deephaven.base.ringbuffer.RingBuffer;
import io.deephaven.base.verify.Assert;
import java.io.Serializable;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.TestOnly;

public class ByteRingBuffer
implements RingBuffer,
Serializable {
    static final long FIXUP_THRESHOLD = 0x4000000000000000L;
    final boolean growable;
    byte[] storage;
    int mask;
    long head;
    long tail;

    public ByteRingBuffer(int capacity) {
        this(capacity, true);
    }

    public ByteRingBuffer(int capacity, boolean growable) {
        Assert.leq(capacity, "ByteRingBuffer capacity", 0x40000000);
        this.growable = growable;
        this.storage = new byte[MathUtil.roundUpPowerOf2(capacity)];
        this.mask = this.storage.length - 1;
        this.head = 0L;
        this.tail = 0L;
    }

    protected void grow(int increase) {
        int size = this.size();
        long newCapacity = (long)this.storage.length + (long)increase;
        Assert.leq(newCapacity, "ByteRingBuffer capacity", 0x40000000L);
        byte[] newStorage = new byte[MathUtil.roundUpPowerOf2((int)newCapacity)];
        this.copyRingBufferToArray(newStorage);
        this.storage = newStorage;
        this.mask = this.storage.length - 1;
        this.tail = size;
        this.head = 0L;
    }

    protected void copyRingBufferToArray(byte[] dest) {
        int size = this.size();
        int storageHead = (int)(this.head & (long)this.mask);
        int firstCopyLen = Math.min(Math.min(this.storage.length - storageHead, size), dest.length);
        int secondCopyLen = Math.min(size - firstCopyLen, dest.length - firstCopyLen);
        System.arraycopy(this.storage, storageHead, dest, 0, firstCopyLen);
        System.arraycopy(this.storage, 0, dest, firstCopyLen, secondCopyLen);
    }

    @Override
    public boolean isFull() {
        return this.size() == this.storage.length;
    }

    @Override
    public boolean isEmpty() {
        return this.tail == this.head;
    }

    @Override
    public int size() {
        return Math.toIntExact(this.tail - this.head);
    }

    @Override
    public int capacity() {
        return this.storage.length;
    }

    @Override
    public int remaining() {
        return this.storage.length - this.size();
    }

    @Override
    public void clear() {
        this.head = 0L;
        this.tail = 0L;
    }

    public boolean add(byte e) {
        if (this.isFull()) {
            if (!this.growable) {
                throw new UnsupportedOperationException("Ring buffer is full and growth is disabled");
            }
            this.grow(1);
        }
        this.addUnsafe(e);
        return true;
    }

    @Override
    public void ensureRemaining(int count) {
        if (this.remaining() < count) {
            if (!this.growable) {
                throw new UnsupportedOperationException("Ring buffer is full and growth is disabled");
            }
            this.grow(count);
        }
    }

    public void addUnsafe(byte e) {
        if (this.tail >= 0x4000000000000000L) {
            long thisLength = this.tail - this.head;
            this.head &= (long)this.mask;
            this.tail = this.head + thisLength;
        }
        this.storage[(int)(this.tail++ & (long)this.mask)] = e;
    }

    public byte addOverwrite(byte e, byte notFullResult) {
        byte val = notFullResult;
        if (this.isFull()) {
            val = this.remove();
        }
        this.addUnsafe(e);
        return val;
    }

    public boolean offer(byte e) {
        if (this.isFull()) {
            return false;
        }
        this.addUnsafe(e);
        return true;
    }

    public byte[] remove(int count) {
        int size = this.size();
        if (size < count) {
            throw new NoSuchElementException();
        }
        byte[] result = new byte[count];
        this.copyRingBufferToArray(result);
        this.head += (long)count;
        return result;
    }

    public byte remove() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.removeUnsafe();
    }

    public byte removeUnsafe() {
        int idx = (int)(this.head++ & (long)this.mask);
        byte val = this.storage[idx];
        return val;
    }

    public byte poll(byte onEmpty) {
        if (this.isEmpty()) {
            return onEmpty;
        }
        return this.removeUnsafe();
    }

    public byte element() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.storage[(int)(this.head & (long)this.mask)];
    }

    public byte peek(byte onEmpty) {
        if (this.isEmpty()) {
            return onEmpty;
        }
        return this.storage[(int)(this.head & (long)this.mask)];
    }

    public byte front() {
        return this.front(0);
    }

    public byte front(int offset) {
        if (offset < 0 || offset >= this.size()) {
            throw new NoSuchElementException();
        }
        return this.storage[(int)(this.head + (long)offset & (long)this.mask)];
    }

    public byte back() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.storage[(int)(this.tail - 1L & (long)this.mask)];
    }

    public byte peekBack(byte onEmpty) {
        if (this.isEmpty()) {
            return onEmpty;
        }
        return this.storage[(int)(this.tail - 1L & (long)this.mask)];
    }

    public byte[] getAll() {
        byte[] result = new byte[this.size()];
        this.copyRingBufferToArray(result);
        return result;
    }

    public Iterator iterator() {
        return new Iterator();
    }

    @TestOnly
    public byte[] getStorage() {
        return this.storage;
    }

    public class Iterator {
        int cursor = -1;

        public boolean hasNext() {
            return this.cursor + 1 < ByteRingBuffer.this.size();
        }

        public byte next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.cursor;
            return ByteRingBuffer.this.storage[(int)(ByteRingBuffer.this.head + (long)this.cursor & (long)ByteRingBuffer.this.mask)];
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

