/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.ringbuffer;

import io.deephaven.base.MathUtil;
import io.deephaven.base.ringbuffer.RingBuffer;
import io.deephaven.base.verify.Assert;
import java.io.Serializable;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.TestOnly;

public class DoubleRingBuffer
implements RingBuffer,
Serializable {
    static final long FIXUP_THRESHOLD = 0x4000000000000000L;
    final boolean growable;
    double[] storage;
    int mask;
    long head;
    long tail;

    public DoubleRingBuffer(int capacity) {
        this(capacity, true);
    }

    public DoubleRingBuffer(int capacity, boolean growable) {
        Assert.leq(capacity, "DoubleRingBuffer capacity", 0x40000000);
        this.growable = growable;
        this.storage = new double[MathUtil.roundUpPowerOf2(capacity)];
        this.mask = this.storage.length - 1;
        this.head = 0L;
        this.tail = 0L;
    }

    protected void grow(int increase) {
        int size = this.size();
        long newCapacity = (long)this.storage.length + (long)increase;
        Assert.leq(newCapacity, "DoubleRingBuffer capacity", 0x40000000L);
        double[] newStorage = new double[MathUtil.roundUpPowerOf2((int)newCapacity)];
        this.copyRingBufferToArray(newStorage);
        this.storage = newStorage;
        this.mask = this.storage.length - 1;
        this.tail = size;
        this.head = 0L;
    }

    protected void copyRingBufferToArray(double[] dest) {
        int size = this.size();
        int storageHead = (int)(this.head & (long)this.mask);
        int firstCopyLen = Math.min(Math.min(this.storage.length - storageHead, size), dest.length);
        int secondCopyLen = Math.min(size - firstCopyLen, dest.length - firstCopyLen);
        System.arraycopy(this.storage, storageHead, dest, 0, firstCopyLen);
        System.arraycopy(this.storage, 0, dest, firstCopyLen, secondCopyLen);
    }

    @Override
    public boolean isFull() {
        return this.size() == this.storage.length;
    }

    @Override
    public boolean isEmpty() {
        return this.tail == this.head;
    }

    @Override
    public int size() {
        return Math.toIntExact(this.tail - this.head);
    }

    @Override
    public int capacity() {
        return this.storage.length;
    }

    @Override
    public int remaining() {
        return this.storage.length - this.size();
    }

    @Override
    public void clear() {
        this.head = 0L;
        this.tail = 0L;
    }

    public boolean add(double e) {
        if (this.isFull()) {
            if (!this.growable) {
                throw new UnsupportedOperationException("Ring buffer is full and growth is disabled");
            }
            this.grow(1);
        }
        this.addUnsafe(e);
        return true;
    }

    @Override
    public void ensureRemaining(int count) {
        if (this.remaining() < count) {
            if (!this.growable) {
                throw new UnsupportedOperationException("Ring buffer is full and growth is disabled");
            }
            this.grow(count);
        }
    }

    public void addUnsafe(double e) {
        if (this.tail >= 0x4000000000000000L) {
            long thisLength = this.tail - this.head;
            this.head &= (long)this.mask;
            this.tail = this.head + thisLength;
        }
        this.storage[(int)(this.tail++ & (long)this.mask)] = e;
    }

    public double addOverwrite(double e, double notFullResult) {
        double val = notFullResult;
        if (this.isFull()) {
            val = this.remove();
        }
        this.addUnsafe(e);
        return val;
    }

    public boolean offer(double e) {
        if (this.isFull()) {
            return false;
        }
        this.addUnsafe(e);
        return true;
    }

    public double[] remove(int count) {
        int size = this.size();
        if (size < count) {
            throw new NoSuchElementException();
        }
        double[] result = new double[count];
        this.copyRingBufferToArray(result);
        this.head += (long)count;
        return result;
    }

    public double remove() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.removeUnsafe();
    }

    public double removeUnsafe() {
        int idx = (int)(this.head++ & (long)this.mask);
        double val = this.storage[idx];
        return val;
    }

    public double poll(double onEmpty) {
        if (this.isEmpty()) {
            return onEmpty;
        }
        return this.removeUnsafe();
    }

    public double element() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.storage[(int)(this.head & (long)this.mask)];
    }

    public double peek(double onEmpty) {
        if (this.isEmpty()) {
            return onEmpty;
        }
        return this.storage[(int)(this.head & (long)this.mask)];
    }

    public double front() {
        return this.front(0);
    }

    public double front(int offset) {
        if (offset < 0 || offset >= this.size()) {
            throw new NoSuchElementException();
        }
        return this.storage[(int)(this.head + (long)offset & (long)this.mask)];
    }

    public double back() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.storage[(int)(this.tail - 1L & (long)this.mask)];
    }

    public double peekBack(double onEmpty) {
        if (this.isEmpty()) {
            return onEmpty;
        }
        return this.storage[(int)(this.tail - 1L & (long)this.mask)];
    }

    public double[] getAll() {
        double[] result = new double[this.size()];
        this.copyRingBufferToArray(result);
        return result;
    }

    public Iterator iterator() {
        return new Iterator();
    }

    @TestOnly
    public double[] getStorage() {
        return this.storage;
    }

    public class Iterator {
        int cursor = -1;

        public boolean hasNext() {
            return this.cursor + 1 < DoubleRingBuffer.this.size();
        }

        public double next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.cursor;
            return DoubleRingBuffer.this.storage[(int)(DoubleRingBuffer.this.head + (long)this.cursor & (long)DoubleRingBuffer.this.mask)];
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

