/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.stats;

import io.deephaven.base.stats.History;
import io.deephaven.base.stats.Item;
import io.deephaven.base.stats.ItemUpdateListener;
import io.deephaven.base.stats.Value;
import io.deephaven.base.verify.Assert;
import io.deephaven.base.verify.Require;

public class Composite
extends Value {
    private final Value[] m_values;

    public Composite(long now, Value ... values) {
        super(new CompositeHistory(now, Composite.checkValues(values)));
        this.m_values = values;
    }

    private static Value[] checkValues(Value[] values) {
        Require.neqNull(values, "values");
        Require.gtZero(values.length, "values.length");
        Require.neqNull(values[0], "values[0]");
        char typeTag = values[0].getTypeTag();
        for (int nIndex = 1; nIndex < values.length; ++nIndex) {
            Require.neqNull(values[nIndex], "values[nIndex]");
            Require.eq(values[nIndex].getTypeTag(), "values[nIndex].getTypeTag()", typeTag, "typeTag");
        }
        return values;
    }

    @Override
    public void sample(long x) {
        throw Assert.statementNeverExecuted();
    }

    @Override
    public char getTypeTag() {
        return this.m_values[0].getTypeTag();
    }

    @Override
    public long getN() {
        long n = 0L;
        for (Value value : this.m_values) {
            n += value.getN();
        }
        return n;
    }

    @Override
    public long getLast() {
        return this.m_values[0].getLast();
    }

    @Override
    public long getSum() {
        long sum = 0L;
        for (Value value : this.m_values) {
            sum += value.getSum();
        }
        return sum;
    }

    @Override
    public long getSum2() {
        long sum2 = 0L;
        for (Value value : this.m_values) {
            sum2 += value.getSum2();
        }
        return sum2;
    }

    @Override
    public long getMax() {
        long max = this.m_values[0].getMax();
        for (int nIndex = 1; nIndex < this.m_values.length; ++nIndex) {
            max = Math.max(max, this.m_values[nIndex].getMax());
        }
        return max;
    }

    @Override
    public long getMin() {
        long min = this.m_values[0].getMin();
        for (int nIndex = 1; nIndex < this.m_values.length; ++nIndex) {
            min = Math.min(min, this.m_values[nIndex].getMin());
        }
        return min;
    }

    @Override
    public History getHistory() {
        return super.getHistory();
    }

    @Override
    public void update(Item item, ItemUpdateListener listener, long logInterval, long now, long appNow) {
    }

    private static class CompositeHistory
    extends History {
        private final History[] m_histories;

        public CompositeHistory(long now, Value[] values) {
            super(now);
            Require.neqNull(values, "values");
            Require.gtZero(values.length, "values.length");
            this.m_histories = new History[values.length];
            for (int nIndex = 0; nIndex < values.length; ++nIndex) {
                Require.neqNull(values[nIndex], "values[nIndex]");
                this.m_histories[nIndex] = values[nIndex].getHistory();
            }
        }

        @Override
        public int update(Value v, long now) {
            throw Assert.statementNeverExecuted();
        }

        @Override
        public long getLast(int i, int d) {
            return this.m_histories[0].getLast(i, d);
        }

        @Override
        public long getSum(int i, int d) {
            long sum = 0L;
            for (History history : this.m_histories) {
                sum += history.getSum(i, d);
            }
            return sum;
        }

        @Override
        public long getSum2(int i, int d) {
            long sum2 = 0L;
            for (History history : this.m_histories) {
                sum2 += history.getSum2(i, d);
            }
            return sum2;
        }

        @Override
        public long getN(int i, int d) {
            long n = 0L;
            for (History history : this.m_histories) {
                n += history.getN(i, d);
            }
            return n;
        }

        @Override
        public long getMax(int i, int d) {
            long max = this.m_histories[0].getMax(i, d);
            for (int nIndex = 1; nIndex < this.m_histories.length; ++nIndex) {
                max = Math.max(max, this.m_histories[nIndex].getMax(i, d));
            }
            return max;
        }

        @Override
        public long getMin(int i, int d) {
            long min = this.m_histories[0].getMin(i, d);
            for (int nIndex = 1; nIndex < this.m_histories.length; ++nIndex) {
                min = Math.min(min, this.m_histories[nIndex].getMin(i, d));
            }
            return min;
        }
    }
}

