/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.stats;

import io.deephaven.base.stats.Group;
import io.deephaven.base.stats.HistogramState;
import io.deephaven.base.stats.Item;
import io.deephaven.base.stats.ItemUpdateListener;
import io.deephaven.base.stats.Value;
import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.LongFunction;

public class Stats {
    private static TimeSource timeSource = new TimeSource(){

        @Override
        public long currentTimeMillis() {
            return System.currentTimeMillis();
        }
    };
    private static ArrayList<Group> groups = new ArrayList();
    private static Group[] groupsArray;
    public static final String UNKNOWN_DESCRIPTION = "Please describe this stats item";

    public static void setTimeSource(TimeSource ts) {
        timeSource = ts;
    }

    public static synchronized Group makeGroup(String name, String description) {
        for (Group g : groups) {
            if (!g.getName().equals(name)) continue;
            if (description != null) {
                g.setDescription((String)description);
            }
            return g;
        }
        if (description == null) {
            description = "The description of the group " + name + " should go here";
        }
        Group g = new Group(name, (String)description);
        groups.add(g);
        groupsArray = null;
        return g;
    }

    public static synchronized <V extends Value> Item<V> makeItem(String groupName, String itemName, LongFunction<V> valueFactory) {
        return Stats.makeItem(groupName, itemName, valueFactory, UNKNOWN_DESCRIPTION, timeSource.currentTimeMillis());
    }

    public static synchronized <V extends Value> Item<V> makeItem(String groupName, String itemName, LongFunction<V> valueFactory, long now) {
        return Stats.makeItem(groupName, itemName, valueFactory, UNKNOWN_DESCRIPTION, now);
    }

    public static synchronized <V extends Value> Item<V> makeItem(String groupName, String itemName, LongFunction<V> valueFactory, String description) {
        return Stats.makeItem(groupName, itemName, valueFactory, description, timeSource.currentTimeMillis());
    }

    public static synchronized <V extends Value> Item<V> makeItem(String groupName, String itemName, LongFunction<V> valueFactory, String description, long now) {
        Group g = Stats.makeGroup(groupName, null);
        return g.makeItem(itemName, valueFactory, description, now);
    }

    public static synchronized <V extends Value, Arg> Item<V> makeItem(String groupName, String itemName, BiFunction<Long, Arg, V> valueFactory, Arg arg) {
        return Stats.makeItem(groupName, itemName, valueFactory, UNKNOWN_DESCRIPTION, timeSource.currentTimeMillis(), arg);
    }

    public static synchronized <V extends Value, Arg> Item<V> makeItem(String groupName, String itemName, BiFunction<Long, Arg, V> valueFactory, long now, Arg arg) {
        return Stats.makeItem(groupName, itemName, valueFactory, UNKNOWN_DESCRIPTION, now, arg);
    }

    public static synchronized <V extends Value, Arg> Item<V> makeItem(String groupName, String itemName, BiFunction<Long, Arg, V> valueFactory, String description, Arg arg) {
        return Stats.makeItem(groupName, itemName, valueFactory, description, timeSource.currentTimeMillis(), arg);
    }

    public static synchronized <V extends Value, Arg> Item<V> makeItem(String groupName, String itemName, BiFunction<Long, Arg, V> valueFactory, String description, long now, Arg arg) {
        Group g = Stats.makeGroup(groupName, null);
        return g.makeItem(itemName, valueFactory, description, now, arg);
    }

    public static synchronized <V extends Value> Item<HistogramState> makeHistogram(String groupName, String itemName, long rangeMin, long rangeMax, int numBuckets) {
        return Stats.makeHistogram(groupName, itemName, UNKNOWN_DESCRIPTION, timeSource.currentTimeMillis(), rangeMin, rangeMax, numBuckets);
    }

    public static synchronized <V extends Value> Item<HistogramState> makeHistogram(String groupName, String itemName, long now, long rangeMin, long rangeMax, int numBuckets) {
        return Stats.makeHistogram(groupName, itemName, UNKNOWN_DESCRIPTION, now, rangeMin, rangeMax, numBuckets);
    }

    public static synchronized <V extends Value> Item<HistogramState> makeHistogram(String groupName, String itemName, String description, long rangeMin, long rangeMax, int numBuckets) {
        return Stats.makeHistogram(groupName, itemName, description, timeSource.currentTimeMillis(), rangeMin, rangeMax, numBuckets);
    }

    public static synchronized <V extends Value> Item<HistogramState> makeHistogram(String groupName, String itemName, String description, long now, long rangeMin, long rangeMax, int numBuckets) {
        return Stats.makeItem(groupName, itemName, HistogramState.FACTORY, description, now, new HistogramState.Spec(groupName, itemName, rangeMin, rangeMax, numBuckets));
    }

    public static synchronized Group[] getGroups() {
        if (null == groupsArray) {
            groupsArray = groups.toArray(new Group[groups.size()]);
        }
        return groupsArray;
    }

    public static synchronized Group getGroup(String name) {
        for (Group g : groups) {
            if (!g.getName().equals(name)) continue;
            return g;
        }
        return null;
    }

    public static synchronized void update(ItemUpdateListener listener, long now, long appNow, long logInterval) {
        for (Group g : groups) {
            g.update(listener, logInterval, now, appNow);
        }
    }

    public static synchronized void clearAll() {
        groups = new ArrayList();
        groupsArray = null;
    }

    public static interface TimeSource {
        public long currentTimeMillis();
    }

    public static interface Maker {
        public static final Maker DEFAULT = new Maker(){

            @Override
            public <V extends Value> Item<V> makeItem(String groupName, String itemName, LongFunction<V> valueFactory) {
                return Stats.makeItem(groupName, itemName, valueFactory);
            }
        };

        public <V extends Value> Item<V> makeItem(String var1, String var2, LongFunction<V> var3);
    }
}

