/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.stats;

import io.deephaven.base.stats.History;
import io.deephaven.base.stats.Item;
import io.deephaven.base.stats.ItemUpdateListener;

public abstract class Value {
    protected long n = 0L;
    protected long last = 0L;
    protected long sum = 0L;
    protected long sum2 = 0L;
    protected long max = Long.MIN_VALUE;
    protected long min = Long.MAX_VALUE;
    private boolean alwaysUpdated = false;
    protected final History history;

    public long getN() {
        return this.n;
    }

    public long getLast() {
        return this.last;
    }

    public long getSum() {
        return this.sum;
    }

    public long getSum2() {
        return this.sum2;
    }

    public long getMax() {
        return this.max;
    }

    public long getMin() {
        return this.min;
    }

    public Value(long now) {
        this.history = new History(now);
    }

    protected Value(History history) {
        this.history = history;
    }

    public void sample(long x) {
        ++this.n;
        this.last = x;
        this.sum += x;
        this.sum2 += x * x;
        if (x > this.max) {
            this.max = x;
        }
        if (x < this.min) {
            this.min = x;
        }
    }

    public void increment(long x) {
        this.sample(x);
    }

    public abstract char getTypeTag();

    public History getHistory() {
        return this.history;
    }

    public Value alwaysUpdated(boolean b) {
        this.alwaysUpdated = b;
        return this;
    }

    public void reset() {
        this.sum2 = 0L;
        this.sum = 0L;
        this.n = 0L;
        this.max = Long.MIN_VALUE;
        this.min = Long.MAX_VALUE;
    }

    public void update(Item item, ItemUpdateListener listener, long logInterval, long now, long appNow) {
        int topInterval = this.history.update(this, now);
        this.reset();
        if (History.INTERVALS[topInterval] >= logInterval) {
            for (int i = 0; i <= topInterval; ++i) {
                if ((History.INTERVALS[i] < logInterval || this.history.getN(i, 1) <= 0L) && !this.alwaysUpdated || listener == null) continue;
                listener.handleItemUpdated(item, now, appNow, i, History.INTERVALS[i], History.INTERVAL_NAMES[i]);
            }
        }
    }

    public String toString() {
        if (this.n > 0L) {
            double std = Math.sqrt(this.n > 1L ? ((double)this.sum2 - (double)this.sum * (double)this.sum / (double)this.n) / (double)(this.n - 1L) : Double.NaN);
            double avg = (double)this.sum / (double)this.n;
            return String.format("Value{n=%,d, sum=%,d, max=%,d, min=%,d, avg=%,.3f, std=%,.3f}", this.n, this.sum, this.max, this.min, avg, std);
        }
        return String.format("Value{n=%,d}", this.n);
    }
}

