/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.system;

import io.deephaven.base.verify.Assert;
import java.io.PrintStream;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class AsyncSystem {
    public static Thread.UncaughtExceptionHandler uncaughtExceptionHandler(int status, PrintStream out) {
        return new AsyncSystemExitUncaughtExceptionHandler(out, status);
    }

    public static void exit(String name, int status, PrintStream out) {
        AsyncSystem.createThread(name, status, out).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exitUncaught(Thread thread, Throwable throwable, int status, PrintStream out) {
        try {
            out.println(String.format("Uncaught exception in thread %s. Shutting down with asynchronous system exit.", thread));
            throwable.printStackTrace(out);
        }
        finally {
            AsyncSystem.exit(thread.getName(), status, out);
        }
    }

    public static void exitCaught(Thread thread, Throwable throwable, int status, PrintStream out) {
        AsyncSystem.exitCaught(thread, throwable, status, out, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exitCaught(Thread thread, Throwable throwable, int status, PrintStream out, @Nullable String message) {
        try {
            if (message == null) {
                out.println(String.format("Caught exception in thread %s. Shutting down with asynchronous system exit.", thread));
            } else {
                out.println(String.format("Caught exception in thread %s: %s. Shutting down with asynchronous system exit.", thread, message));
            }
            throwable.printStackTrace(out);
        }
        finally {
            AsyncSystem.exit(thread.getName(), status, out);
        }
    }

    private static Thread createThread(String name, int status, PrintStream out) {
        return new AsyncSystemExitThread(String.format("AsyncSystemExit[%d,%s]", status, name), status, out);
    }

    private static class AsyncSystemExitUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private final PrintStream out;
        private final int status;

        AsyncSystemExitUncaughtExceptionHandler(PrintStream out, int status) {
            Assert.neqNull(out, "out");
            this.out = out;
            this.status = status;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            AsyncSystem.exitUncaught(t, e, this.status, this.out);
        }
    }

    private static class AsyncSystemExitThread
    extends Thread {
        private final int status;

        AsyncSystemExitThread(String name, int status, PrintStream out) {
            super(name);
            this.setDaemon(true);
            this.setUncaughtExceptionHandler(new Handler(out));
            this.status = status;
        }

        @Override
        public void run() {
            System.exit(this.status);
        }
    }

    private static class Handler
    implements Thread.UncaughtExceptionHandler {
        private final PrintStream out;

        Handler(PrintStream out) {
            this.out = Objects.requireNonNull(out);
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            this.out.println(String.format("Uncaught exception in thread %s", t));
            e.printStackTrace(this.out);
        }
    }
}

