/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.text;

import io.deephaven.base.text.Convert;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.zone.ZoneOffsetTransition;
import java.time.zone.ZoneRules;
import java.util.TimeZone;

public class TimestampBuffer {
    private final ZoneRules zoneRules;
    private ThreadLocal<ThreadLocalState> threadLocals = ThreadLocal.withInitial(() -> new ThreadLocalState());

    public TimestampBuffer(TimeZone tz) {
        this.zoneRules = tz.toZoneId().getRules();
    }

    @Deprecated
    public TimestampBuffer(long localNow, TimeZone tz) {
        this(tz);
    }

    public ByteBuffer getTimestamp(long nowMillis) {
        ThreadLocalState state = this.threadLocals.get();
        state.update(nowMillis);
        state.buffer.position(0);
        return state.buffer;
    }

    public void getTimestamp(long nowMillis, ByteBuffer dest) {
        dest.put(this.getTimestamp(nowMillis));
    }

    private class ThreadLocalState {
        private long currentTimeMillis = Long.MIN_VALUE;
        private long previousDSTTransitionMillis = Long.MAX_VALUE;
        private long nextDSTTransitionMillis = Long.MIN_VALUE;
        private long gmtOffsetMillis;
        private byte[] gmtOffsetSuffix;
        private final ByteBuffer buffer = ByteBuffer.allocate(28);

        private ThreadLocalState() {
        }

        public void update(long nowMillis) {
            if (nowMillis / 60000L != this.currentTimeMillis / 60000L) {
                if (nowMillis < this.previousDSTTransitionMillis || nowMillis >= this.nextDSTTransitionMillis) {
                    this.calculateDSTTransitions(nowMillis);
                }
                this.buffer.clear();
                Convert.appendISO8601Millis(nowMillis + this.gmtOffsetMillis, this.gmtOffsetSuffix, this.buffer);
                this.buffer.flip();
            } else {
                long v = (nowMillis + this.gmtOffsetMillis) % 60000L;
                if (v < 0L) {
                    v += 60000L;
                }
                this.buffer.put(17, (byte)(48L + v / 10000L));
                this.buffer.put(18, (byte)(48L + v % 10000L / 1000L));
                this.buffer.put(20, (byte)(48L + v % 1000L / 100L));
                this.buffer.put(21, (byte)(48L + v % 100L / 10L));
                this.buffer.put(22, (byte)(48L + v % 10L));
            }
            this.currentTimeMillis = nowMillis;
        }

        private void calculateDSTTransitions(long nowMillis) {
            Instant nowInstant = Instant.ofEpochMilli(nowMillis);
            ZoneOffsetTransition previousTransitionOffset = TimestampBuffer.this.zoneRules.previousTransition(nowInstant);
            ZoneOffsetTransition nextTransitionOffset = TimestampBuffer.this.zoneRules.nextTransition(nowInstant);
            this.previousDSTTransitionMillis = previousTransitionOffset != null ? previousTransitionOffset.toEpochSecond() * 1000L : Long.MIN_VALUE;
            this.nextDSTTransitionMillis = nextTransitionOffset != null ? nextTransitionOffset.toEpochSecond() * 1000L : Long.MAX_VALUE;
            this.gmtOffsetMillis = (long)TimestampBuffer.this.zoneRules.getOffset(nowInstant).getTotalSeconds() * 1000L;
            if (this.gmtOffsetMillis == 0L) {
                this.gmtOffsetSuffix = new byte[]{90};
            } else {
                this.gmtOffsetSuffix = new byte[5];
                this.gmtOffsetSuffix[0] = (byte)(this.gmtOffsetMillis < 0L ? 45 : 43);
                int hours = (int)Math.abs(this.gmtOffsetMillis / 3600000L);
                int minutes = (int)((Math.abs(this.gmtOffsetMillis) - (long)(hours * 3600000)) / 60000L);
                this.gmtOffsetSuffix[1] = (byte)(48 + hours / 10);
                this.gmtOffsetSuffix[2] = (byte)(48 + hours % 10);
                this.gmtOffsetSuffix[3] = (byte)(48 + minutes / 10);
                this.gmtOffsetSuffix[4] = (byte)(48 + minutes % 10);
            }
        }
    }
}

