/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.verify;

import io.deephaven.base.verify.AssertionFailure;
import io.deephaven.base.verify.ExceptionMessageUtil;
import java.util.function.Consumer;

public final class Assert {
    private static volatile Consumer<AssertionFailure> onAssertionCallback;

    public static boolean setOnAssertionCallback(Consumer<AssertionFailure> newCallback) {
        boolean wasSet = onAssertionCallback != null;
        onAssertionCallback = newCallback;
        return wasSet;
    }

    private Assert() {
    }

    private static void fail(String conditionText) {
        AssertionFailure assertionFailure = new AssertionFailure(ExceptionMessageUtil.failureMessage("Assertion", "asserted", conditionText, null));
        if (onAssertionCallback != null) {
            try {
                onAssertionCallback.accept(assertionFailure);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw assertionFailure;
    }

    private static void fail(String conditionText, String detailMessage) {
        AssertionFailure assertionFailure = new AssertionFailure(ExceptionMessageUtil.failureMessage("Assertion", "asserted", conditionText, detailMessage));
        if (onAssertionCallback != null) {
            try {
                onAssertionCallback.accept(assertionFailure);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw assertionFailure;
    }

    public static void assertion(boolean condition, String conditionText) {
        if (!condition) {
            Assert.fail(conditionText);
        }
    }

    public static void assertion(boolean condition, String conditionText, String detailMessage) {
        if (!condition) {
            Assert.fail(conditionText, detailMessage);
        }
    }

    public static void assertion(boolean condition, String conditionText, Object o0, String name0) {
        if (!condition) {
            Assert.fail(conditionText, ExceptionMessageUtil.valueAndName(o0, name0));
        }
    }

    public static void assertion(boolean condition, String conditionText, Object o0, String name0, Object o1, String name1) {
        if (!condition) {
            Assert.fail(conditionText, ExceptionMessageUtil.valueAndName(o0, name0, o1, name1));
        }
    }

    public static void assertion(boolean condition, String conditionText, Object o0, String name0, Object o1, String name1, Object o2, String name2) {
        if (!condition) {
            Assert.fail(conditionText, ExceptionMessageUtil.valueAndName(o0, name0, o1, name1, o2, name2));
        }
    }

    public static void assertion(boolean condition, String conditionText, Object o0, String name0, Object o1, String name1, int i2, String name2) {
        if (!condition) {
            Assert.fail(conditionText, ExceptionMessageUtil.concat(ExceptionMessageUtil.valueAndName(o0, name0, o1, name1), ExceptionMessageUtil.valueAndName(i2, name2)));
        }
    }

    public static void assertion(boolean condition, String conditionText, Object o0, String name0, Object o1, String name1, Object o2, String name2, Object o3, String name3) {
        if (!condition) {
            Assert.fail(conditionText, ExceptionMessageUtil.valueAndName(o0, name0, o1, name1, o2, name2, o3, name3));
        }
    }

    public static void assertion(boolean condition, String conditionText, boolean b0, String name0) {
        if (!condition) {
            Assert.fail(conditionText, ExceptionMessageUtil.valueAndName(b0, name0));
        }
    }

    public static void assertion(boolean condition, String conditionText, boolean b0, String name0, boolean b1, String name1) {
        if (!condition) {
            Assert.fail(conditionText, ExceptionMessageUtil.valueAndName(b0, name0, b1, name1));
        }
    }

    public static void assertion(boolean condition, String conditionText, boolean b0, String name0, boolean b1, String name1, boolean b2, String name2) {
        if (!condition) {
            Assert.fail(conditionText, ExceptionMessageUtil.valueAndName(b0, name0, b1, name1, b2, name2));
        }
    }

    public static void assertion(boolean condition, String conditionText, boolean b0, String name0, boolean b1, String name1, boolean b2, String name2, boolean b3, String name3) {
        if (!condition) {
            Assert.fail(conditionText, ExceptionMessageUtil.valueAndName(b0, name0, b1, name1, b2, name2, b3, name3));
        }
    }

    public static void assertion(boolean condition, String conditionText, int i0, String name0) {
        if (!condition) {
            Assert.fail(conditionText, ExceptionMessageUtil.valueAndName(i0, name0));
        }
    }

    public static void assertion(boolean condition, String conditionText, int i0, String name0, int i1, String name1) {
        if (!condition) {
            Assert.fail(conditionText, ExceptionMessageUtil.valueAndName(i0, name0, i1, name1));
        }
    }

    public static AssertionFailure statementNeverExecuted() {
        Assert.fail("statement is never executed");
        return null;
    }

    public static AssertionFailure statementNeverExecuted(String statementDescription) {
        Assert.fail(statementDescription + " is never executed");
        return null;
    }

    public static AssertionFailure exceptionNeverCaught(Exception e) {
        try {
            Assert.fail(e.getClass().getName() + " is never caught", e.getClass().getName() + "(" + e.getMessage() + ") caught");
        }
        catch (AssertionFailure assertionFailure) {
            assertionFailure.initCause(e);
            throw assertionFailure;
        }
        return null;
    }

    public static AssertionFailure exceptionNeverCaught(String tryStatementDescription, Exception e) {
        try {
            Assert.fail(tryStatementDescription + " succeeds", e.getClass().getName() + "(" + e.getMessage() + ") caught");
        }
        catch (AssertionFailure assertionFailure) {
            assertionFailure.initCause(e);
            throw assertionFailure;
        }
        return null;
    }

    public static AssertionFailure valueNeverOccurs(Object o, String name) {
        Assert.fail(ExceptionMessageUtil.valueAndName(o, name) + " never occurs");
        return null;
    }

    public static AssertionFailure valueNeverOccurs(boolean b, String name) {
        Assert.fail(ExceptionMessageUtil.valueAndName(b, name) + " never occurs");
        return null;
    }

    public static AssertionFailure valueNeverOccurs(char c, String name) {
        Assert.fail(ExceptionMessageUtil.valueAndName(c, name) + " never occurs");
        return null;
    }

    public static AssertionFailure valueNeverOccurs(byte b, String name) {
        Assert.fail(ExceptionMessageUtil.valueAndName(b, name) + " never occurs");
        return null;
    }

    public static AssertionFailure valueNeverOccurs(short s, String name) {
        Assert.fail(ExceptionMessageUtil.valueAndName(s, name) + " never occurs");
        return null;
    }

    public static AssertionFailure valueNeverOccurs(int i, String name) {
        Assert.fail(ExceptionMessageUtil.valueAndName(i, name) + " never occurs");
        return null;
    }

    public static AssertionFailure valueNeverOccurs(long l, String name) {
        Assert.fail(ExceptionMessageUtil.valueAndName(l, name) + " never occurs");
        return null;
    }

    public static AssertionFailure valueNeverOccurs(float f, String name) {
        Assert.fail(ExceptionMessageUtil.valueAndName(f, name) + " never occurs");
        return null;
    }

    public static AssertionFailure valueNeverOccurs(double d, String name) {
        Assert.fail(ExceptionMessageUtil.valueAndName(d, name) + " never occurs");
        return null;
    }

    public static void eq(boolean b0, String name0, boolean b1, String name1) {
        if (b0 != b1) {
            Assert.fail(name0 + " == " + name1, ExceptionMessageUtil.valueAndName(b0, name0, b1, name1));
        }
    }

    public static void eq(boolean b0, String name0, boolean b1) {
        if (b0 != b1) {
            Assert.fail(name0 + " == " + b1, ExceptionMessageUtil.valueAndName(b0, name0));
        }
    }

    public static void eq(char c0, String name0, char c1, String name1) {
        if (c0 != c1) {
            Assert.fail(name0 + " == " + name1, ExceptionMessageUtil.valueAndName(c0, name0, c1, name1));
        }
    }

    public static void eq(char c0, String name0, char c1) {
        if (c0 != c1) {
            Assert.fail(name0 + " == " + ExceptionMessageUtil.valueString(c1), ExceptionMessageUtil.valueAndName(c0, name0));
        }
    }

    public static void eq(byte b0, String name0, byte b1, String name1) {
        if (b0 != b1) {
            Assert.fail(name0 + " == " + name1, ExceptionMessageUtil.valueAndName(b0, name0, b1, name1));
        }
    }

    public static void eq(byte b0, String name0, byte b1) {
        if (b0 != b1) {
            Assert.fail(name0 + " == " + b1, ExceptionMessageUtil.valueAndName(b0, name0));
        }
    }

    public static void eq(short s0, String name0, short s1, String name1) {
        if (s0 != s1) {
            Assert.fail(name0 + " == " + name1, ExceptionMessageUtil.valueAndName(s0, name0, s1, name1));
        }
    }

    public static void eq(short s0, String name0, short s1) {
        if (s0 != s1) {
            Assert.fail(name0 + " == " + s1, ExceptionMessageUtil.valueAndName(s0, name0));
        }
    }

    public static void eq(int i0, String name0, int i1, String name1) {
        if (i0 != i1) {
            Assert.fail(name0 + " == " + name1, ExceptionMessageUtil.valueAndName(i0, name0, i1, name1));
        }
    }

    public static void eq(int i0, String name0, int i1) {
        if (i0 != i1) {
            Assert.fail(name0 + " == " + i1, ExceptionMessageUtil.valueAndName(i0, name0));
        }
    }

    public static void eq(long l0, String name0, long l1, String name1) {
        if (l0 != l1) {
            Assert.fail(name0 + " == " + name1, ExceptionMessageUtil.valueAndName(l0, name0, l1, name1));
        }
    }

    public static void eq(long l0, String name0, long l1) {
        if (l0 != l1) {
            Assert.fail(name0 + " == " + l1, ExceptionMessageUtil.valueAndName(l0, name0));
        }
    }

    public static void eq(float f0, String name0, float f1, String name1) {
        if (f0 != f1) {
            Assert.fail(name0 + " == " + name1, ExceptionMessageUtil.valueAndName(f0, name0, f1, name1));
        }
    }

    public static void eq(float f0, String name0, float f1) {
        if (f0 != f1) {
            Assert.fail(name0 + " == " + f1, ExceptionMessageUtil.valueAndName(f0, name0));
        }
    }

    public static void eq(double d0, String name0, double d1, String name1) {
        if (d0 != d1) {
            Assert.fail(name0 + " == " + name1, ExceptionMessageUtil.valueAndName(d0, name0, d1, name1));
        }
    }

    public static void eq(double d0, String name0, double d1) {
        if (d0 != d1) {
            Assert.fail(name0 + " == " + d1, ExceptionMessageUtil.valueAndName(d0, name0));
        }
    }

    public static void neq(boolean b0, String name0, boolean b1, String name1) {
        if (b0 == b1) {
            Assert.fail(name0 + " != " + name1, ExceptionMessageUtil.valueAndName(b0, name0, b1, name1));
        }
    }

    public static void neq(boolean b0, String name0, boolean b1) {
        if (b0 == b1) {
            Assert.fail(name0 + " != " + b1, ExceptionMessageUtil.valueAndName(b0, name0));
        }
    }

    public static void neq(char c0, String name0, char c1, String name1) {
        if (c0 == c1) {
            Assert.fail(name0 + " != " + name1, ExceptionMessageUtil.valueAndName(c0, name0, c1, name1));
        }
    }

    public static void neq(char c0, String name0, char c1) {
        if (c0 == c1) {
            Assert.fail(name0 + " != " + ExceptionMessageUtil.valueString(c1), ExceptionMessageUtil.valueAndName(c0, name0));
        }
    }

    public static void neq(byte b0, String name0, byte b1, String name1) {
        if (b0 == b1) {
            Assert.fail(name0 + " != " + name1, ExceptionMessageUtil.valueAndName(b0, name0, b1, name1));
        }
    }

    public static void neq(byte b0, String name0, byte b1) {
        if (b0 == b1) {
            Assert.fail(name0 + " != " + b1, ExceptionMessageUtil.valueAndName(b0, name0));
        }
    }

    public static void neq(short s0, String name0, short s1, String name1) {
        if (s0 == s1) {
            Assert.fail(name0 + " != " + name1, ExceptionMessageUtil.valueAndName(s0, name0, s1, name1));
        }
    }

    public static void neq(short s0, String name0, short s1) {
        if (s0 == s1) {
            Assert.fail(name0 + " != " + s1, ExceptionMessageUtil.valueAndName(s0, name0));
        }
    }

    public static void neq(int i0, String name0, int i1, String name1) {
        if (i0 == i1) {
            Assert.fail(name0 + " != " + name1, ExceptionMessageUtil.valueAndName(i0, name0, i1, name1));
        }
    }

    public static void neq(int i0, String name0, int i1) {
        if (i0 == i1) {
            Assert.fail(name0 + " != " + i1, ExceptionMessageUtil.valueAndName(i0, name0));
        }
    }

    public static void neq(long l0, String name0, long l1, String name1) {
        if (l0 == l1) {
            Assert.fail(name0 + " != " + name1, ExceptionMessageUtil.valueAndName(l0, name0, l1, name1));
        }
    }

    public static void neq(long l0, String name0, long l1) {
        if (l0 == l1) {
            Assert.fail(name0 + " != " + l1, ExceptionMessageUtil.valueAndName(l0, name0));
        }
    }

    public static void neq(float f0, String name0, float f1, String name1) {
        if (f0 == f1) {
            Assert.fail(name0 + " != " + name1, ExceptionMessageUtil.valueAndName(f0, name0, f1, name1));
        }
    }

    public static void neq(float f0, String name0, float f1) {
        if (f0 == f1) {
            Assert.fail(name0 + " != " + f1, ExceptionMessageUtil.valueAndName(f0, name0));
        }
    }

    public static void neq(double d0, String name0, double d1, String name1) {
        if (d0 == d1) {
            Assert.fail(name0 + " != " + name1, ExceptionMessageUtil.valueAndName(d0, name0, d1, name1));
        }
    }

    public static void neq(double d0, String name0, double d1) {
        if (d0 == d1) {
            Assert.fail(name0 + " != " + d1, ExceptionMessageUtil.valueAndName(d0, name0));
        }
    }

    public static void lt(char c0, String name0, char c1, String name1) {
        if (c0 >= c1) {
            Assert.fail(name0 + " < " + name1, ExceptionMessageUtil.valueAndName(c0, name0, c1, name1));
        }
    }

    public static void lt(char c0, String name0, char c1) {
        if (c0 >= c1) {
            Assert.fail(name0 + " < " + ExceptionMessageUtil.valueString(c1), ExceptionMessageUtil.valueAndName(c0, name0));
        }
    }

    public static void lt(byte b0, String name0, byte b1, String name1) {
        if (b0 >= b1) {
            Assert.fail(name0 + " < " + name1, ExceptionMessageUtil.valueAndName(b0, name0, b1, name1));
        }
    }

    public static void lt(byte b0, String name0, byte b1) {
        if (b0 >= b1) {
            Assert.fail(name0 + " < " + b1, ExceptionMessageUtil.valueAndName(b0, name0));
        }
    }

    public static void lt(short s0, String name0, short s1, String name1) {
        if (s0 >= s1) {
            Assert.fail(name0 + " < " + name1, ExceptionMessageUtil.valueAndName(s0, name0, s1, name1));
        }
    }

    public static void lt(short s0, String name0, short s1) {
        if (s0 >= s1) {
            Assert.fail(name0 + " < " + s1, ExceptionMessageUtil.valueAndName(s0, name0));
        }
    }

    public static void lt(int i0, String name0, int i1, String name1) {
        if (i0 >= i1) {
            Assert.fail(name0 + " < " + name1, ExceptionMessageUtil.valueAndName(i0, name0, i1, name1));
        }
    }

    public static void lt(int i0, String name0, int i1) {
        if (i0 >= i1) {
            Assert.fail(name0 + " < " + i1, ExceptionMessageUtil.valueAndName(i0, name0));
        }
    }

    public static void lt(long l0, String name0, long l1, String name1) {
        if (l0 >= l1) {
            Assert.fail(name0 + " < " + name1, ExceptionMessageUtil.valueAndName(l0, name0, l1, name1));
        }
    }

    public static void lt(long l0, String name0, long l1) {
        if (l0 >= l1) {
            Assert.fail(name0 + " < " + l1, ExceptionMessageUtil.valueAndName(l0, name0));
        }
    }

    public static void lt(float f0, String name0, float f1, String name1) {
        if (!(f0 < f1)) {
            Assert.fail(name0 + " < " + name1, ExceptionMessageUtil.valueAndName(f0, name0, f1, name1));
        }
    }

    public static void lt(float f0, String name0, float f1) {
        if (!(f0 < f1)) {
            Assert.fail(name0 + " < " + f1, ExceptionMessageUtil.valueAndName(f0, name0));
        }
    }

    public static void lt(double d0, String name0, double d1, String name1) {
        if (!(d0 < d1)) {
            Assert.fail(name0 + " < " + name1, ExceptionMessageUtil.valueAndName(d0, name0, d1, name1));
        }
    }

    public static void lt(double d0, String name0, double d1) {
        if (!(d0 < d1)) {
            Assert.fail(name0 + " < " + d1, ExceptionMessageUtil.valueAndName(d0, name0));
        }
    }

    public static void leq(char c0, String name0, char c1, String name1) {
        if (c0 > c1) {
            Assert.fail(name0 + " <= " + name1, ExceptionMessageUtil.valueAndName(c0, name0, c1, name1));
        }
    }

    public static void leq(char c0, String name0, char c1) {
        if (c0 > c1) {
            Assert.fail(name0 + " <= " + ExceptionMessageUtil.valueString(c1), ExceptionMessageUtil.valueAndName(c0, name0));
        }
    }

    public static void leq(byte b0, String name0, byte b1, String name1) {
        if (b0 > b1) {
            Assert.fail(name0 + " <= " + name1, ExceptionMessageUtil.valueAndName(b0, name0, b1, name1));
        }
    }

    public static void leq(byte b0, String name0, byte b1) {
        if (b0 > b1) {
            Assert.fail(name0 + " <= " + b1, ExceptionMessageUtil.valueAndName(b0, name0));
        }
    }

    public static void leq(short s0, String name0, short s1, String name1) {
        if (s0 > s1) {
            Assert.fail(name0 + " <= " + name1, ExceptionMessageUtil.valueAndName(s0, name0, s1, name1));
        }
    }

    public static void leq(short s0, String name0, short s1) {
        if (s0 > s1) {
            Assert.fail(name0 + " <= " + s1, ExceptionMessageUtil.valueAndName(s0, name0));
        }
    }

    public static void leq(int i0, String name0, int i1, String name1) {
        if (i0 > i1) {
            Assert.fail(name0 + " <= " + name1, ExceptionMessageUtil.valueAndName(i0, name0, i1, name1));
        }
    }

    public static void leq(int i0, String name0, int i1) {
        if (i0 > i1) {
            Assert.fail(name0 + " <= " + i1, ExceptionMessageUtil.valueAndName(i0, name0));
        }
    }

    public static void leq(long l0, String name0, long l1, String name1) {
        if (l0 > l1) {
            Assert.fail(name0 + " <= " + name1, ExceptionMessageUtil.valueAndName(l0, name0, l1, name1));
        }
    }

    public static void leq(long l0, String name0, long l1) {
        if (l0 > l1) {
            Assert.fail(name0 + " <= " + l1, ExceptionMessageUtil.valueAndName(l0, name0));
        }
    }

    public static void leq(float f0, String name0, float f1, String name1) {
        if (!(f0 <= f1)) {
            Assert.fail(name0 + " <= " + name1, ExceptionMessageUtil.valueAndName(f0, name0, f1, name1));
        }
    }

    public static void leq(float f0, String name0, float f1) {
        if (!(f0 <= f1)) {
            Assert.fail(name0 + " <= " + f1, ExceptionMessageUtil.valueAndName(f0, name0));
        }
    }

    public static void leq(double d0, String name0, double d1, String name1) {
        if (!(d0 <= d1)) {
            Assert.fail(name0 + " <= " + name1, ExceptionMessageUtil.valueAndName(d0, name0, d1, name1));
        }
    }

    public static void leq(double d0, String name0, double d1) {
        if (!(d0 <= d1)) {
            Assert.fail(name0 + " <= " + d1, ExceptionMessageUtil.valueAndName(d0, name0));
        }
    }

    public static void gt(char c0, String name0, char c1, String name1) {
        if (c0 <= c1) {
            Assert.fail(name0 + " > " + name1, ExceptionMessageUtil.valueAndName(c0, name0, c1, name1));
        }
    }

    public static void gt(char c0, String name0, char c1) {
        if (c0 <= c1) {
            Assert.fail(name0 + " > " + ExceptionMessageUtil.valueString(c1), ExceptionMessageUtil.valueAndName(c0, name0));
        }
    }

    public static void gt(byte b0, String name0, byte b1, String name1) {
        if (b0 <= b1) {
            Assert.fail(name0 + " > " + name1, ExceptionMessageUtil.valueAndName(b0, name0, b1, name1));
        }
    }

    public static void gt(byte b0, String name0, byte b1) {
        if (b0 <= b1) {
            Assert.fail(name0 + " > " + b1, ExceptionMessageUtil.valueAndName(b0, name0));
        }
    }

    public static void gt(short s0, String name0, short s1, String name1) {
        if (s0 <= s1) {
            Assert.fail(name0 + " > " + name1, ExceptionMessageUtil.valueAndName(s0, name0, s1, name1));
        }
    }

    public static void gt(short s0, String name0, short s1) {
        if (s0 <= s1) {
            Assert.fail(name0 + " > " + s1, ExceptionMessageUtil.valueAndName(s0, name0));
        }
    }

    public static void gt(int i0, String name0, int i1, String name1) {
        if (i0 <= i1) {
            Assert.fail(name0 + " > " + name1, ExceptionMessageUtil.valueAndName(i0, name0, i1, name1));
        }
    }

    public static void gt(int i0, String name0, int i1) {
        if (i0 <= i1) {
            Assert.fail(name0 + " > " + i1, ExceptionMessageUtil.valueAndName(i0, name0));
        }
    }

    public static void gt(long l0, String name0, long l1, String name1) {
        if (l0 <= l1) {
            Assert.fail(name0 + " > " + name1, ExceptionMessageUtil.valueAndName(l0, name0, l1, name1));
        }
    }

    public static void gt(long l0, String name0, long l1) {
        if (l0 <= l1) {
            Assert.fail(name0 + " > " + l1, ExceptionMessageUtil.valueAndName(l0, name0));
        }
    }

    public static void gt(float f0, String name0, float f1, String name1) {
        if (!(f0 > f1)) {
            Assert.fail(name0 + " > " + name1, ExceptionMessageUtil.valueAndName(f0, name0, f1, name1));
        }
    }

    public static void gt(float f0, String name0, float f1) {
        if (!(f0 > f1)) {
            Assert.fail(name0 + " > " + f1, ExceptionMessageUtil.valueAndName(f0, name0));
        }
    }

    public static void gt(double d0, String name0, double d1, String name1) {
        if (!(d0 > d1)) {
            Assert.fail(name0 + " > " + name1, ExceptionMessageUtil.valueAndName(d0, name0, d1, name1));
        }
    }

    public static void gt(double d0, String name0, double d1) {
        if (!(d0 > d1)) {
            Assert.fail(name0 + " > " + d1, ExceptionMessageUtil.valueAndName(d0, name0));
        }
    }

    public static void geq(char c0, String name0, char c1, String name1) {
        if (c0 < c1) {
            Assert.fail(name0 + " >= " + name1, ExceptionMessageUtil.valueAndName(c0, name0, c1, name1));
        }
    }

    public static void geq(char c0, String name0, char c1) {
        if (c0 < c1) {
            Assert.fail(name0 + " >= " + ExceptionMessageUtil.valueString(c1), ExceptionMessageUtil.valueAndName(c0, name0));
        }
    }

    public static void geq(byte b0, String name0, byte b1, String name1) {
        if (b0 < b1) {
            Assert.fail(name0 + " >= " + name1, ExceptionMessageUtil.valueAndName(b0, name0, b1, name1));
        }
    }

    public static void geq(byte b0, String name0, byte b1) {
        if (b0 < b1) {
            Assert.fail(name0 + " >= " + b1, ExceptionMessageUtil.valueAndName(b0, name0));
        }
    }

    public static void geq(short s0, String name0, short s1, String name1) {
        if (s0 < s1) {
            Assert.fail(name0 + " >= " + name1, ExceptionMessageUtil.valueAndName(s0, name0, s1, name1));
        }
    }

    public static void geq(short s0, String name0, short s1) {
        if (s0 < s1) {
            Assert.fail(name0 + " >= " + s1, ExceptionMessageUtil.valueAndName(s0, name0));
        }
    }

    public static void geq(int i0, String name0, int i1, String name1) {
        if (i0 < i1) {
            Assert.fail(name0 + " >= " + name1, ExceptionMessageUtil.valueAndName(i0, name0, i1, name1));
        }
    }

    public static void geq(int i0, String name0, int i1) {
        if (i0 < i1) {
            Assert.fail(name0 + " >= " + i1, ExceptionMessageUtil.valueAndName(i0, name0));
        }
    }

    public static void geq(long l0, String name0, long l1, String name1) {
        if (l0 < l1) {
            Assert.fail(name0 + " >= " + name1, ExceptionMessageUtil.valueAndName(l0, name0, l1, name1));
        }
    }

    public static void geq(long l0, String name0, long l1) {
        if (l0 < l1) {
            Assert.fail(name0 + " >= " + l1, ExceptionMessageUtil.valueAndName(l0, name0));
        }
    }

    public static void geq(float f0, String name0, float f1, String name1) {
        if (!(f0 >= f1)) {
            Assert.fail(name0 + " >= " + name1, ExceptionMessageUtil.valueAndName(f0, name0, f1, name1));
        }
    }

    public static void geq(float f0, String name0, float f1) {
        if (!(f0 >= f1)) {
            Assert.fail(name0 + " >= " + f1, ExceptionMessageUtil.valueAndName(f0, name0));
        }
    }

    public static void geq(double d0, String name0, double d1, String name1) {
        if (!(d0 >= d1)) {
            Assert.fail(name0 + " >= " + name1, ExceptionMessageUtil.valueAndName(d0, name0, d1, name1));
        }
    }

    public static void geq(double d0, String name0, double d1) {
        if (!(d0 >= d1)) {
            Assert.fail(name0 + " >= " + d1, ExceptionMessageUtil.valueAndName(d0, name0));
        }
    }

    public static void eqFalse(boolean b, String name) {
        if (b) {
            Assert.fail(name + " == false", ExceptionMessageUtil.valueAndName(b, name));
        }
    }

    public static void neqFalse(boolean b, String name) {
        if (!b) {
            Assert.fail(name + " != false", ExceptionMessageUtil.valueAndName(b, name));
        }
    }

    public static void eqTrue(boolean b, String name) {
        if (!b) {
            Assert.fail(name + " == true", ExceptionMessageUtil.valueAndName(b, name));
        }
    }

    public static void neqTrue(boolean b, String name) {
        if (b) {
            Assert.fail(name + " != true", ExceptionMessageUtil.valueAndName(b, name));
        }
    }

    public static void eqZero(char c, String name) {
        if ('\u0000' != c) {
            Assert.fail(name + " == 0", ExceptionMessageUtil.valueAndName(c, name));
        }
    }

    public static void eqZero(byte b, String name) {
        if (0 != b) {
            Assert.fail(name + " == 0", ExceptionMessageUtil.valueAndName(b, name));
        }
    }

    public static void eqZero(short s, String name) {
        if (0 != s) {
            Assert.fail(name + " == 0", ExceptionMessageUtil.valueAndName(s, name));
        }
    }

    public static void eqZero(int i, String name) {
        if (0 != i) {
            Assert.fail(name + " == 0", ExceptionMessageUtil.valueAndName(i, name));
        }
    }

    public static void eqZero(long l, String name) {
        if (0L != l) {
            Assert.fail(name + " == 0", ExceptionMessageUtil.valueAndName(l, name));
        }
    }

    public static void eqZero(float f, String name) {
        if (0.0f != f) {
            Assert.fail(name + " == 0", ExceptionMessageUtil.valueAndName(f, name));
        }
    }

    public static void eqZero(double d, String name) {
        if (0.0 != d) {
            Assert.fail(name + " == 0", ExceptionMessageUtil.valueAndName(d, name));
        }
    }

    public static void neqZero(char c, String name) {
        if ('\u0000' == c) {
            Assert.fail(name + " != 0", ExceptionMessageUtil.valueAndName(c, name));
        }
    }

    public static void neqZero(byte b, String name) {
        if (0 == b) {
            Assert.fail(name + " != 0", ExceptionMessageUtil.valueAndName(b, name));
        }
    }

    public static void neqZero(short s, String name) {
        if (0 == s) {
            Assert.fail(name + " != 0", ExceptionMessageUtil.valueAndName(s, name));
        }
    }

    public static void neqZero(int i, String name) {
        if (0 == i) {
            Assert.fail(name + " != 0", ExceptionMessageUtil.valueAndName(i, name));
        }
    }

    public static void neqZero(long l, String name) {
        if (0L == l) {
            Assert.fail(name + " != 0", ExceptionMessageUtil.valueAndName(l, name));
        }
    }

    public static void neqZero(float f, String name) {
        if (0.0f == f) {
            Assert.fail(name + " != 0", ExceptionMessageUtil.valueAndName(f, name));
        }
    }

    public static void neqZero(double d, String name) {
        if (0.0 == d) {
            Assert.fail(name + " != 0", ExceptionMessageUtil.valueAndName(d, name));
        }
    }

    public static void ltZero(byte b, String name) {
        if (b >= 0) {
            Assert.fail(name + " < 0", ExceptionMessageUtil.valueAndName(b, name));
        }
    }

    public static void ltZero(short s, String name) {
        if (s >= 0) {
            Assert.fail(name + " < 0", ExceptionMessageUtil.valueAndName(s, name));
        }
    }

    public static void ltZero(int i, String name) {
        if (i >= 0) {
            Assert.fail(name + " < 0", ExceptionMessageUtil.valueAndName(i, name));
        }
    }

    public static void ltZero(long l, String name) {
        if (l >= 0L) {
            Assert.fail(name + " < 0", ExceptionMessageUtil.valueAndName(l, name));
        }
    }

    public static void ltZero(float f, String name) {
        if (!(f < 0.0f)) {
            Assert.fail(name + " < 0", ExceptionMessageUtil.valueAndName(f, name));
        }
    }

    public static void ltZero(double d, String name) {
        if (!(d < 0.0)) {
            Assert.fail(name + " < 0", ExceptionMessageUtil.valueAndName(d, name));
        }
    }

    public static void leqZero(byte b, String name) {
        if (b > 0) {
            Assert.fail(name + " <= 0", ExceptionMessageUtil.valueAndName(b, name));
        }
    }

    public static void leqZero(short s, String name) {
        if (s > 0) {
            Assert.fail(name + " <= 0", ExceptionMessageUtil.valueAndName(s, name));
        }
    }

    public static void leqZero(int i, String name) {
        if (i > 0) {
            Assert.fail(name + " <= 0", ExceptionMessageUtil.valueAndName(i, name));
        }
    }

    public static void leqZero(long l, String name) {
        if (l > 0L) {
            Assert.fail(name + " <= 0", ExceptionMessageUtil.valueAndName(l, name));
        }
    }

    public static void leqZero(float f, String name) {
        if (!(f <= 0.0f)) {
            Assert.fail(name + " <= 0", ExceptionMessageUtil.valueAndName(f, name));
        }
    }

    public static void leqZero(double d, String name) {
        if (!(d <= 0.0)) {
            Assert.fail(name + " <= 0", ExceptionMessageUtil.valueAndName(d, name));
        }
    }

    public static void gtZero(byte b, String name) {
        if (b <= 0) {
            Assert.fail(name + " > 0", ExceptionMessageUtil.valueAndName(b, name));
        }
    }

    public static void gtZero(short s, String name) {
        if (s <= 0) {
            Assert.fail(name + " > 0", ExceptionMessageUtil.valueAndName(s, name));
        }
    }

    public static void gtZero(int i, String name) {
        if (i <= 0) {
            Assert.fail(name + " > 0", ExceptionMessageUtil.valueAndName(i, name));
        }
    }

    public static void gtZero(long l, String name) {
        if (l <= 0L) {
            Assert.fail(name + " > 0", ExceptionMessageUtil.valueAndName(l, name));
        }
    }

    public static void gtZero(float f, String name) {
        if (!(f > 0.0f)) {
            Assert.fail(name + " > 0", ExceptionMessageUtil.valueAndName(f, name));
        }
    }

    public static void gtZero(double d, String name) {
        if (!(d > 0.0)) {
            Assert.fail(name + " > 0", ExceptionMessageUtil.valueAndName(d, name));
        }
    }

    public static void geqZero(byte b, String name) {
        if (b < 0) {
            Assert.fail(name + " >= 0", ExceptionMessageUtil.valueAndName(b, name));
        }
    }

    public static void geqZero(short s, String name) {
        if (s < 0) {
            Assert.fail(name + " >= 0", ExceptionMessageUtil.valueAndName(s, name));
        }
    }

    public static void geqZero(int i, String name) {
        if (i < 0) {
            Assert.fail(name + " >= 0", ExceptionMessageUtil.valueAndName(i, name));
        }
    }

    public static void geqZero(long l, String name) {
        if (l < 0L) {
            Assert.fail(name + " >= 0", ExceptionMessageUtil.valueAndName(l, name));
        }
    }

    public static void geqZero(float f, String name) {
        if (!(f >= 0.0f)) {
            Assert.fail(name + " >= 0", ExceptionMessageUtil.valueAndName(f, name));
        }
    }

    public static void geqZero(double d, String name) {
        if (!(d >= 0.0)) {
            Assert.fail(name + " >= 0", ExceptionMessageUtil.valueAndName(d, name));
        }
    }

    public static void eq(Object o0, String name0, Object o1, String name1) {
        if (o0 != o1) {
            Assert.fail(name0 + " == " + name1, ExceptionMessageUtil.valueAndName(o0, name0, o1, name1));
        }
    }

    public static void eq(Object o0, String name0, Object o1) {
        if (o0 != o1) {
            Assert.fail(name0 + " == " + ExceptionMessageUtil.valueString(o1), ExceptionMessageUtil.valueAndName(o0, name0));
        }
    }

    public static void neq(Object o0, String name0, Object o1, String name1) {
        if (o0 == o1) {
            Assert.fail(name0 + " != " + name1, ExceptionMessageUtil.valueAndName(o0, name0, o1, name1));
        }
    }

    public static void neq(Object o0, String name0, Object o1) {
        if (o0 == o1) {
            Assert.fail(name0 + " != " + ExceptionMessageUtil.valueString(o1), ExceptionMessageUtil.valueAndName(o0, name0));
        }
    }

    public static void eqNull(Object o, String name) {
        if (null != o) {
            Assert.fail(name + " == null", ExceptionMessageUtil.valueAndName(o, name));
        }
    }

    public static void neqNull(Object o, String name) {
        if (null == o) {
            Assert.fail(name + " != null", ExceptionMessageUtil.valueAndName(o, name));
        }
    }

    public static void eqNaN(double d, String name) {
        if (!Double.isNaN(d)) {
            Assert.fail(name + " == NaN", ExceptionMessageUtil.valueAndName(d, name));
        }
    }

    public static void neqNaN(double d, String name) {
        if (Double.isNaN(d)) {
            Assert.fail(name + " != NaN", ExceptionMessageUtil.valueAndName(d, name));
        }
    }

    public static void equals(Object o0, String name0, Object o1, String name1) {
        Assert.neqNull(o0, name0);
        Assert.neqNull(o1, name1);
        if (!o0.equals(o1)) {
            Assert.fail(name0 + ".equals(" + name1 + ")", ExceptionMessageUtil.valueAndName(o0, name0, o1, name1));
        }
    }

    public static void equals(Object o0, String name0, Object o1) {
        Assert.neqNull(o0, name0);
        Assert.neqNull(o1, "o1");
        if (!o0.equals(o1)) {
            Assert.fail(name0 + ".equals(" + ExceptionMessageUtil.valueString(o1) + ")", ExceptionMessageUtil.valueAndName(o0, name0));
        }
    }

    public static void nullSafeEquals(Object o0, String name0, Object o1, String name1) {
        if (null == o0 && null != o1 || null != o1 && !o0.equals(o1)) {
            Assert.fail(name0 + ".equals(" + name1 + ")", ExceptionMessageUtil.valueAndName(o0, name0, o1, name1));
        }
    }

    public static void notEquals(Object o0, String name0, Object o1, String name1) {
        Assert.neqNull(o0, name0);
        Assert.neqNull(o1, name1);
        if (o0.equals(o1)) {
            Assert.fail("!" + name0 + ".equals(" + name1 + ")", ExceptionMessageUtil.valueAndName(o0, name0, o1, name1));
        }
    }

    public static void notEquals(Object o0, String name0, Object o1) {
        Assert.neqNull(o0, name0);
        Assert.neqNull(o1, "o1");
        if (o0.equals(o1)) {
            Assert.fail("!" + name0 + ".equals(" + ExceptionMessageUtil.valueString(o1) + ")", ExceptionMessageUtil.valueAndName(o0, name0));
        }
    }

    public static void nonempty(String s, String name) {
        Assert.neqNull(s, name);
        if (s.length() <= 0) {
            Assert.fail(name + ".length() > 0", ExceptionMessageUtil.valueAndName(s, name));
        }
    }

    public static <TYPE> TYPE neverInvoked(TYPE t1, TYPE t2) {
        throw Assert.statementNeverExecuted();
    }
}

