/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.base.verify;

import io.deephaven.base.verify.ExceptionMessageUtil;
import io.deephaven.base.verify.RequirementFailure;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public final class Require {
    private static volatile Consumer<RequirementFailure> onFailureCallback;

    public static boolean setOnFailureCallback(Consumer<RequirementFailure> newCallback) {
        boolean wasSet = onFailureCallback != null;
        onFailureCallback = newCallback;
        return wasSet;
    }

    private Require() {
    }

    private static void fail(String conditionText) {
        RequirementFailure requirementFailure = new RequirementFailure(ExceptionMessageUtil.failureMessage("Requirement", "required", conditionText, null));
        if (onFailureCallback != null) {
            try {
                onFailureCallback.accept(requirementFailure);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw requirementFailure;
    }

    private static void fail(String conditionText, String detailMessage) {
        RequirementFailure requirementFailure = new RequirementFailure(ExceptionMessageUtil.failureMessage("Requirement", "required", conditionText, detailMessage));
        if (onFailureCallback != null) {
            try {
                onFailureCallback.accept(requirementFailure);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw requirementFailure;
    }

    public static void requirement(boolean condition, String conditionText) {
        if (!condition) {
            Require.fail(conditionText);
        }
    }

    public static void requirement(boolean condition, String conditionText, String detailMessage) {
        if (!condition) {
            Require.fail(conditionText, detailMessage);
        }
    }

    public static void requirement(boolean condition, String conditionText, Object o0, String name0) {
        if (!condition) {
            Require.fail(conditionText, ExceptionMessageUtil.valueAndName(o0, name0));
        }
    }

    public static void requirement(boolean condition, String conditionText, Object o0, String name0, Object o1, String name1) {
        if (!condition) {
            Require.fail(conditionText, ExceptionMessageUtil.valueAndName(o0, name0, o1, name1));
        }
    }

    public static void requirement(boolean condition, String conditionText, Object o0, String name0, Object o1, String name1, Object o2, String name2) {
        if (!condition) {
            Require.fail(conditionText, ExceptionMessageUtil.valueAndName(o0, name0, o1, name1, o2, name2));
        }
    }

    public static void requirement(boolean condition, String conditionText, long o0, String name0, long o1, String name1, long o2, String name2) {
        if (!condition) {
            Require.fail(conditionText, ExceptionMessageUtil.valueAndName(o0, name0, o1, name1, o2, name2));
        }
    }

    public static void requirement(boolean condition, String conditionText, Object o0, String name0, Object o1, String name1, Object o2, String name2, Object o3, String name3) {
        if (!condition) {
            Require.fail(conditionText, ExceptionMessageUtil.valueAndName(o0, name0, o1, name1, o2, name2, o3, name3));
        }
    }

    public static void requirement(boolean condition, String conditionText, boolean b0, String name0) {
        if (!condition) {
            Require.fail(conditionText, ExceptionMessageUtil.valueAndName(b0, name0));
        }
    }

    public static void requirement(boolean condition, String conditionText, boolean b0, String name0, boolean b1, String name1) {
        if (!condition) {
            Require.fail(conditionText, ExceptionMessageUtil.valueAndName(b0, name0, b1, name1));
        }
    }

    public static void requirement(boolean condition, String conditionText, boolean b0, String name0, double d1, String name1) {
        if (!condition) {
            Require.fail(conditionText, ExceptionMessageUtil.concat(ExceptionMessageUtil.valueAndName(b0, name0), ExceptionMessageUtil.valueAndName(d1, name1)));
        }
    }

    public static void requirement(boolean condition, String conditionText, boolean b0, String name0, boolean b1, String name1, boolean b2, String name2) {
        if (!condition) {
            Require.fail(conditionText, ExceptionMessageUtil.valueAndName(b0, name0, b1, name1, b2, name2));
        }
    }

    public static void requirement(boolean condition, String conditionText, boolean b0, String name0, boolean b1, String name1, boolean b2, String name2, boolean b3, String name3) {
        if (!condition) {
            Require.fail(conditionText, ExceptionMessageUtil.valueAndName(b0, name0, b1, name1, b2, name2, b3, name3));
        }
    }

    public static void requirement(boolean condition, String conditionText, int i0, String name0) {
        if (!condition) {
            Require.fail(conditionText, ExceptionMessageUtil.valueAndName(i0, name0));
        }
    }

    public static void requirement(boolean condition, String conditionText, int i0, String name0, int i1, String name1) {
        if (!condition) {
            Require.fail(conditionText, ExceptionMessageUtil.valueAndName(i0, name0, i1, name1));
        }
    }

    public static void requirement(boolean condition, String conditionText, long l0, String name0) {
        if (!condition) {
            Require.fail(conditionText, ExceptionMessageUtil.valueAndName(l0, name0));
        }
    }

    public static RequirementFailure statementNeverExecuted() {
        Require.fail("statement is never executed");
        return null;
    }

    public static RequirementFailure statementNeverExecuted(String statementDescription) {
        Require.fail(statementDescription + " is never executed");
        return null;
    }

    public static RequirementFailure exceptionNeverCaught(Exception e) {
        try {
            Require.fail(e.getClass().getName() + " is never caught", e.getClass().getName() + "(" + e.getMessage() + ") caught");
        }
        catch (RequirementFailure requirementFailure) {
            requirementFailure.initCause(e);
            throw requirementFailure;
        }
        return null;
    }

    public static RequirementFailure exceptionNeverCaught(String tryStatementDescription, Exception e) {
        try {
            Require.fail(tryStatementDescription + " succeeds", e.getClass().getName() + "(" + e.getMessage() + ") caught");
        }
        catch (RequirementFailure requirementFailure) {
            requirementFailure.initCause(e);
            throw requirementFailure;
        }
        return null;
    }

    public static RequirementFailure valueNeverOccurs(Object o, String name) {
        Require.fail(ExceptionMessageUtil.valueAndName(o, name) + " never occurs");
        return null;
    }

    public static RequirementFailure valueNeverOccurs(boolean b, String name) {
        Require.fail(ExceptionMessageUtil.valueAndName(b, name) + " never occurs");
        return null;
    }

    public static RequirementFailure valueNeverOccurs(char c, String name) {
        Require.fail(ExceptionMessageUtil.valueAndName(c, name) + " never occurs");
        return null;
    }

    public static RequirementFailure valueNeverOccurs(byte b, String name) {
        Require.fail(ExceptionMessageUtil.valueAndName(b, name) + " never occurs");
        return null;
    }

    public static RequirementFailure valueNeverOccurs(short s, String name) {
        Require.fail(ExceptionMessageUtil.valueAndName(s, name) + " never occurs");
        return null;
    }

    public static RequirementFailure valueNeverOccurs(int i, String name) {
        Require.fail(ExceptionMessageUtil.valueAndName(i, name) + " never occurs");
        return null;
    }

    public static RequirementFailure valueNeverOccurs(long l, String name) {
        Require.fail(ExceptionMessageUtil.valueAndName(l, name) + " never occurs");
        return null;
    }

    public static RequirementFailure valueNeverOccurs(float f, String name) {
        Require.fail(ExceptionMessageUtil.valueAndName(f, name) + " never occurs");
        return null;
    }

    public static RequirementFailure valueNeverOccurs(double d, String name) {
        Require.fail(ExceptionMessageUtil.valueAndName(d, name) + " never occurs");
        return null;
    }

    public static void eq(boolean b0, String name0, boolean b1, String name1) {
        if (b0 != b1) {
            Require.fail(name0 + " == " + name1, ExceptionMessageUtil.valueAndName(b0, name0, b1, name1));
        }
    }

    public static void eq(boolean b0, String name0, boolean b1) {
        if (b0 != b1) {
            Require.fail(name0 + " == " + b1, ExceptionMessageUtil.valueAndName(b0, name0));
        }
    }

    public static void eq(char c0, String name0, char c1, String name1) {
        if (c0 != c1) {
            Require.fail(name0 + " == " + name1, ExceptionMessageUtil.valueAndName(c0, name0, c1, name1));
        }
    }

    public static void eq(char c0, String name0, char c1) {
        if (c0 != c1) {
            Require.fail(name0 + " == " + ExceptionMessageUtil.valueString(c1), ExceptionMessageUtil.valueAndName(c0, name0));
        }
    }

    public static void eq(byte b0, String name0, byte b1, String name1) {
        if (b0 != b1) {
            Require.fail(name0 + " == " + name1, ExceptionMessageUtil.valueAndName(b0, name0, b1, name1));
        }
    }

    public static void eq(byte b0, String name0, byte b1) {
        if (b0 != b1) {
            Require.fail(name0 + " == " + b1, ExceptionMessageUtil.valueAndName(b0, name0));
        }
    }

    public static void eq(short s0, String name0, short s1, String name1) {
        if (s0 != s1) {
            Require.fail(name0 + " == " + name1, ExceptionMessageUtil.valueAndName(s0, name0, s1, name1));
        }
    }

    public static void eq(short s0, String name0, short s1) {
        if (s0 != s1) {
            Require.fail(name0 + " == " + s1, ExceptionMessageUtil.valueAndName(s0, name0));
        }
    }

    public static void eq(int i0, String name0, int i1, String name1) {
        if (i0 != i1) {
            Require.fail(name0 + " == " + name1, ExceptionMessageUtil.valueAndName(i0, name0, i1, name1));
        }
    }

    public static void eq(int i0, String name0, int i1) {
        if (i0 != i1) {
            Require.fail(name0 + " == " + i1, ExceptionMessageUtil.valueAndName(i0, name0));
        }
    }

    public static void eq(long l0, String name0, long l1, String name1) {
        if (l0 != l1) {
            Require.fail(name0 + " == " + name1, ExceptionMessageUtil.valueAndName(l0, name0, l1, name1));
        }
    }

    public static void eq(long l0, String name0, long l1) {
        if (l0 != l1) {
            Require.fail(name0 + " == " + l1, ExceptionMessageUtil.valueAndName(l0, name0));
        }
    }

    public static void eq(float f0, String name0, float f1, String name1) {
        if (f0 != f1) {
            Require.fail(name0 + " == " + name1, ExceptionMessageUtil.valueAndName(f0, name0, f1, name1));
        }
    }

    public static void eq(float f0, String name0, float f1) {
        if (f0 != f1) {
            Require.fail(name0 + " == " + f1, ExceptionMessageUtil.valueAndName(f0, name0));
        }
    }

    public static void eq(double d0, String name0, double d1, String name1) {
        if (d0 != d1) {
            Require.fail(name0 + " == " + name1, ExceptionMessageUtil.valueAndName(d0, name0, d1, name1));
        }
    }

    public static void eq(double d0, String name0, double d1) {
        if (d0 != d1) {
            Require.fail(name0 + " == " + d1, ExceptionMessageUtil.valueAndName(d0, name0));
        }
    }

    public static void neq(boolean b0, String name0, boolean b1, String name1) {
        if (b0 == b1) {
            Require.fail(name0 + " != " + name1, ExceptionMessageUtil.valueAndName(b0, name0, b1, name1));
        }
    }

    public static void neq(boolean b0, String name0, boolean b1) {
        if (b0 == b1) {
            Require.fail(name0 + " != " + b1, ExceptionMessageUtil.valueAndName(b0, name0));
        }
    }

    public static void neq(char c0, String name0, char c1, String name1) {
        if (c0 == c1) {
            Require.fail(name0 + " != " + name1, ExceptionMessageUtil.valueAndName(c0, name0, c1, name1));
        }
    }

    public static void neq(char c0, String name0, char c1) {
        if (c0 == c1) {
            Require.fail(name0 + " != " + ExceptionMessageUtil.valueString(c1), ExceptionMessageUtil.valueAndName(c0, name0));
        }
    }

    public static void neq(byte b0, String name0, byte b1, String name1) {
        if (b0 == b1) {
            Require.fail(name0 + " != " + name1, ExceptionMessageUtil.valueAndName(b0, name0, b1, name1));
        }
    }

    public static void neq(byte b0, String name0, byte b1) {
        if (b0 == b1) {
            Require.fail(name0 + " != " + b1, ExceptionMessageUtil.valueAndName(b0, name0));
        }
    }

    public static void neq(short s0, String name0, short s1, String name1) {
        if (s0 == s1) {
            Require.fail(name0 + " != " + name1, ExceptionMessageUtil.valueAndName(s0, name0, s1, name1));
        }
    }

    public static void neq(short s0, String name0, short s1) {
        if (s0 == s1) {
            Require.fail(name0 + " != " + s1, ExceptionMessageUtil.valueAndName(s0, name0));
        }
    }

    public static int neq(int i0, String name0, int i1, String name1) {
        if (i0 == i1) {
            Require.fail(name0 + " != " + name1, ExceptionMessageUtil.valueAndName(i0, name0, i1, name1));
        }
        return i0;
    }

    public static void neq(int i0, String name0, int i1) {
        if (i0 == i1) {
            Require.fail(name0 + " != " + i1, ExceptionMessageUtil.valueAndName(i0, name0));
        }
    }

    public static void neq(long l0, String name0, long l1, String name1) {
        if (l0 == l1) {
            Require.fail(name0 + " != " + name1, ExceptionMessageUtil.valueAndName(l0, name0, l1, name1));
        }
    }

    public static void neq(long l0, String name0, long l1) {
        if (l0 == l1) {
            Require.fail(name0 + " != " + l1, ExceptionMessageUtil.valueAndName(l0, name0));
        }
    }

    public static void neq(float f0, String name0, float f1, String name1) {
        if (f0 == f1) {
            Require.fail(name0 + " != " + name1, ExceptionMessageUtil.valueAndName(f0, name0, f1, name1));
        }
    }

    public static void neq(float f0, String name0, float f1) {
        if (f0 == f1) {
            Require.fail(name0 + " != " + f1, ExceptionMessageUtil.valueAndName(f0, name0));
        }
    }

    public static void neq(double d0, String name0, double d1, String name1) {
        if (d0 == d1) {
            Require.fail(name0 + " != " + name1, ExceptionMessageUtil.valueAndName(d0, name0, d1, name1));
        }
    }

    public static void neq(double d0, String name0, double d1) {
        if (d0 == d1) {
            Require.fail(name0 + " != " + d1, ExceptionMessageUtil.valueAndName(d0, name0));
        }
    }

    public static char lt(char c0, String name0, char c1, String name1) {
        if (c0 >= c1) {
            Require.fail(name0 + " < " + name1, ExceptionMessageUtil.valueAndName(c0, name0, c1, name1));
        }
        return c0;
    }

    public static char lt(char c0, String name0, char c1) {
        if (c0 >= c1) {
            Require.fail(name0 + " < " + ExceptionMessageUtil.valueString(c1), ExceptionMessageUtil.valueAndName(c0, name0));
        }
        return c0;
    }

    public static byte lt(byte b0, String name0, byte b1, String name1) {
        if (b0 >= b1) {
            Require.fail(name0 + " < " + name1, ExceptionMessageUtil.valueAndName(b0, name0, b1, name1));
        }
        return b0;
    }

    public static byte lt(byte b0, String name0, byte b1) {
        if (b0 >= b1) {
            Require.fail(name0 + " < " + b1, ExceptionMessageUtil.valueAndName(b0, name0));
        }
        return b0;
    }

    public static short lt(short s0, String name0, short s1, String name1) {
        if (s0 >= s1) {
            Require.fail(name0 + " < " + name1, ExceptionMessageUtil.valueAndName(s0, name0, s1, name1));
        }
        return s0;
    }

    public static short lt(short s0, String name0, short s1) {
        if (s0 >= s1) {
            Require.fail(name0 + " < " + s1, ExceptionMessageUtil.valueAndName(s0, name0));
        }
        return s0;
    }

    public static int lt(int i0, String name0, int i1, String name1) {
        if (i0 >= i1) {
            Require.fail(name0 + " < " + name1, ExceptionMessageUtil.valueAndName(i0, name0, i1, name1));
        }
        return i0;
    }

    public static int lt(int i0, String name0, int i1) {
        if (i0 >= i1) {
            Require.fail(name0 + " < " + i1, ExceptionMessageUtil.valueAndName(i0, name0));
        }
        return i0;
    }

    public static long lt(long l0, String name0, long l1, String name1) {
        if (l0 >= l1) {
            Require.fail(name0 + " < " + name1, ExceptionMessageUtil.valueAndName(l0, name0, l1, name1));
        }
        return l0;
    }

    public static long lt(long l0, String name0, long l1) {
        if (l0 >= l1) {
            Require.fail(name0 + " < " + l1, ExceptionMessageUtil.valueAndName(l0, name0));
        }
        return l0;
    }

    public static float lt(float f0, String name0, float f1, String name1) {
        if (!(f0 < f1)) {
            Require.fail(name0 + " < " + name1, ExceptionMessageUtil.valueAndName(f0, name0, f1, name1));
        }
        return f0;
    }

    public static float lt(float f0, String name0, float f1) {
        if (!(f0 < f1)) {
            Require.fail(name0 + " < " + f1, ExceptionMessageUtil.valueAndName(f0, name0));
        }
        return f0;
    }

    public static double lt(double d0, String name0, double d1, String name1) {
        if (!(d0 < d1)) {
            Require.fail(name0 + " < " + name1, ExceptionMessageUtil.valueAndName(d0, name0, d1, name1));
        }
        return d0;
    }

    public static double lt(double d0, String name0, double d1) {
        if (!(d0 < d1)) {
            Require.fail(name0 + " < " + d1, ExceptionMessageUtil.valueAndName(d0, name0));
        }
        return d0;
    }

    public static char leq(char c0, String name0, char c1, String name1) {
        if (c0 > c1) {
            Require.fail(name0 + " <= " + name1, ExceptionMessageUtil.valueAndName(c0, name0, c1, name1));
        }
        return c0;
    }

    public static char leq(char c0, String name0, char c1) {
        if (c0 > c1) {
            Require.fail(name0 + " <= " + ExceptionMessageUtil.valueString(c1), ExceptionMessageUtil.valueAndName(c0, name0));
        }
        return c0;
    }

    public static byte leq(byte b0, String name0, byte b1, String name1) {
        if (b0 > b1) {
            Require.fail(name0 + " <= " + name1, ExceptionMessageUtil.valueAndName(b0, name0, b1, name1));
        }
        return b0;
    }

    public static byte leq(byte b0, String name0, byte b1) {
        if (b0 > b1) {
            Require.fail(name0 + " <= " + b1, ExceptionMessageUtil.valueAndName(b0, name0));
        }
        return b0;
    }

    public static short leq(short s0, String name0, short s1, String name1) {
        if (s0 > s1) {
            Require.fail(name0 + " <= " + name1, ExceptionMessageUtil.valueAndName(s0, name0, s1, name1));
        }
        return s0;
    }

    public static short leq(short s0, String name0, short s1) {
        if (s0 > s1) {
            Require.fail(name0 + " <= " + s1, ExceptionMessageUtil.valueAndName(s0, name0));
        }
        return s0;
    }

    public static int leq(int i0, String name0, int i1, String name1) {
        if (i0 > i1) {
            Require.fail(name0 + " <= " + name1, ExceptionMessageUtil.valueAndName(i0, name0, i1, name1));
        }
        return i0;
    }

    public static int leq(int i0, String name0, int i1) {
        if (i0 > i1) {
            Require.fail(name0 + " <= " + i1, ExceptionMessageUtil.valueAndName(i0, name0));
        }
        return i0;
    }

    public static long leq(long l0, String name0, long l1, String name1) {
        if (l0 > l1) {
            Require.fail(name0 + " <= " + name1, ExceptionMessageUtil.valueAndName(l0, name0, l1, name1));
        }
        return l0;
    }

    public static long leq(long l0, String name0, long l1) {
        if (l0 > l1) {
            Require.fail(name0 + " <= " + l1, ExceptionMessageUtil.valueAndName(l0, name0));
        }
        return l0;
    }

    public static float leq(float f0, String name0, float f1, String name1) {
        if (!(f0 <= f1)) {
            Require.fail(name0 + " <= " + name1, ExceptionMessageUtil.valueAndName(f0, name0, f1, name1));
        }
        return f0;
    }

    public static float leq(float f0, String name0, float f1) {
        if (!(f0 <= f1)) {
            Require.fail(name0 + " <= " + f1, ExceptionMessageUtil.valueAndName(f0, name0));
        }
        return f0;
    }

    public static double leq(double d0, String name0, double d1, String name1) {
        if (!(d0 <= d1)) {
            Require.fail(name0 + " <= " + name1, ExceptionMessageUtil.valueAndName(d0, name0, d1, name1));
        }
        return d0;
    }

    public static double leq(double d0, String name0, double d1) {
        if (!(d0 <= d1)) {
            Require.fail(name0 + " <= " + d1, ExceptionMessageUtil.valueAndName(d0, name0));
        }
        return d0;
    }

    public static char gt(char c0, String name0, char c1, String name1) {
        if (c0 <= c1) {
            Require.fail(name0 + " > " + name1, ExceptionMessageUtil.valueAndName(c0, name0, c1, name1));
        }
        return c0;
    }

    public static char gt(char c0, String name0, char c1) {
        if (c0 <= c1) {
            Require.fail(name0 + " > " + ExceptionMessageUtil.valueString(c1), ExceptionMessageUtil.valueAndName(c0, name0));
        }
        return c0;
    }

    public static byte gt(byte b0, String name0, byte b1, String name1) {
        if (b0 <= b1) {
            Require.fail(name0 + " > " + name1, ExceptionMessageUtil.valueAndName(b0, name0, b1, name1));
        }
        return b0;
    }

    public static byte gt(byte b0, String name0, byte b1) {
        if (b0 <= b1) {
            Require.fail(name0 + " > " + b1, ExceptionMessageUtil.valueAndName(b0, name0));
        }
        return b0;
    }

    public static short gt(short s0, String name0, short s1, String name1) {
        if (s0 <= s1) {
            Require.fail(name0 + " > " + name1, ExceptionMessageUtil.valueAndName(s0, name0, s1, name1));
        }
        return s0;
    }

    public static short gt(short s0, String name0, short s1) {
        if (s0 <= s1) {
            Require.fail(name0 + " > " + s1, ExceptionMessageUtil.valueAndName(s0, name0));
        }
        return s0;
    }

    public static int gt(int i0, String name0, int i1, String name1) {
        if (i0 <= i1) {
            Require.fail(name0 + " > " + name1, ExceptionMessageUtil.valueAndName(i0, name0, i1, name1));
        }
        return i0;
    }

    public static int gt(int i0, String name0, int i1) {
        if (i0 <= i1) {
            Require.fail(name0 + " > " + i1, ExceptionMessageUtil.valueAndName(i0, name0));
        }
        return i0;
    }

    public static long gt(long l0, String name0, long l1, String name1) {
        if (l0 <= l1) {
            Require.fail(name0 + " > " + name1, ExceptionMessageUtil.valueAndName(l0, name0, l1, name1));
        }
        return l0;
    }

    public static long gt(long l0, String name0, long l1) {
        if (l0 <= l1) {
            Require.fail(name0 + " > " + l1, ExceptionMessageUtil.valueAndName(l0, name0));
        }
        return l0;
    }

    public static float gt(float f0, String name0, float f1, String name1) {
        if (!(f0 > f1)) {
            Require.fail(name0 + " > " + name1, ExceptionMessageUtil.valueAndName(f0, name0, f1, name1));
        }
        return f0;
    }

    public static float gt(float f0, String name0, float f1) {
        if (!(f0 > f1)) {
            Require.fail(name0 + " > " + f1, ExceptionMessageUtil.valueAndName(f0, name0));
        }
        return f0;
    }

    public static double gt(double d0, String name0, double d1, String name1) {
        if (!(d0 > d1)) {
            Require.fail(name0 + " > " + name1, ExceptionMessageUtil.valueAndName(d0, name0, d1, name1));
        }
        return d0;
    }

    public static double gt(double d0, String name0, double d1) {
        if (!(d0 > d1)) {
            Require.fail(name0 + " > " + d1, ExceptionMessageUtil.valueAndName(d0, name0));
        }
        return d0;
    }

    public static char geq(char c0, String name0, char c1, String name1) {
        if (c0 < c1) {
            Require.fail(name0 + " >= " + name1, ExceptionMessageUtil.valueAndName(c0, name0, c1, name1));
        }
        return c0;
    }

    public static char geq(char c0, String name0, char c1) {
        if (c0 < c1) {
            Require.fail(name0 + " >= " + ExceptionMessageUtil.valueString(c1), ExceptionMessageUtil.valueAndName(c0, name0));
        }
        return c0;
    }

    public static byte geq(byte b0, String name0, byte b1, String name1) {
        if (b0 < b1) {
            Require.fail(name0 + " >= " + name1, ExceptionMessageUtil.valueAndName(b0, name0, b1, name1));
        }
        return b0;
    }

    public static byte geq(byte b0, String name0, byte b1) {
        if (b0 < b1) {
            Require.fail(name0 + " >= " + b1, ExceptionMessageUtil.valueAndName(b0, name0));
        }
        return b0;
    }

    public static short geq(short s0, String name0, short s1, String name1) {
        if (s0 < s1) {
            Require.fail(name0 + " >= " + name1, ExceptionMessageUtil.valueAndName(s0, name0, s1, name1));
        }
        return s0;
    }

    public static short geq(short s0, String name0, short s1) {
        if (s0 < s1) {
            Require.fail(name0 + " >= " + s1, ExceptionMessageUtil.valueAndName(s0, name0));
        }
        return s0;
    }

    public static int geq(int i0, String name0, int i1, String name1) {
        if (i0 < i1) {
            Require.fail(name0 + " >= " + name1, ExceptionMessageUtil.valueAndName(i0, name0, i1, name1));
        }
        return i0;
    }

    public static int geq(int i0, String name0, int i1) {
        if (i0 < i1) {
            Require.fail(name0 + " >= " + i1, ExceptionMessageUtil.valueAndName(i0, name0));
        }
        return i0;
    }

    public static long geq(long l0, String name0, long l1, String name1) {
        if (l0 < l1) {
            Require.fail(name0 + " >= " + name1, ExceptionMessageUtil.valueAndName(l0, name0, l1, name1));
        }
        return l0;
    }

    public static long geq(long l0, String name0, long l1) {
        if (l0 < l1) {
            Require.fail(name0 + " >= " + l1, ExceptionMessageUtil.valueAndName(l0, name0));
        }
        return l0;
    }

    public static float geq(float f0, String name0, float f1, String name1) {
        if (!(f0 >= f1)) {
            Require.fail(name0 + " >= " + name1, ExceptionMessageUtil.valueAndName(f0, name0, f1, name1));
        }
        return f0;
    }

    public static float geq(float f0, String name0, float f1) {
        if (!(f0 >= f1)) {
            Require.fail(name0 + " >= " + f1, ExceptionMessageUtil.valueAndName(f0, name0));
        }
        return f0;
    }

    public static double geq(double d0, String name0, double d1, String name1) {
        if (!(d0 >= d1)) {
            Require.fail(name0 + " >= " + name1, ExceptionMessageUtil.valueAndName(d0, name0, d1, name1));
        }
        return d0;
    }

    public static double geq(double d0, String name0, double d1) {
        if (!(d0 >= d1)) {
            Require.fail(name0 + " >= " + d1, ExceptionMessageUtil.valueAndName(d0, name0));
        }
        return d0;
    }

    public static void eqFalse(boolean b, String name) {
        if (b) {
            Require.fail(name + " == false", ExceptionMessageUtil.valueAndName(b, name));
        }
    }

    public static void neqFalse(boolean b, String name) {
        if (!b) {
            Require.fail(name + " != false", ExceptionMessageUtil.valueAndName(b, name));
        }
    }

    public static void eqTrue(boolean b, String name) {
        if (!b) {
            Require.fail(name + " == true", ExceptionMessageUtil.valueAndName(b, name));
        }
    }

    public static void neqTrue(boolean b, String name) {
        if (b) {
            Require.fail(name + " != true", ExceptionMessageUtil.valueAndName(b, name));
        }
    }

    public static void eqZero(char c, String name) {
        if ('\u0000' != c) {
            Require.fail(name + " == 0", ExceptionMessageUtil.valueAndName(c, name));
        }
    }

    public static void eqZero(byte b, String name) {
        if (0 != b) {
            Require.fail(name + " == 0", ExceptionMessageUtil.valueAndName(b, name));
        }
    }

    public static void eqZero(short s, String name) {
        if (0 != s) {
            Require.fail(name + " == 0", ExceptionMessageUtil.valueAndName(s, name));
        }
    }

    public static void eqZero(int i, String name) {
        if (0 != i) {
            Require.fail(name + " == 0", ExceptionMessageUtil.valueAndName(i, name));
        }
    }

    public static void eqZero(long l, String name) {
        if (0L != l) {
            Require.fail(name + " == 0", ExceptionMessageUtil.valueAndName(l, name));
        }
    }

    public static void eqZero(float f, String name) {
        if (0.0f != f) {
            Require.fail(name + " == 0", ExceptionMessageUtil.valueAndName(f, name));
        }
    }

    public static void eqZero(double d, String name) {
        if (0.0 != d) {
            Require.fail(name + " == 0", ExceptionMessageUtil.valueAndName(d, name));
        }
    }

    public static char neqZero(char c, String name) {
        if ('\u0000' == c) {
            Require.fail(name + " != 0", ExceptionMessageUtil.valueAndName(c, name));
        }
        return c;
    }

    public static byte neqZero(byte b, String name) {
        if (0 == b) {
            Require.fail(name + " != 0", ExceptionMessageUtil.valueAndName(b, name));
        }
        return b;
    }

    public static short neqZero(short s, String name) {
        if (0 == s) {
            Require.fail(name + " != 0", ExceptionMessageUtil.valueAndName(s, name));
        }
        return s;
    }

    public static int neqZero(int i, String name) {
        if (0 == i) {
            Require.fail(name + " != 0", ExceptionMessageUtil.valueAndName(i, name));
        }
        return i;
    }

    public static long neqZero(long l, String name) {
        if (0L == l) {
            Require.fail(name + " != 0", ExceptionMessageUtil.valueAndName(l, name));
        }
        return l;
    }

    public static float neqZero(float f, String name) {
        if (0.0f == f) {
            Require.fail(name + " != 0", ExceptionMessageUtil.valueAndName(f, name));
        }
        return f;
    }

    public static double neqZero(double d, String name) {
        if (0.0 == d) {
            Require.fail(name + " != 0", ExceptionMessageUtil.valueAndName(d, name));
        }
        return d;
    }

    public static byte ltZero(byte b, String name) {
        if (b >= 0) {
            Require.fail(name + " < 0", ExceptionMessageUtil.valueAndName(b, name));
        }
        return b;
    }

    public static short ltZero(short s, String name) {
        if (s >= 0) {
            Require.fail(name + " < 0", ExceptionMessageUtil.valueAndName(s, name));
        }
        return s;
    }

    public static int ltZero(int i, String name) {
        if (i >= 0) {
            Require.fail(name + " < 0", ExceptionMessageUtil.valueAndName(i, name));
        }
        return i;
    }

    public static long ltZero(long l, String name) {
        if (l >= 0L) {
            Require.fail(name + " < 0", ExceptionMessageUtil.valueAndName(l, name));
        }
        return l;
    }

    public static float ltZero(float f, String name) {
        if (!(f < 0.0f)) {
            Require.fail(name + " < 0", ExceptionMessageUtil.valueAndName(f, name));
        }
        return f;
    }

    public static double ltZero(double d, String name) {
        if (!(d < 0.0)) {
            Require.fail(name + " < 0", ExceptionMessageUtil.valueAndName(d, name));
        }
        return d;
    }

    public static byte leqZero(byte b, String name) {
        if (b > 0) {
            Require.fail(name + " <= 0", ExceptionMessageUtil.valueAndName(b, name));
        }
        return b;
    }

    public static short leqZero(short s, String name) {
        if (s > 0) {
            Require.fail(name + " <= 0", ExceptionMessageUtil.valueAndName(s, name));
        }
        return s;
    }

    public static int leqZero(int i, String name) {
        if (i > 0) {
            Require.fail(name + " <= 0", ExceptionMessageUtil.valueAndName(i, name));
        }
        return i;
    }

    public static long leqZero(long l, String name) {
        if (l > 0L) {
            Require.fail(name + " <= 0", ExceptionMessageUtil.valueAndName(l, name));
        }
        return l;
    }

    public static float leqZero(float f, String name) {
        if (!(f <= 0.0f)) {
            Require.fail(name + " <= 0", ExceptionMessageUtil.valueAndName(f, name));
        }
        return f;
    }

    public static double leqZero(double d, String name) {
        if (!(d <= 0.0)) {
            Require.fail(name + " <= 0", ExceptionMessageUtil.valueAndName(d, name));
        }
        return d;
    }

    public static byte gtZero(byte b, String name) {
        if (b <= 0) {
            Require.fail(name + " > 0", ExceptionMessageUtil.valueAndName(b, name));
        }
        return b;
    }

    public static short gtZero(short s, String name) {
        if (s <= 0) {
            Require.fail(name + " > 0", ExceptionMessageUtil.valueAndName(s, name));
        }
        return s;
    }

    public static int gtZero(int i, String name) {
        if (i <= 0) {
            Require.fail(name + " > 0", ExceptionMessageUtil.valueAndName(i, name));
        }
        return i;
    }

    public static long gtZero(long l, String name) {
        if (l <= 0L) {
            Require.fail(name + " > 0", ExceptionMessageUtil.valueAndName(l, name));
        }
        return l;
    }

    public static float gtZero(float f, String name) {
        if (!(f > 0.0f)) {
            Require.fail(name + " > 0", ExceptionMessageUtil.valueAndName(f, name));
        }
        return f;
    }

    public static double gtZero(double d, String name) {
        if (!(d > 0.0)) {
            Require.fail(name + " > 0", ExceptionMessageUtil.valueAndName(d, name));
        }
        return d;
    }

    public static byte geqZero(byte b, String name) {
        if (b < 0) {
            Require.fail(name + " >= 0", ExceptionMessageUtil.valueAndName(b, name));
        }
        return b;
    }

    public static short geqZero(short s, String name) {
        if (s < 0) {
            Require.fail(name + " >= 0", ExceptionMessageUtil.valueAndName(s, name));
        }
        return s;
    }

    public static int geqZero(int i, String name) {
        if (i < 0) {
            Require.fail(name + " >= 0", ExceptionMessageUtil.valueAndName(i, name));
        }
        return i;
    }

    public static long geqZero(long l, String name) {
        if (l < 0L) {
            Require.fail(name + " >= 0", ExceptionMessageUtil.valueAndName(l, name));
        }
        return l;
    }

    public static float geqZero(float f, String name) {
        if (!(f >= 0.0f)) {
            Require.fail(name + " >= 0", ExceptionMessageUtil.valueAndName(f, name));
        }
        return f;
    }

    public static double geqZero(double d, String name) {
        if (!(d >= 0.0)) {
            Require.fail(name + " >= 0", ExceptionMessageUtil.valueAndName(d, name));
        }
        return d;
    }

    public static void eq(Object o0, String name0, Object o1, String name1) {
        if (o0 != o1) {
            Require.fail(name0 + " == " + name1, ExceptionMessageUtil.valueAndName(o0, name0, o1, name1));
        }
    }

    public static void eq(Object o0, String name0, Object o1) {
        if (o0 != o1) {
            Require.fail(name0 + " == " + ExceptionMessageUtil.valueString(o1), ExceptionMessageUtil.valueAndName(o0, name0));
        }
    }

    public static void neq(Object o0, String name0, Object o1, String name1) {
        if (o0 == o1) {
            Require.fail(name0 + " != " + name1, ExceptionMessageUtil.valueAndName(o0, name0, o1, name1));
        }
    }

    public static void neq(Object o0, String name0, Object o1) {
        if (o0 == o1) {
            Require.fail(name0 + " != " + ExceptionMessageUtil.valueString(o1), ExceptionMessageUtil.valueAndName(o0, name0));
        }
    }

    public static void eqNull(Object o, String name) {
        if (null != o) {
            Require.fail(name + " == null", ExceptionMessageUtil.valueAndName(o, name));
        }
    }

    @NotNull
    public static <T> T neqNull(T o, String name) {
        if (null == o) {
            Require.fail(name + " != null", ExceptionMessageUtil.valueAndName(o, name));
        }
        return o;
    }

    public static double neqNaN(double o, String name) {
        if (Double.isNaN(o)) {
            Require.fail(name + " != NaN", ExceptionMessageUtil.valueAndName(o, name));
        }
        return o;
    }

    public static double neqInf(double o, String name) {
        if (Double.isInfinite(o)) {
            Require.fail(name + " != +/-Inf", ExceptionMessageUtil.valueAndName(o, name));
        }
        return o;
    }

    public static void equals(Object o0, String name0, Object o1, String name1) {
        Require.neqNull(o0, name0);
        Require.neqNull(o1, name1);
        if (!o0.equals(o1)) {
            Require.fail(name0 + ".equals(" + name1 + ")", ExceptionMessageUtil.valueAndName(o0, name0, o1, name1));
        }
    }

    public static void equals(Object o0, String name0, Object o1) {
        Require.neqNull(o0, name0);
        Require.neqNull(o1, "o1");
        if (!o0.equals(o1)) {
            Require.fail(name0 + ".equals(" + ExceptionMessageUtil.valueString(o1) + ")", ExceptionMessageUtil.valueAndName(o0, name0));
        }
    }

    public static void notEquals(Object o0, String name0, Object o1, String name1) {
        Require.neqNull(o0, name0);
        Require.neqNull(o1, name1);
        if (o0.equals(o1)) {
            Require.fail("!" + name0 + ".equals(" + name1 + ")", ExceptionMessageUtil.valueAndName(o0, name0, o1, name1));
        }
    }

    public static void notEquals(Object o0, String name0, Object o1) {
        Require.neqNull(o0, name0);
        Require.neqNull(o1, "o1");
        if (o0.equals(o1)) {
            Require.fail("!" + name0 + ".equals(" + ExceptionMessageUtil.valueString(o1) + ")", ExceptionMessageUtil.valueAndName(o0, name0));
        }
    }

    public static String nonempty(String s, String name) {
        Require.neqNull(s, name);
        if (s.length() <= 0) {
            Require.fail(name + ".length() > 0", ExceptionMessageUtil.valueAndName(s, name));
        }
        return s;
    }

    public static <C extends Collection<T>, T> C contains(C collection, String collectionName, T element, String elementName) {
        Require.neqNull(collection, collectionName);
        if (!collection.contains(element)) {
            Require.fail(collectionName + ".contains(" + elementName + ")", ExceptionMessageUtil.valueAndName(element, elementName));
        }
        return collection;
    }

    public static <C extends Collection<T>, T> C notContains(C collection, String collectionName, T element, String elementName) {
        Require.neqNull(collection, collectionName);
        if (collection.contains(element)) {
            Require.fail("!" + collectionName + ".contains(" + elementName + ")", ExceptionMessageUtil.valueAndName(element, elementName));
        }
        return collection;
    }

    public static <C extends Collection<T>, T> C notContainsNull(C collection, String collectionName) {
        Require.neqNull(collection, collectionName);
        if (collection.stream().anyMatch(Objects::isNull)) {
            Require.fail(collectionName + " does not contain null");
        }
        return collection;
    }

    public static <M extends Map<K, V>, K, V> M containsKey(M map, String mapName, K key, String keyName) {
        Require.neqNull(map, mapName);
        if (!map.containsKey(key)) {
            Require.fail(mapName + ".containsKey(" + keyName + ")", ExceptionMessageUtil.valueAndName(key, keyName));
        }
        return map;
    }

    public static <M extends Map<K, V>, K, V> M notContainsKey(M map, String mapName, K key, String keyName) {
        Require.neqNull(map, mapName);
        if (map.containsKey(key)) {
            Require.fail("!" + mapName + ".containsKey(" + keyName + ")", ExceptionMessageUtil.valueAndName(key, keyName));
        }
        return map;
    }

    public static int inRange(int offset, String offsetName, int length, String lengthName) {
        if (offset < 0) {
            Require.fail(offsetName + " >= 0", ExceptionMessageUtil.valueAndName(offset, offsetName));
        } else if (offset >= length) {
            Require.fail(offsetName + " < " + lengthName, ExceptionMessageUtil.valueAndName(offset, offsetName, length, lengthName));
        }
        return offset;
    }

    public static int inRange(int offset, String offsetName, int start, String startName, int end, String endName) {
        if (offset < start) {
            Require.fail(offsetName + " >= " + startName, ExceptionMessageUtil.valueAndName(offset, offsetName, start, startName));
        } else if (offset >= end) {
            Require.fail(offsetName + " < " + endName, ExceptionMessageUtil.valueAndName(offset, offsetName, end, endName));
        }
        return offset;
    }

    public static long inRange(long offset, String offsetName, long length, String lengthName) {
        if (offset < 0L) {
            Require.fail(offsetName + " >= 0L", ExceptionMessageUtil.valueAndName(offset, offsetName));
        } else if (offset >= length) {
            Require.fail(offsetName + " < " + lengthName, ExceptionMessageUtil.valueAndName(offset, offsetName, length, lengthName));
        }
        return offset;
    }

    public static long inRange(long offset, String offsetName, long start, String startName, long end, String endName) {
        if (offset < start) {
            Require.fail(offsetName + " >= " + startName, ExceptionMessageUtil.valueAndName(offset, offsetName, start, startName));
        } else if (offset >= end) {
            Require.fail(offsetName + " < " + endName, ExceptionMessageUtil.valueAndName(offset, offsetName, end, endName));
        }
        return offset;
    }

    public static double normalized(double d, String name) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            Require.fail(name + " is normalized (not infinity or NaN)", ExceptionMessageUtil.valueAndName(d, name));
        }
        return d;
    }

    public static <T> T[] nonEmpty(T[] a, String name) {
        Require.neqNull(a, name);
        if (a.length <= 0) {
            Require.fail(name + ".length > 0", ExceptionMessageUtil.valueAndName(a, name));
        }
        return a;
    }

    public static int[] lengthEqual(int[] a, String name, int length) {
        if (a.length != length) {
            Require.fail(name + ".length == " + length, ExceptionMessageUtil.valueAndName(a, name));
        }
        return a;
    }

    public static <T> T[] elementsNeqNull(T[] elements, String name) {
        Require.neqNull(elements, name);
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i] != null) continue;
            Require.neqNull(elements[i], name + "[" + i + "]");
        }
        return elements;
    }

    public static void elementsNeqNaN(double[] elements, String name) {
        Require.neqNull(elements, name);
        for (int i = 0; i < elements.length; ++i) {
            if (!Double.isNaN(elements[i])) continue;
            Require.neqNaN(elements[i], name + "[" + i + "]");
        }
    }

    public static void elementsNeqNaN(double[][] elements, String name) {
        Require.neqNull(elements, name);
        for (int i = 0; i < elements.length; ++i) {
            for (int j = 0; j < elements[i].length; ++j) {
                if (!Double.isNaN(elements[i][j])) continue;
                Require.neqNaN(elements[i][j], name + "[" + i + "," + j + "]");
            }
        }
    }

    public static void elementsNeqInf(double[] elements, String name) {
        Require.neqNull(elements, name);
        for (int i = 0; i < elements.length; ++i) {
            if (!Double.isInfinite(elements[i])) continue;
            Require.neqInf(elements[i], name + "[" + i + "]");
        }
    }

    public static void elementsNeqInf(double[][] elements, String name) {
        Require.neqNull(elements, name);
        for (int i = 0; i < elements.length; ++i) {
            for (int j = 0; j < elements[i].length; ++j) {
                if (!Double.isInfinite(elements[i][j])) continue;
                Require.neqInf(elements[i][j], name + "[" + i + "," + j + "]");
            }
        }
    }

    public static void isSquare(double[][] m, String name) {
        for (int i = 0; i < m.length; ++i) {
            if (m[i].length == m.length) continue;
            Require.fail("Matrix is not square: " + name, "matrix is not square: " + name);
        }
    }

    public static double inRange(double trialValue, double endPointA, double endPointB, String name) {
        double minRange = endPointA;
        double maxRange = endPointB;
        if (endPointA > endPointB) {
            minRange = endPointB;
            maxRange = endPointA;
        }
        if (trialValue < minRange || maxRange < trialValue) {
            Require.fail(name + " = " + trialValue + " is expected to be in the range of [" + minRange + "," + maxRange + "] but was not");
        }
        return trialValue;
    }

    public static float inRange(float trialValue, float endPointA, float endPointB, String name) {
        float minRange = endPointA;
        float maxRange = endPointB;
        if (endPointA > endPointB) {
            minRange = endPointB;
            maxRange = endPointA;
        }
        if (trialValue < minRange || maxRange < trialValue) {
            Require.fail(name + " = " + trialValue + " is expected to be in the range of [" + minRange + "," + maxRange + "] but was not");
        }
        return trialValue;
    }
}

