/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.configuration;

import java.nio.file.Path;
import java.util.Optional;

public class DataDir {
    public static final String PROPERTY = "deephaven.dataDir";
    @Deprecated
    private static final String WORKSPACE_PROPERTY = "workspace";
    public static final String ENV_VAR = "DEEPHAVEN_DATA_DIR";
    private static final String DEFAULT_DATA_DIR = ".";

    public static Path get() {
        return Path.of(DataDir.viaProperty().or(DataDir::viaWorkspace).or(DataDir::viaEnvironmentVariable).orElse(DEFAULT_DATA_DIR), new String[0]);
    }

    public static Path getOrSet(String defaultValue) {
        String existing = DataDir.viaProperty().or(DataDir::viaWorkspace).or(DataDir::viaEnvironmentVariable).orElse(null);
        if (existing != null) {
            return Path.of(existing, new String[0]);
        }
        System.setProperty(PROPERTY, defaultValue);
        return Path.of(defaultValue, new String[0]);
    }

    private static Optional<String> viaProperty() {
        return Optional.ofNullable(System.getProperty(PROPERTY));
    }

    private static Optional<String> viaWorkspace() {
        return Optional.ofNullable(System.getProperty(WORKSPACE_PROPERTY));
    }

    private static Optional<String> viaEnvironmentVariable() {
        return Optional.ofNullable(System.getenv(ENV_VAR));
    }
}

