/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.configuration;

import io.deephaven.configuration.ConfigDir;
import io.deephaven.configuration.ConfigurationException;
import io.deephaven.configuration.ParsedProperties;
import io.deephaven.configuration.PropertyFile;
import io.deephaven.internal.log.Bootstrap;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class Configuration
extends PropertyFile {
    public static final String QUIET_PROPERTY = "configuration.quiet";
    private static NullableConfiguration INSTANCE = null;
    private static final Logger log = LoggerFactory.getLogger(Configuration.class);
    private Collection<String> contextKeys = Collections.emptySet();

    public static Configuration getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new NullableConfiguration();
        }
        return INSTANCE;
    }

    public static Configuration newConfigurationForTesting() {
        return new Configuration();
    }

    protected Configuration() {
        String configurationFile;
        try {
            configurationFile = this.reloadProperties();
        }
        catch (IOException x) {
            throw new ConfigurationException("Could not process configuration from file", x);
        }
        if (!Configuration.isQuiet()) {
            log.info().append((CharSequence)"Configuration: configuration file is ").append((CharSequence)configurationFile).endl();
        }
    }

    private void load(String fileName, boolean ignoreScope) throws IOException, ConfigurationException {
        ParsedProperties temp = new ParsedProperties(ignoreScope);
        this.properties = temp;
        temp.load(fileName);
        this.contextKeys = temp.getContextKeyValues();
    }

    @NotNull
    public Collection<String> getContextKeyValues() {
        return this.contextKeys;
    }

    public String lookupPath(String propertyName) {
        String result = System.getProperty(propertyName);
        if (result == null) {
            result = this.getStringWithDefault(propertyName, null);
        }
        if (result == null) {
            throw new ConfigurationException(propertyName + " property is not defined");
        }
        return Configuration.expandLinuxPath(result);
    }

    public static String expandLinuxPath(String path) {
        if (((String)path).startsWith("/")) {
            path = ((String)path).substring(1);
            path = Configuration.getRootPath() + (String)path;
        }
        if (((String)path).startsWith("~/")) {
            path = ((String)path).substring(1);
            path = System.getProperty("user.home") + (String)path;
        } else {
            int index = ((String)path).indexOf("~");
            if (index != -1) {
                path = ((String)path).replaceAll("~", System.getProperty("user.name"));
            }
        }
        if (!((String)path).endsWith(File.separator)) {
            path = (String)path + File.separator;
        }
        return path;
    }

    private static String getRootPath() {
        File dir = new File(".");
        dir = dir.getAbsoluteFile();
        File parent = dir.getParentFile();
        while (parent != null) {
            dir = parent;
            parent = dir.getParentFile();
        }
        return dir.getAbsolutePath();
    }

    public TimeZone getServerTimezone() {
        return TimeZone.getTimeZone(ZoneId.systemDefault());
    }

    public String reloadProperties() throws IOException, ConfigurationException {
        return this.reloadProperties(false);
    }

    String reloadProperties(boolean ignoreScope) throws IOException, ConfigurationException {
        String propertyFile = ConfigDir.configurationFile();
        this.load(propertyFile, ignoreScope);
        this.properties.putAll((Map<?, ?>)System.getProperties());
        return propertyFile;
    }

    private Properties load(String path, String propFileName) throws IOException {
        ParsedProperties temp = new ParsedProperties();
        ((Properties)temp).load(new FileInputStream(path + "/" + propFileName));
        return temp;
    }

    public static void main(String[] args) {
        try {
            if (args.length < 3) {
                System.err.println("Usage: Configuration oldEtcPath newEtcPath outCSV");
                System.exit(1);
            }
            String oldEtcPath = args[0];
            String newEtcPath = args[1];
            PrintWriter out = new PrintWriter(new File(args[2]));
            HashSet<String> diffSet = new HashSet<String>();
            out.print(Configuration.propFileDiffReport(diffSet, oldEtcPath, "ise-prod.prop", newEtcPath, "ise-prod.prop", "", "", false));
            out.print('\n');
            out.print(Configuration.propFileDiffReport(diffSet, oldEtcPath, "ise-stage.prop", newEtcPath, "ise-stage.prop", "", "", false));
            out.print('\n');
            out.print(Configuration.propFileDiffReport(diffSet, oldEtcPath, "ise-simulation.prop", newEtcPath, "ise-simulation.prop", "", "", false));
            out.print('\n');
            out.print(Configuration.propFileDiffReport(diffSet, newEtcPath, "ise-prod.prop", newEtcPath, "ise-stage.prop", newEtcPath, "ise-simulation.prop", true));
            out.print('\n');
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String propFileDiffReport(Set<String> includedProperties, String dir1, String file1, String dir2, String file2, String dir3, String file3, boolean useDiffKeys) throws IOException {
        StringBuilder out = new StringBuilder();
        Configuration configuration = new Configuration();
        Properties leftProperties = configuration.load(dir1, file1);
        Properties rightProperties = configuration.load(dir2, file2);
        Properties right2Properties = dir3.length() > 0 ? configuration.load(dir3, file3) : new Properties();
        TreeSet<String> keynames = new TreeSet<String>();
        Enumeration<?> enumeration = leftProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            keynames.add((String)enumeration.nextElement());
        }
        enumeration = rightProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            keynames.add((String)enumeration.nextElement());
        }
        enumeration = right2Properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            keynames.add((String)enumeration.nextElement());
        }
        out.append("key,").append(dir1).append(File.separator).append(file1).append(",").append(dir2).append(File.separator).append(file2).append(",").append(dir3).append(File.separator).append(file3).append("\n");
        for (String sKey : keynames) {
            String sRightValue2;
            String sLeftValue = leftProperties.containsKey(sKey) ? leftProperties.getProperty(sKey) : "";
            String sRightValue = rightProperties.containsKey(sKey) ? rightProperties.getProperty(sKey) : "";
            String string = sRightValue2 = right2Properties.containsKey(sKey) ? right2Properties.getProperty(sKey) : "";
            boolean bSame = dir3.length() > 0 ? sLeftValue.equals(sRightValue) && sLeftValue.equals(sRightValue2) && sRightValue.equals(sRightValue2) : sLeftValue.equals(sRightValue);
            if (bSame) continue;
            if (useDiffKeys) {
                if (!includedProperties.contains(sKey)) continue;
                Configuration.writeLine(out, sKey, sLeftValue, sRightValue, sRightValue2);
                continue;
            }
            includedProperties.add(sKey);
            Configuration.writeLine(out, sKey, sLeftValue, sRightValue, sRightValue2);
        }
        return out.toString();
    }

    private static void writeLine(StringBuilder out, String sKey, String sLeftValue, String sRightValue, String sRightValue2) {
        out.append(sKey).append(", \"").append(sLeftValue).append("\", \"").append(sRightValue).append("\", \"").append(sRightValue2).append("\"\n");
    }

    static boolean isQuiet() {
        return Bootstrap.isQuiet() || System.getProperty(QUIET_PROPERTY) != null;
    }

    public static class NullableConfiguration
    extends Configuration {
        NullableConfiguration() {
        }

        public String getPropertyNullable(String propertyName) {
            return this.properties.getProperty(propertyName);
        }
    }
}

