/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl.rsp.container;

import io.deephaven.engine.rowset.impl.rsp.container.ArrayContainerRangeIterator;
import io.deephaven.engine.rowset.impl.rsp.container.ArrayShortBatchIterator;
import io.deephaven.engine.rowset.impl.rsp.container.BitmapContainer;
import io.deephaven.engine.rowset.impl.rsp.container.Container;
import io.deephaven.engine.rowset.impl.rsp.container.ContainerShortBatchIterator;
import io.deephaven.engine.rowset.impl.rsp.container.ContainerUtil;
import io.deephaven.engine.rowset.impl.rsp.container.ImmutableContainer;
import io.deephaven.engine.rowset.impl.rsp.container.MutableInteger;
import io.deephaven.engine.rowset.impl.rsp.container.PositionHint;
import io.deephaven.engine.rowset.impl.rsp.container.RangeConsumer;
import io.deephaven.engine.rowset.impl.rsp.container.RangeIterator;
import io.deephaven.engine.rowset.impl.rsp.container.RunContainer;
import io.deephaven.engine.rowset.impl.rsp.container.SearchRangeIterator;
import io.deephaven.engine.rowset.impl.rsp.container.ShortAdvanceIterator;
import io.deephaven.engine.rowset.impl.rsp.container.ShortConsumer;
import io.deephaven.engine.rowset.impl.rsp.container.ShortIterator;
import io.deephaven.engine.rowset.impl.rsp.container.ShortRangeConsumer;
import java.util.NoSuchElementException;
import java.util.function.Supplier;

public class ArrayContainer
extends Container {
    private static final int DEFAULT_INIT_SIZE = 6;
    static final int DEFAULT_MAX_SIZE = 4090;
    public static final int SWITCH_CONTAINER_CARDINALITY_THRESHOLD = 3835;
    protected int cardinality = 0;
    protected short[] content;
    protected boolean shared = false;

    static int sizeInBytes(int cardinality) {
        return cardinality * 2;
    }

    public short[] getContent() {
        return this.content;
    }

    protected ArrayContainer(short[] content, int cardinality, boolean shared) {
        this.content = content;
        this.cardinality = cardinality;
        this.shared = shared;
    }

    public ArrayContainer() {
        this(6);
    }

    public ArrayContainer(int capacity) {
        this.content = new short[ArrayContainer.shortArraySizeRounding(capacity)];
    }

    ArrayContainer(int firstOfRun, int lastOfRun) {
        int valuesInRange = lastOfRun - firstOfRun;
        this.content = new short[ArrayContainer.shortArraySizeRounding(valuesInRange)];
        for (int i = 0; i < valuesInRange; ++i) {
            this.content[i] = (short)(firstOfRun + i);
        }
        this.cardinality = valuesInRange;
    }

    private ArrayContainer(ArrayContainer src, int startRank, int endRank) {
        this.cardinality = endRank - startRank;
        this.content = new short[ArrayContainer.shortArraySizeRounding(this.cardinality)];
        System.arraycopy(src.content, startRank, this.content, 0, this.cardinality);
    }

    private ArrayContainer(int newCapacity, short[] arr, int offset, int sz) {
        this.cardinality = sz;
        short[] cs = new short[ArrayContainer.shortArraySizeRounding(newCapacity)];
        System.arraycopy(arr, offset, cs, 0, sz);
        this.content = cs;
    }

    public ArrayContainer(short[] arr, int sz) {
        this.cardinality = sz;
        this.content = arr;
    }

    ArrayContainer(short v0, short v1, short v2) {
        this.content = new short[6];
        this.content[0] = v0;
        this.content[1] = v1;
        this.content[2] = v2;
        this.cardinality = 3;
    }

    ArrayContainer(short v0, short v1) {
        this.content = new short[6];
        this.content[0] = v0;
        this.content[1] = v1;
        this.cardinality = 2;
    }

    ArrayContainer(short v) {
        this.content = new short[6];
        this.content[0] = v;
        this.cardinality = 1;
    }

    public static ArrayContainer makeByCopying(short[] arr, int offset, int sz) {
        return ArrayContainer.makeByCopying(sz, arr, offset, sz);
    }

    public static ArrayContainer makeByCopying(int newCapacity, short[] arr, int offset, int sz) {
        return new ArrayContainer(newCapacity, arr, offset, sz);
    }

    public static ArrayContainer makeByWrapping(short[] arr, int sz) {
        return new ArrayContainer(arr, sz);
    }

    public ArrayContainer(short[] newContent) {
        this.cardinality = newContent.length;
        this.content = newContent;
    }

    @Override
    public Container add(int begin, int end) {
        int indexend;
        if (end == begin) {
            return this.cowRef();
        }
        if (begin > end || end > 65536) {
            throw new IllegalArgumentException("Invalid range [" + begin + "," + end + ")");
        }
        int indexstart = ContainerUtil.unsignedBinarySearch(this.content, 0, this.cardinality, (short)begin);
        if (indexstart < 0) {
            indexstart = -indexstart - 1;
        }
        indexend = (indexend = ContainerUtil.unsignedBinarySearch(this.content, 0, this.cardinality, (short)(end - 1))) < 0 ? -indexend - 1 : ++indexend;
        int rangelength = end - begin;
        int newcardinality = indexstart + (this.cardinality - indexend) + rangelength;
        if (newcardinality > 4090) {
            Container a = this.toBiggerCardinalityContainer(newcardinality);
            return a.iadd(begin, end);
        }
        ArrayContainer answer = ArrayContainer.makeByCopying(newcardinality, this.content, 0, indexstart);
        System.arraycopy(this.content, indexend, answer.content, indexstart + rangelength, this.cardinality - indexend);
        for (int k = 0; k < rangelength; ++k) {
            answer.content[k + indexstart] = (short)(begin + k);
        }
        answer.cardinality = newcardinality;
        return answer;
    }

    private Container toBiggerCardinalityContainer(int newcardinality) {
        int range;
        int holesUpperBound;
        int runsUpperBound;
        if (this.cardinality > 0 && (runsUpperBound = (holesUpperBound = (range = this.last() - this.first() + 1) - this.cardinality) + 1 + newcardinality - this.cardinality) < 255) {
            return new RunContainer(this, runsUpperBound);
        }
        return this.toBitmapContainer();
    }

    @Override
    public Container iset(short x) {
        return this.isetImpl(x, null, () -> this, this::deepcopyIfShared);
    }

    @Override
    Container iset(short x, PositionHint positionHint) {
        return this.isetImpl(x, positionHint, () -> this, this::deepcopyIfShared);
    }

    @Override
    Container set(short x, PositionHint positionHint) {
        return this.isetImpl(x, positionHint, this::cowRef, this::deepCopy);
    }

    @Override
    public Container set(short x) {
        return this.isetImpl(x, null, this::cowRef, this::deepCopy);
    }

    private Container isetImpl(short x, PositionHint positionHint, Supplier<ArrayContainer> self, Supplier<ArrayContainer> copy) {
        int begin = MutableInteger.getIfNotNullAndNonNegative(positionHint, 0);
        int loc = ContainerUtil.unsignedBinarySearch(this.content, begin, this.cardinality, x);
        if (loc >= 0) {
            MutableInteger.setIfNotNull(positionHint, loc + 1);
            return self.get();
        }
        if (this.cardinality >= 4090) {
            Container a = this.toBiggerCardinalityContainer(this.cardinality + 1);
            if (positionHint != null) {
                positionHint.reset();
                return a.iset(x, positionHint);
            }
            return a.iset(x);
        }
        ArrayContainer ans = copy.get();
        return ans.isetImplSecondHalf(x, loc, positionHint);
    }

    private Container isetImplSecondHalf(short x, int loc, PositionHint positionHintOut) {
        if (this.cardinality >= this.content.length) {
            this.increaseCapacity();
        }
        System.arraycopy(this.content, -loc - 1, this.content, -loc, this.cardinality + loc + 1);
        this.content[-loc - 1] = x;
        MutableInteger.setIfNotNull(positionHintOut, -loc);
        ++this.cardinality;
        return this;
    }

    private int advance(ShortIterator it) {
        if (it.hasNext()) {
            return ContainerUtil.toIntUnsigned(it.next());
        }
        return -1;
    }

    Container maybeSwitchContainer() {
        if (!ImmutableContainer.ENABLED) {
            return this;
        }
        if (this.cardinality == 0) {
            return Container.empty();
        }
        if (this.cardinality == 1) {
            return Container.singleton(this.content[0]);
        }
        if (this.cardinality == 2) {
            return Container.twoValues(this.content[0], this.content[1]);
        }
        return this;
    }

    @Override
    public Container and(ArrayContainer value2) {
        if (value2.isEmpty() || this.isEmpty()) {
            return Container.empty();
        }
        ArrayContainer value1 = this;
        int desiredCapacity = Math.min(value1.getCardinality(), value2.getCardinality());
        ArrayContainer answer = new ArrayContainer(desiredCapacity);
        answer.cardinality = ContainerUtil.unsignedIntersect2by2(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), answer.content);
        return answer.maybeSwitchContainer();
    }

    @Override
    public Container and(BitmapContainer x) {
        return x.and(this);
    }

    @Override
    public Container and(RunContainer x) {
        return x.and(this);
    }

    @Override
    public Container andNot(ArrayContainer value2) {
        if (value2.isEmpty()) {
            return this.cowRef();
        }
        ArrayContainer value1 = this;
        int desiredCapacity = value1.getCardinality();
        ArrayContainer answer = new ArrayContainer(desiredCapacity);
        answer.cardinality = ContainerUtil.unsignedDifference(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), answer.content);
        return answer.maybeSwitchContainer();
    }

    @Override
    public Container andNot(BitmapContainer value2) {
        if (value2.isEmpty()) {
            return this.cowRef();
        }
        ArrayContainer answer = new ArrayContainer(this.content.length);
        int pos = 0;
        for (int k = 0; k < this.cardinality; ++k) {
            short val;
            answer.content[pos] = val = this.content[k];
            pos = (int)((long)pos + (1L - value2.bitValue(val)));
        }
        answer.cardinality = pos;
        return answer.maybeSwitchContainer();
    }

    @Override
    public Container andNot(RunContainer x) {
        if (x.isEmpty()) {
            return this.cowRef();
        }
        if (x.isAllOnes()) {
            return Container.empty();
        }
        int write = 0;
        int read = 0;
        ArrayContainer answer = new ArrayContainer(this.cardinality);
        for (int i = 0; i < x.numberOfRuns() && read < this.cardinality; ++i) {
            int runStart = ContainerUtil.toIntUnsigned(x.getValue(i));
            int runEnd = runStart + ContainerUtil.toIntUnsigned(x.getLength(i));
            if (ContainerUtil.toIntUnsigned(this.content[read]) > runEnd) continue;
            int firstInRun = ContainerUtil.iterateUntil(this.content, read, this.cardinality, runStart);
            int toWrite = firstInRun - read;
            System.arraycopy(this.content, read, answer.content, write, toWrite);
            write += toWrite;
            read = ContainerUtil.iterateUntil(this.content, firstInRun, this.cardinality, runEnd + 1);
        }
        System.arraycopy(this.content, read, answer.content, write, this.cardinality - read);
        answer.cardinality = write += this.cardinality - read;
        return answer.maybeSwitchContainer();
    }

    @Override
    public ArrayContainer deepCopy() {
        return ArrayContainer.makeByCopying(this.content, 0, this.cardinality);
    }

    @Override
    public ArrayContainer cowRef() {
        this.setCopyOnWrite();
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.cardinality == 0;
    }

    @Override
    public boolean isAllOnes() {
        return false;
    }

    @Override
    public boolean contains(short x) {
        return ContainerUtil.unsignedBinarySearch(this.content, 0, this.cardinality, x) >= 0;
    }

    @Override
    public boolean contains(int rangeStart, int rangeEnd) {
        int maximum = rangeEnd - 1;
        int start = ContainerUtil.advanceUntil(this.content, -1, this.cardinality, (short)rangeStart);
        if (start >= this.cardinality) {
            return false;
        }
        int end = ContainerUtil.advanceUntil(this.content, start - 1, this.cardinality, (short)maximum);
        return end < this.cardinality && end - start == maximum - rangeStart && this.content[start] == (short)rangeStart && this.content[end] == (short)maximum;
    }

    @Override
    protected boolean contains(RunContainer runContainer) {
        if (runContainer.getCardinality() > this.cardinality) {
            return false;
        }
        int prev = -1;
        for (int i = 0; i < runContainer.numberOfRuns(); ++i) {
            int first = runContainer.getValueAsInt(i);
            int last = first + runContainer.getLengthAsInt(i);
            int start = ContainerUtil.advanceUntil(this.content, prev, this.cardinality, (short)first);
            if (start >= this.cardinality) {
                return false;
            }
            int end = ContainerUtil.advanceUntil(this.content, start - 1, this.cardinality, (short)last);
            if (end >= this.cardinality || end - start != last - first || this.content[start] != (short)first || this.content[end] != (short)last) {
                return false;
            }
            prev = end - 1;
        }
        return true;
    }

    @Override
    protected boolean contains(ArrayContainer arrayContainer) {
        if (this.cardinality < arrayContainer.cardinality) {
            return false;
        }
        int i1 = 0;
        int i2 = 0;
        while (i1 < this.cardinality && i2 < arrayContainer.cardinality) {
            if (this.content[i1] == arrayContainer.content[i2]) {
                ++i1;
                ++i2;
                continue;
            }
            if (ContainerUtil.compareUnsigned(this.content[i1], arrayContainer.content[i2]) < 0) {
                ++i1;
                continue;
            }
            return false;
        }
        return i2 == arrayContainer.cardinality;
    }

    @Override
    protected boolean contains(BitmapContainer bitmapContainer) {
        if (bitmapContainer.getCardinality() > this.getCardinality()) {
            return false;
        }
        short[] buf = (short[])threadLocalBuf.get();
        int pos = 0;
        ContainerShortBatchIterator bit = bitmapContainer.getShortBatchIterator(0);
        while (bit.hasNext()) {
            int n = bit.next(buf, 0, buf.length);
            for (int i = 0; i < n; ++i) {
                int r = ContainerUtil.unsignedBinarySearch(this.content, pos, this.cardinality, buf[i]);
                if (r < 0) {
                    return false;
                }
                pos = r + 1;
            }
        }
        return true;
    }

    @Override
    public Container iflip(short x) {
        int loc = ContainerUtil.unsignedBinarySearch(this.content, 0, this.cardinality, x);
        if (loc < 0) {
            if (this.cardinality >= 4090) {
                BitmapContainer a = this.toBitmapContainer();
                return a.iset(x);
            }
            ArrayContainer ans = this.deepcopyIfShared();
            if (ans.cardinality >= ans.content.length) {
                ans.increaseCapacity();
            }
            System.arraycopy(ans.content, -loc - 1, ans.content, -loc, ans.cardinality + loc + 1);
            ans.content[-loc - 1] = x;
            ++ans.cardinality;
            return ans;
        }
        ArrayContainer ans = this.deepcopyIfShared();
        System.arraycopy(ans.content, loc + 1, ans.content, loc, ans.cardinality - loc - 1);
        --ans.cardinality;
        return ans.maybeSwitchContainer();
    }

    @Override
    public int getCardinality() {
        return this.cardinality;
    }

    @Override
    public ShortAdvanceIterator getReverseShortIterator() {
        return new ReverseShortIterator(this);
    }

    @Override
    public ShortForwardIterator getShortIterator() {
        return new ShortForwardIterator(this);
    }

    @Override
    public ContainerShortBatchIterator getShortBatchIterator(int skipCount) {
        if (DEBUG && skipCount != 0 && skipCount >= this.cardinality) {
            throw new IllegalArgumentException("initialSeek=" + skipCount);
        }
        return new ArrayShortBatchIterator(this, skipCount);
    }

    @Override
    public SearchRangeIterator getShortRangeIterator(int initialSeek) {
        if (DEBUG && initialSeek != 0 && initialSeek >= this.cardinality) {
            throw new IllegalArgumentException("initialSeek=" + initialSeek);
        }
        return new ArrayContainerRangeIterator(this, initialSeek);
    }

    @Override
    public Container iadd(int begin, int end) {
        ArrayContainer ans;
        int indexend;
        if (end == begin) {
            return this;
        }
        if (begin > end || end > 65536) {
            throw new IllegalArgumentException("Invalid range [" + begin + "," + end + ")");
        }
        int indexstart = ContainerUtil.unsignedBinarySearch(this.content, 0, this.cardinality, (short)begin);
        if (indexstart < 0) {
            indexstart = -indexstart - 1;
        }
        indexend = (indexend = ContainerUtil.unsignedBinarySearch(this.content, 0, this.cardinality, (short)(end - 1))) < 0 ? -indexend - 1 : ++indexend;
        int rangelength = end - begin;
        int newcardinality = indexstart + (this.cardinality - indexend) + rangelength;
        if (newcardinality > 4090) {
            Container a = this.toBiggerCardinalityContainer(newcardinality);
            return a.iadd(begin, end);
        }
        if (newcardinality > this.content.length) {
            short[] destination = new short[this.calculateCapacity(newcardinality)];
            System.arraycopy(this.content, 0, destination, 0, indexstart);
            for (int k = 0; k < rangelength; ++k) {
                destination[k + indexstart] = (short)(begin + k);
            }
            System.arraycopy(this.content, indexend, destination, indexstart + rangelength, this.cardinality - indexend);
            if (this.shared) {
                ans = new ArrayContainer(destination, newcardinality);
            } else {
                this.content = destination;
                this.cardinality = newcardinality;
                ans = this;
            }
        } else {
            if (this.shared) {
                ans = new ArrayContainer(this.calculateCapacity(newcardinality));
                System.arraycopy(this.content, 0, ans.content, 0, indexstart);
            } else {
                ans = this;
            }
            System.arraycopy(this.content, indexend, ans.content, indexstart + rangelength, this.cardinality - indexend);
            for (int k = 0; k < rangelength; ++k) {
                ans.content[k + indexstart] = (short)(begin + k);
            }
            ans.cardinality = newcardinality;
        }
        return ans;
    }

    @Override
    public Container iappend(int begin, int end) {
        ArrayContainer ans;
        int rangeLength = end - begin;
        if (rangeLength <= 0) {
            return this;
        }
        int newCardinality = this.cardinality + rangeLength;
        if (newCardinality > 4090) {
            Container a = this.toBiggerCardinalityContainer(newCardinality);
            return a.iappend(begin, end);
        }
        int firstIndexNewRange = this.cardinality;
        if (this.shared || newCardinality > this.content.length) {
            short[] destination = new short[this.calculateCapacity(newCardinality)];
            System.arraycopy(this.content, 0, destination, 0, this.cardinality);
            if (this.shared) {
                ans = new ArrayContainer(destination, newCardinality);
            } else {
                this.content = destination;
                this.cardinality = newCardinality;
                ans = this;
            }
        } else {
            this.cardinality = newCardinality;
            ans = this;
        }
        for (int k = 0; k < rangeLength; ++k) {
            ans.content[firstIndexNewRange + k] = (short)(begin + k);
        }
        return ans;
    }

    @Override
    public Container iand(ArrayContainer value2) {
        ArrayContainer ans = this.deepcopyIfShared();
        ans.cardinality = ContainerUtil.unsignedIntersect2by2(ans.content, ans.getCardinality(), value2.content, value2.getCardinality(), ans.content);
        return ans.maybeSwitchContainer();
    }

    @Override
    public Container iand(BitmapContainer value2) {
        ArrayContainer ans = this.deepcopyIfShared();
        int pos = 0;
        for (int k = 0; k < ans.cardinality; ++k) {
            short v;
            ans.content[pos] = v = ans.content[k];
            pos = (int)((long)pos + value2.bitValue(v));
        }
        ans.cardinality = pos;
        return ans.maybeSwitchContainer();
    }

    @Override
    public Container iand(RunContainer x) {
        return x.and(this);
    }

    @Override
    public Container iandNot(ArrayContainer value2) {
        ArrayContainer ans = this.deepcopyIfShared();
        ans.cardinality = ContainerUtil.unsignedDifference(ans.content, ans.getCardinality(), value2.content, value2.getCardinality(), ans.content);
        return ans.maybeSwitchContainer();
    }

    @Override
    public Container iandNot(BitmapContainer value2) {
        ArrayContainer ans = this.deepcopyIfShared();
        int pos = 0;
        for (int k = 0; k < ans.cardinality; ++k) {
            short v;
            ans.content[pos] = v = ans.content[k];
            pos = (int)((long)pos + (1L - value2.bitValue(v)));
        }
        ans.cardinality = pos;
        return ans.maybeSwitchContainer();
    }

    @Override
    public Container iandNot(RunContainer x) {
        return this.andNot(x);
    }

    private void increaseCapacity() {
        this.increaseCapacity(false);
    }

    private static int nextCapacity(int oldCapacity) {
        return oldCapacity == 0 ? 6 : (oldCapacity < 64 ? ArrayContainer.shortArraySizeRounding(oldCapacity * 2) : (oldCapacity < 1067 ? ArrayContainer.shortArraySizeRounding(oldCapacity * 3 / 2) : ArrayContainer.shortArraySizeRounding(oldCapacity * 5 / 4)));
    }

    private void increaseCapacity(boolean allowIllegalSize) {
        int newCapacity = ArrayContainer.nextCapacity(this.content.length);
        if (newCapacity > 4090 && !allowIllegalSize) {
            newCapacity = 4090;
        }
        if (newCapacity > 3834 && !allowIllegalSize) {
            newCapacity = 4090;
        }
        short[] vs = new short[newCapacity];
        System.arraycopy(this.content, 0, vs, 0, this.cardinality);
        this.content = vs;
    }

    private int calculateCapacity(int min) {
        int newCapacity = ArrayContainer.shortArraySizeRounding(min);
        if (newCapacity > 3834) {
            newCapacity = 4090;
        }
        return newCapacity;
    }

    @Override
    public Container inot(int firstOfRange, int exclusiveEndOfRange) {
        ArrayContainer ans;
        int lastIndex;
        int startIndex = ContainerUtil.unsignedBinarySearch(this.content, 0, this.cardinality, (short)firstOfRange);
        if (startIndex < 0) {
            startIndex = -startIndex - 1;
        }
        if ((lastIndex = ContainerUtil.unsignedBinarySearch(this.content, 0, this.cardinality, (short)(exclusiveEndOfRange - 1))) < 0) {
            lastIndex = -lastIndex - 1 - 1;
        }
        int currentValuesInRange = lastIndex - startIndex + 1;
        int spanToBeFlipped = exclusiveEndOfRange - firstOfRange;
        int newValuesInRange = spanToBeFlipped - currentValuesInRange;
        int cardinalityChange = newValuesInRange - currentValuesInRange;
        int newCardinality = this.cardinality + cardinalityChange;
        if (cardinalityChange > 0) {
            short[] src = this.content;
            if (newCardinality > 4090) {
                return this.toBiggerCardinalityContainer(newCardinality).inot(firstOfRange, exclusiveEndOfRange);
            }
            if (this.shared) {
                ans = new ArrayContainer(this.calculateCapacity(newCardinality));
                System.arraycopy(this.content, 0, ans.content, 0, lastIndex + 1);
            } else {
                ans = this;
                if (newCardinality > this.content.length) {
                    this.content = new short[this.calculateCapacity(newCardinality)];
                    System.arraycopy(src, 0, this.content, 0, lastIndex + 1);
                }
            }
            System.arraycopy(src, startIndex + currentValuesInRange, ans.content, startIndex + newValuesInRange, this.cardinality - 1 - lastIndex);
            ans.negateRange(newValuesInRange, startIndex, lastIndex, firstOfRange, exclusiveEndOfRange);
        } else {
            if (this.shared) {
                if (cardinalityChange == 0) {
                    ans = this.deepCopy();
                } else {
                    ans = new ArrayContainer(this.content.length);
                    System.arraycopy(this.content, 0, ans.content, 0, lastIndex + 1);
                }
            } else {
                ans = this;
            }
            ans.negateRange(newValuesInRange, startIndex, lastIndex, firstOfRange, exclusiveEndOfRange);
            if (cardinalityChange < 0) {
                System.arraycopy(this.content, startIndex + currentValuesInRange, ans.content, startIndex + newValuesInRange, this.cardinality - 1 - lastIndex);
            }
        }
        ans.cardinality = newCardinality;
        return ans.maybeSwitchContainer();
    }

    @Override
    public Container ior(ArrayContainer value2) {
        if (this.shared) {
            return this.or(value2);
        }
        if (value2.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return value2.cowRef();
        }
        int sumOfCardinalities = this.getCardinality() + value2.getCardinality();
        if (sumOfCardinalities > 4090) {
            int i;
            short v;
            int k;
            BitmapContainer bc = new BitmapContainer();
            for (k = 0; k < value2.cardinality; ++k) {
                v = value2.content[k];
                int n = i = ContainerUtil.toIntUnsigned(v) >>> 6;
                bc.bitmap[n] = bc.bitmap[n] | 1L << v;
            }
            for (k = 0; k < this.cardinality; ++k) {
                v = this.content[k];
                int n = i = ContainerUtil.toIntUnsigned(v) >>> 6;
                bc.bitmap[n] = bc.bitmap[n] | 1L << v;
            }
            bc.cardinality = 0;
            for (long k2 : bc.bitmap) {
                bc.cardinality += Long.bitCount(k2);
            }
            if (bc.cardinality <= 4090) {
                return bc.toArrayContainer();
            }
            if (bc.isAllOnes()) {
                return Container.full();
            }
            return bc;
        }
        if (sumOfCardinalities >= this.content.length) {
            int newCapacity = this.calculateCapacity(sumOfCardinalities);
            ArrayContainer ans = new ArrayContainer(newCapacity);
            ans.cardinality = ContainerUtil.unsignedUnion2by2(this.content, 0, this.cardinality, value2.content, 0, value2.cardinality, ans.content);
            return ans;
        }
        System.arraycopy(this.content, 0, this.content, value2.cardinality, this.cardinality);
        this.cardinality = ContainerUtil.unsignedUnion2by2(this.content, value2.cardinality, this.cardinality, value2.content, 0, value2.cardinality, this.content);
        return this;
    }

    @Override
    public Container ior(BitmapContainer x) {
        if (x.isEmpty()) {
            return this;
        }
        return x.or(this);
    }

    @Override
    public Container ior(RunContainer x) {
        if (x.isEmpty()) {
            return this;
        }
        return x.or(this);
    }

    @Override
    public Container remove(int begin, int end) {
        return this.removeImpl(begin, end, false);
    }

    @Override
    public Container iremove(int begin, int end) {
        return this.removeImpl(begin, end, true);
    }

    private Container removeImpl(int begin, int end, boolean inPlace) {
        ArrayContainer ans;
        int indexend;
        if (end <= begin) {
            return inPlace ? this : this.cowRef();
        }
        if (begin > end || end > 65536) {
            throw new IllegalArgumentException("Invalid range [" + begin + "," + end + ")");
        }
        int indexstart = ContainerUtil.unsignedBinarySearch(this.content, 0, this.cardinality, (short)begin);
        if (indexstart < 0) {
            indexstart = -indexstart - 1;
        }
        indexend = (indexend = ContainerUtil.unsignedBinarySearch(this.content, 0, this.cardinality, (short)(end - 1))) < 0 ? -indexend - 1 : ++indexend;
        int rangelength = indexend - indexstart;
        if (rangelength == 0) {
            return inPlace ? this : this.cowRef();
        }
        int newCardinality = this.cardinality - rangelength;
        if (newCardinality == 0) {
            return Container.empty();
        }
        if (newCardinality == 1) {
            return ArrayContainer.makeSingletonContainer(this.content[indexstart > 0 ? 0 : indexend]);
        }
        if (newCardinality == 2) {
            int i1;
            int i0;
            if (indexstart == 0) {
                i0 = indexend;
                i1 = indexend + 1;
            } else if (indexstart == 1) {
                i0 = 0;
                i1 = indexend;
            } else {
                i0 = 0;
                i1 = 1;
            }
            return Container.twoValues(this.content[i0], this.content[i1]);
        }
        if (inPlace && !this.shared) {
            ans = this;
        } else {
            ans = new ArrayContainer(this.calculateCapacity(newCardinality));
            System.arraycopy(this.content, 0, ans.content, 0, indexstart);
        }
        System.arraycopy(this.content, indexstart + rangelength, ans.content, indexstart, this.cardinality - indexstart - rangelength);
        ans.cardinality = newCardinality;
        return ans;
    }

    @Override
    public Container ixor(ArrayContainer value2) {
        return this.xor(value2);
    }

    @Override
    public Container ixor(BitmapContainer x) {
        return x.xor(this);
    }

    @Override
    public Container ixor(RunContainer x) {
        return x.xor(this);
    }

    protected void loadData(BitmapContainer bitmapContainer) {
        this.cardinality = bitmapContainer.cardinality;
        bitmapContainer.fillArray(this.content);
    }

    protected void loadDataWithSkipValue(BitmapContainer bitmapContainer, short valueToSkip, PositionHint positionHintOut) {
        this.cardinality = bitmapContainer.fillArrayWithSkipValue(this.content, valueToSkip, positionHintOut);
    }

    private void negateRange(int valuesInRange, int startIndex, int lastIndex, int startRange, int lastRange) {
        int valInRange;
        short[] buf = (short[])threadLocalBuf.get();
        short[] buffer = buf.length >= valuesInRange ? buf : new short[valuesInRange];
        int outPos = 0;
        int inPos = startIndex;
        for (valInRange = startRange; valInRange < lastRange && inPos <= lastIndex; ++valInRange) {
            if ((short)valInRange != this.content[inPos]) {
                buffer[outPos++] = (short)valInRange;
                continue;
            }
            ++inPos;
        }
        while (valInRange < lastRange) {
            buffer[outPos++] = (short)valInRange;
            ++valInRange;
        }
        int i = startIndex;
        for (int j = 0; j < outPos; ++j) {
            this.content[i++] = buffer[j];
        }
    }

    @Override
    public Container not(int firstOfRange, int lastOfRange) {
        int valInRange;
        int currentValuesInRange;
        int spanToBeFlipped;
        int newValuesInRange;
        int cardinalityChange;
        int newCardinality;
        int lastIndex;
        if (firstOfRange >= lastOfRange) {
            return this.cowRef();
        }
        int startIndex = ContainerUtil.unsignedBinarySearch(this.content, 0, this.cardinality, (short)firstOfRange);
        if (startIndex < 0) {
            startIndex = -startIndex - 1;
        }
        if ((lastIndex = ContainerUtil.unsignedBinarySearch(this.content, 0, this.cardinality, (short)(lastOfRange - 1))) < 0) {
            lastIndex = -lastIndex - 2;
        }
        if ((newCardinality = this.cardinality + (cardinalityChange = (newValuesInRange = (spanToBeFlipped = lastOfRange - firstOfRange) - (currentValuesInRange = lastIndex - startIndex + 1)) - currentValuesInRange)) > 4090) {
            return this.toBiggerCardinalityContainer(newCardinality).not(firstOfRange, lastOfRange);
        }
        ArrayContainer answer = new ArrayContainer(newCardinality);
        System.arraycopy(this.content, 0, answer.content, 0, startIndex);
        int outPos = startIndex;
        int inPos = startIndex;
        for (valInRange = firstOfRange; valInRange < lastOfRange && inPos <= lastIndex; ++valInRange) {
            if ((short)valInRange != this.content[inPos]) {
                answer.content[outPos++] = (short)valInRange;
                continue;
            }
            ++inPos;
        }
        while (valInRange < lastOfRange) {
            answer.content[outPos++] = (short)valInRange;
            ++valInRange;
        }
        for (int i = lastIndex + 1; i < this.cardinality; ++i) {
            answer.content[outPos++] = this.content[i];
        }
        answer.cardinality = newCardinality;
        return answer.maybeSwitchContainer();
    }

    @Override
    int numberOfRuns() {
        if (this.cardinality == 0) {
            return 0;
        }
        int numRuns = 1;
        int oldv = ContainerUtil.toIntUnsigned(this.content[0]);
        for (int i = 1; i < this.cardinality; ++i) {
            int newv = ContainerUtil.toIntUnsigned(this.content[i]);
            if (oldv + 1 != newv) {
                ++numRuns;
            }
            oldv = newv;
        }
        return numRuns;
    }

    @Override
    public Container or(ArrayContainer value2) {
        if (value2.isEmpty()) {
            return this.cowRef();
        }
        if (this.isEmpty()) {
            return value2.cowRef();
        }
        ArrayContainer value1 = this;
        int totalCardinality = value1.getCardinality() + value2.getCardinality();
        if (totalCardinality > 4090) {
            int i;
            short v;
            int k;
            BitmapContainer bc = new BitmapContainer();
            for (k = 0; k < value2.cardinality; ++k) {
                v = value2.content[k];
                int n = i = ContainerUtil.toIntUnsigned(v) >>> 6;
                bc.bitmap[n] = bc.bitmap[n] | 1L << v;
            }
            for (k = 0; k < this.cardinality; ++k) {
                v = this.content[k];
                int n = i = ContainerUtil.toIntUnsigned(v) >>> 6;
                bc.bitmap[n] = bc.bitmap[n] | 1L << v;
            }
            bc.cardinality = 0;
            for (long k2 : bc.bitmap) {
                bc.cardinality += Long.bitCount(k2);
            }
            if (bc.cardinality <= 4090) {
                return bc.toArrayContainer();
            }
            if (bc.isAllOnes()) {
                return Container.full();
            }
            return bc;
        }
        ArrayContainer answer = new ArrayContainer(totalCardinality);
        answer.cardinality = ContainerUtil.unsignedUnion2by2(value1.content, 0, value1.getCardinality(), value2.content, 0, value2.getCardinality(), answer.content);
        return answer;
    }

    @Override
    public Container or(BitmapContainer x) {
        return x.or(this);
    }

    @Override
    public Container or(RunContainer x) {
        return x.or(this);
    }

    protected Container or(ShortIterator it) {
        return this.or(it, false);
    }

    private void forceAppend(short val) {
        if (this.cardinality == this.content.length) {
            this.increaseCapacity(true);
        }
        this.content[this.cardinality++] = val;
    }

    private Container or(ShortIterator it, boolean exclusive) {
        ArrayContainer ac = new ArrayContainer();
        int myItPos = 0;
        int myHead = myItPos == this.cardinality ? -1 : ContainerUtil.toIntUnsigned(this.content[myItPos++]);
        int hisHead = this.advance(it);
        while (myHead != -1 && hisHead != -1) {
            if (myHead < hisHead) {
                ac.forceAppend((short)myHead);
                myHead = myItPos == this.cardinality ? -1 : ContainerUtil.toIntUnsigned(this.content[myItPos++]);
                continue;
            }
            if (myHead > hisHead) {
                ac.forceAppend((short)hisHead);
                hisHead = this.advance(it);
                continue;
            }
            if (!exclusive) {
                ac.forceAppend((short)hisHead);
            }
            hisHead = this.advance(it);
            myHead = myItPos == this.cardinality ? -1 : ContainerUtil.toIntUnsigned(this.content[myItPos++]);
        }
        while (myHead != -1) {
            ac.forceAppend((short)myHead);
            myHead = myItPos == this.cardinality ? -1 : ContainerUtil.toIntUnsigned(this.content[myItPos++]);
        }
        while (hisHead != -1) {
            ac.forceAppend((short)hisHead);
            hisHead = this.advance(it);
        }
        if (ac.cardinality > 4090) {
            return ac.toBiggerCardinalityContainer(ac.cardinality);
        }
        return ac;
    }

    @Override
    public int rank(short lowbits) {
        int answer = ContainerUtil.unsignedBinarySearch(this.content, 0, this.cardinality, lowbits);
        if (answer >= 0) {
            return answer + 1;
        }
        return -answer - 1;
    }

    private void removeAtIndex(int loc) {
        System.arraycopy(this.content, loc + 1, this.content, loc, this.cardinality - loc - 1);
        --this.cardinality;
    }

    @Override
    public Container iunset(short x) {
        return this.unsetImpl(x, true, null);
    }

    @Override
    public Container unset(short x) {
        return this.unsetImpl(x, false, null);
    }

    @Override
    Container iunset(short x, PositionHint positionHint) {
        return this.unsetImpl(x, true, positionHint);
    }

    @Override
    Container unset(short x, PositionHint positionHint) {
        return this.unsetImpl(x, false, positionHint);
    }

    private Container unsetImpl(short x, boolean inPlace, PositionHint positionHint) {
        int searchStartPos = MutableInteger.getIfNotNullAndNonNegative(positionHint, 0);
        int loc = ContainerUtil.unsignedBinarySearch(this.content, searchStartPos, this.cardinality, x);
        if (loc < 0) {
            MutableInteger.setIfNotNull(positionHint, ~loc);
            return inPlace ? this : this.cowRef();
        }
        int newCardinality = this.cardinality - 1;
        if (newCardinality == 0) {
            PositionHint.resetIfNotNull(positionHint);
            return Container.empty();
        }
        if (newCardinality == 1) {
            PositionHint.resetIfNotNull(positionHint);
            return Container.singleton(this.content[loc == 0 ? 1 : 0]);
        }
        if (newCardinality == 2) {
            int i1;
            int i0;
            if (loc == 0) {
                i0 = 1;
                i1 = 2;
            } else if (loc == 1) {
                i0 = 0;
                i1 = 2;
            } else {
                i0 = 0;
                i1 = 1;
            }
            PositionHint.resetIfNotNull(positionHint);
            return Container.twoValues(this.content[i0], this.content[i1]);
        }
        ArrayContainer ans = inPlace ? this.deepcopyIfShared() : this.deepCopy();
        ans.removeAtIndex(loc);
        MutableInteger.setIfNotNull(positionHint, loc);
        return ans;
    }

    @Override
    public Container runOptimize() {
        Container c = this.maybeSwitchContainer();
        if (c != this) {
            return c;
        }
        int numRuns = this.numberOfRuns();
        if (numRuns == 1) {
            return Container.singleRange(this.first(), this.last() + 1);
        }
        int sizeAsRunContainer = RunContainer.sizeInBytes(numRuns);
        if (this.bytesUsed() > sizeAsRunContainer) {
            return new RunContainer(this, numRuns);
        }
        this.compact();
        return this;
    }

    private void compact() {
        if (this.shared || this.content.length == this.cardinality || this.cardinality == 0 && this.content.length == 6) {
            return;
        }
        short[] newContent = new short[this.cardinality == 0 ? 6 : ArrayContainer.shortArraySizeRounding(this.cardinality)];
        System.arraycopy(this.content, 0, newContent, 0, this.cardinality);
        this.content = newContent;
    }

    @Override
    public short select(int j) {
        return this.content[j];
    }

    @Override
    public Container select(int startRank, int endRank) {
        return new ArrayContainer(this, startRank, endRank);
    }

    @Override
    public int find(short x) {
        return ContainerUtil.unsignedBinarySearch(this.content, 0, this.cardinality, x);
    }

    @Override
    public void selectRanges(RangeConsumer outValues, RangeIterator inPositions) {
        if (!inPositions.hasNext()) {
            return;
        }
        int ostart = -1;
        int oend = -1;
        do {
            inPositions.next();
            int istart = inPositions.start();
            int iend = inPositions.end();
            if (iend > this.cardinality) {
                throw new IllegalArgumentException("selectRanges for invalid position=" + iend);
            }
            for (int pos = istart; pos < iend; ++pos) {
                int key = ContainerUtil.toIntUnsigned(this.select(pos));
                if (ostart == -1) {
                    ostart = oend = key;
                    continue;
                }
                if (key == oend + 1) {
                    oend = key;
                    continue;
                }
                outValues.accept(ostart, oend + 1);
                ostart = oend = key;
            }
        } while (inPositions.hasNext());
        outValues.accept(ostart, oend + 1);
    }

    @Override
    public Container iandRange(int start, int end) {
        return this.andRangeImpl(!this.shared, start, end);
    }

    @Override
    public Container andRange(int start, int end) {
        return this.andRangeImpl(false, start, end);
    }

    private Container andRangeImpl(boolean inPlace, int start, int end) {
        if (end <= start || this.isEmpty()) {
            return Container.empty();
        }
        int firstPos = ContainerUtil.unsignedBinarySearch(this.content, 0, this.cardinality, ContainerUtil.lowbits(start));
        if (firstPos < 0 && ((firstPos ^= 0xFFFFFFFF) >= this.cardinality || ContainerUtil.toIntUnsigned(this.content[firstPos]) >= end)) {
            return Container.empty();
        }
        int lastPos = ContainerUtil.unsignedBinarySearch(this.content, firstPos, this.cardinality, ContainerUtil.lowbits(end - 1));
        if (lastPos < 0) {
            lastPos = ~lastPos - 1;
        }
        if (firstPos == 0 && lastPos == this.cardinality - 1) {
            if (inPlace) {
                return this;
            }
            return this.cowRef();
        }
        int newCard = lastPos - firstPos + 1;
        if (ImmutableContainer.ENABLED) {
            if (newCard == 1) {
                return Container.singleton(this.content[firstPos]);
            }
            if (newCard == 2) {
                return Container.twoValues(this.content[firstPos], this.content[lastPos]);
            }
        }
        if (inPlace) {
            System.arraycopy(this.content, firstPos, this.content, 0, newCard);
            int dcard = this.cardinality - newCard;
            this.cardinality = newCard;
            if (dcard > newCard) {
                this.compact();
            }
            return this;
        }
        return new ArrayContainer(this, firstPos, lastPos + 1);
    }

    @Override
    public boolean findRanges(RangeConsumer outPositions, RangeIterator inValues, int maxPos) {
        if (!inValues.hasNext()) {
            return false;
        }
        int ostart = -1;
        int oend = -1;
        int startSearch = 0;
        do {
            inValues.next();
            int istart = inValues.start();
            int iend = inValues.end();
            for (int key = istart; key < iend; ++key) {
                if (startSearch > maxPos) {
                    return true;
                }
                int pos = ContainerUtil.unsignedBinarySearch(this.content, startSearch, this.cardinality, ContainerUtil.lowbits(key));
                if (pos < 0) {
                    throw new IllegalArgumentException("findRanges for invalid key=" + key);
                }
                if (ostart == -1) {
                    if (pos > maxPos) {
                        return true;
                    }
                    ostart = oend = pos;
                } else {
                    if (pos > maxPos) {
                        outPositions.accept(ostart, oend + 1);
                        return true;
                    }
                    if (pos == oend + 1) {
                        oend = pos;
                    } else {
                        outPositions.accept(ostart, oend + 1);
                        ostart = oend = pos;
                    }
                }
                startSearch = pos + 1;
            }
        } while (inValues.hasNext());
        outPositions.accept(ostart, oend + 1);
        return false;
    }

    @Override
    public BitmapContainer toBitmapContainer() {
        BitmapContainer bc = new BitmapContainer();
        bc.loadData(this);
        return bc;
    }

    @Override
    public int nextValue(short fromValue) {
        int index = ContainerUtil.advanceUntil(this.content, -1, this.cardinality, fromValue);
        int effectiveIndex = index >= 0 ? index : -index - 1;
        return effectiveIndex >= this.cardinality ? -1 : ContainerUtil.toIntUnsigned(this.content[effectiveIndex]);
    }

    private void assertNonEmpty() {
        if (this.cardinality == 0) {
            throw new NoSuchElementException("Empty " + this.getContainerName());
        }
    }

    @Override
    public int first() {
        this.assertNonEmpty();
        return ContainerUtil.toIntUnsigned(this.content[0]);
    }

    @Override
    public int last() {
        this.assertNonEmpty();
        return ContainerUtil.toIntUnsigned(this.content[this.cardinality - 1]);
    }

    @Override
    public void trim() {
        this.compact();
    }

    @Override
    public Container xor(ArrayContainer value2) {
        ArrayContainer value1 = this;
        int totalCardinality = value1.getCardinality() + value2.getCardinality();
        if (totalCardinality > 4090) {
            int i;
            short v;
            int k;
            BitmapContainer bc = new BitmapContainer();
            for (k = 0; k < value2.cardinality; ++k) {
                v = value2.content[k];
                int n = i = ContainerUtil.toIntUnsigned(v) >>> 6;
                bc.bitmap[n] = bc.bitmap[n] ^ 1L << v;
            }
            for (k = 0; k < this.cardinality; ++k) {
                v = this.content[k];
                int n = i = ContainerUtil.toIntUnsigned(v) >>> 6;
                bc.bitmap[n] = bc.bitmap[n] ^ 1L << v;
            }
            bc.cardinality = 0;
            for (long k2 : bc.bitmap) {
                bc.cardinality += Long.bitCount(k2);
            }
            if (bc.cardinality <= 4090) {
                return bc.toArrayContainer();
            }
            return bc;
        }
        ArrayContainer answer = new ArrayContainer(totalCardinality);
        answer.cardinality = ContainerUtil.unsignedExclusiveUnion2by2(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), answer.content);
        return answer.maybeSwitchContainer();
    }

    @Override
    public Container xor(BitmapContainer x) {
        return x.xor(this);
    }

    @Override
    public Container xor(RunContainer x) {
        return x.xor(this);
    }

    protected Container xor(ShortIterator it) {
        return this.or(it, true);
    }

    @Override
    public boolean forEach(ShortConsumer sc) {
        return this.forEach(0, sc);
    }

    @Override
    public boolean forEach(int rankOffset, ShortConsumer sc) {
        for (int k = rankOffset; k < this.cardinality; ++k) {
            boolean wantMore = sc.accept(this.content[k]);
            if (wantMore) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachRange(int rankOffset, ShortRangeConsumer sc) {
        short pendingStart;
        if (rankOffset >= this.cardinality) {
            return true;
        }
        int k = rankOffset;
        short pendingEnd = pendingStart = this.content[k];
        for (k = rankOffset + 1; k < this.cardinality; ++k) {
            short v = this.content[k];
            if (pendingEnd + 1 == v) {
                pendingEnd = v;
                continue;
            }
            if (!sc.accept(pendingStart, pendingEnd)) {
                return false;
            }
            pendingStart = pendingEnd = v;
        }
        return sc.accept(pendingStart, pendingEnd);
    }

    @Override
    public boolean subsetOf(ArrayContainer c) {
        if (this.isEmpty()) {
            return true;
        }
        if (c.isEmpty()) {
            return false;
        }
        if (this.cardinality > c.cardinality || this.first() < c.first() || this.last() > c.last()) {
            return false;
        }
        int ci = 0;
        for (int i = 0; i < this.cardinality; ++i) {
            if (ci >= c.cardinality) {
                return false;
            }
            short k = this.content[i];
            int s = ContainerUtil.unsignedBinarySearch(c.content, ci, c.cardinality, k);
            if (s < 0) {
                return false;
            }
            ci = s + 1;
        }
        return true;
    }

    @Override
    public boolean subsetOf(BitmapContainer c) {
        if (this.isEmpty()) {
            return true;
        }
        if (c.isEmpty()) {
            return false;
        }
        if (this.cardinality > c.getCardinality()) {
            return false;
        }
        for (int i = 0; i < this.cardinality; ++i) {
            short k = this.content[i];
            if (c.contains(k)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean subsetOf(RunContainer c) {
        if (this.isEmpty()) {
            return true;
        }
        if (c.isEmpty()) {
            return false;
        }
        if (this.first() < c.first() || this.last() > c.last()) {
            return false;
        }
        int ci = 0;
        for (int i = 0; i < this.cardinality; ++i) {
            short k = this.content[i];
            int s = c.searchFrom(k, ci);
            if (s < 0) {
                return false;
            }
            ci = s;
        }
        return true;
    }

    private static boolean overlaps(ArrayContainer c1, ArrayContainer c2) {
        int c2i = 0;
        for (int c1i = 0; c1i < c1.cardinality; ++c1i) {
            if (c2i >= c2.cardinality) {
                return false;
            }
            short k = c1.content[c1i];
            int s = ContainerUtil.unsignedBinarySearch(c2.content, c2i, c2.cardinality, k);
            if (s >= 0) {
                return true;
            }
            c2i = -(s + 1);
        }
        return false;
    }

    @Override
    public boolean overlapsRange(int rangeStart, int rangeEnd) {
        int s = ContainerUtil.unsignedBinarySearch(this.content, 0, this.cardinality, (short)rangeStart);
        if (s >= 0) {
            return true;
        }
        if ((s ^= 0xFFFFFFFF) >= this.cardinality) {
            return false;
        }
        int last = rangeEnd - 1;
        int e = ContainerUtil.unsignedBinarySearch(this.content, s, this.cardinality, (short)last);
        if (e >= 0) {
            return true;
        }
        return s != (e ^= 0xFFFFFFFF);
    }

    @Override
    public boolean overlaps(ArrayContainer c) {
        return this.cardinality < c.cardinality ? ArrayContainer.overlaps(this, c) : ArrayContainer.overlaps(c, this);
    }

    @Override
    public boolean overlaps(BitmapContainer c) {
        if (c.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.cardinality; ++i) {
            short k = this.content[i];
            if (!c.contains(k)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean overlaps(RunContainer c) {
        return this.getCardinality() < c.getCardinality() ? ContainerUtil.overlaps(this, c) : ContainerUtil.overlaps(c, this);
    }

    @Override
    public final void setCopyOnWrite() {
        if (this.shared) {
            return;
        }
        this.shared = true;
        this.onCopyOnWrite();
    }

    protected void onCopyOnWrite() {
    }

    private ArrayContainer deepcopyIfShared() {
        return this.shared ? this.deepCopy() : this;
    }

    @Override
    public int bytesAllocated() {
        return 2 * this.content.length;
    }

    @Override
    public int bytesUsed() {
        return 2 * this.cardinality;
    }

    @Override
    public Container toLargeContainer() {
        return this;
    }

    @Override
    public void validate() {
        int prev = -1;
        for (int i = 0; i < this.cardinality; ++i) {
            int val = ContainerUtil.toIntUnsigned(this.content[i]);
            if (val <= prev || val > 65535) {
                throw new IllegalStateException("i=" + i + ", prev=" + prev + ", val=" + val);
            }
            prev = val;
        }
    }

    @Override
    public boolean isShared() {
        return this.shared;
    }

    static final class ShortForwardIterator
    implements ShortIterator {
        private int pos;
        private ArrayContainer parent;

        ShortForwardIterator(ArrayContainer p) {
            this.wrap(p);
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.parent.cardinality - 1;
        }

        @Override
        public short next() {
            ++this.pos;
            return this.curr();
        }

        public short peekNext() {
            return this.parent.content[this.pos + 1];
        }

        public short curr() {
            return this.parent.content[this.pos];
        }

        @Override
        public int nextAsInt() {
            return ContainerUtil.toIntUnsigned(this.next());
        }

        public int currAsInt() {
            return ContainerUtil.toIntUnsigned(this.curr());
        }

        private void wrap(ArrayContainer p) {
            this.parent = p;
            this.pos = -1;
        }
    }

    static final class ReverseShortIterator
    implements ShortAdvanceIterator {
        private int pos;
        private ArrayContainer parent;

        ReverseShortIterator(ArrayContainer p) {
            this.wrap(p);
        }

        @Override
        public boolean hasNext() {
            return this.pos > 0;
        }

        @Override
        public short next() {
            return this.parent.content[--this.pos];
        }

        @Override
        public int nextAsInt() {
            return ContainerUtil.toIntUnsigned(this.next());
        }

        @Override
        public short curr() {
            return this.parent.content[this.pos];
        }

        @Override
        public int currAsInt() {
            return ContainerUtil.toIntUnsigned(this.curr());
        }

        @Override
        public boolean advance(int v) {
            if (this.pos == this.parent.cardinality) {
                --this.pos;
            }
            if (this.pos < 0) {
                return false;
            }
            if (ContainerUtil.toIntUnsigned(this.parent.content[this.pos]) <= v) {
                return true;
            }
            int i = ContainerUtil.unsignedBinarySearch(this.parent.content, 0, this.pos + 1, ContainerUtil.lowbits(v));
            if (i < 0) {
                if ((i = -i - 1) == 0) {
                    this.pos = 0;
                    return false;
                }
                this.pos = i - 1;
                return true;
            }
            this.pos = i;
            return true;
        }

        void wrap(ArrayContainer p) {
            this.parent = p;
            this.pos = this.parent.cardinality;
        }
    }
}

