/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl.rsp.container;

import io.deephaven.engine.rowset.impl.rsp.container.ArrayContainer;
import io.deephaven.engine.rowset.impl.rsp.container.BitmapContainerRangeIterator;
import io.deephaven.engine.rowset.impl.rsp.container.BitmapShortBatchIterator;
import io.deephaven.engine.rowset.impl.rsp.container.Container;
import io.deephaven.engine.rowset.impl.rsp.container.ContainerShortBatchIterator;
import io.deephaven.engine.rowset.impl.rsp.container.ContainerUtil;
import io.deephaven.engine.rowset.impl.rsp.container.MutableInteger;
import io.deephaven.engine.rowset.impl.rsp.container.PositionHint;
import io.deephaven.engine.rowset.impl.rsp.container.RangeConsumer;
import io.deephaven.engine.rowset.impl.rsp.container.RangeIterator;
import io.deephaven.engine.rowset.impl.rsp.container.RunContainer;
import io.deephaven.engine.rowset.impl.rsp.container.SearchRangeIterator;
import io.deephaven.engine.rowset.impl.rsp.container.ShortAdvanceIterator;
import io.deephaven.engine.rowset.impl.rsp.container.ShortConsumer;
import io.deephaven.engine.rowset.impl.rsp.container.ShortIterator;
import io.deephaven.engine.rowset.impl.rsp.container.ShortRangeConsumer;
import java.util.NoSuchElementException;
import java.util.function.Supplier;

public final class BitmapContainer
extends Container
implements Cloneable {
    protected static final int BITMAP_CAPACITY = 1024;
    protected static final int BITMAP_SIZE_IN_BYTES = 8192;
    public static final boolean USE_BRANCHLESS = true;
    final long[] bitmap;
    int cardinality;
    private boolean shared = false;

    public static ShortAdvanceIterator getReverseShortIterator(long[] bitmap) {
        return new ReverseShortIterator(bitmap);
    }

    public static ShortIterator getShortIterator(long[] bitmap) {
        return new ForwardShortIterator(bitmap);
    }

    public BitmapContainer() {
        this.cardinality = 0;
        this.bitmap = new long[1024];
    }

    private BitmapContainer(int start, int end) {
        this.cardinality = end - start;
        this.bitmap = new long[1024];
        ContainerUtil.setBitmapRange(this.bitmap, start, end);
    }

    public static BitmapContainer singleRange(int start, int end) {
        return new BitmapContainer(start, end);
    }

    private BitmapContainer(BitmapContainer other) {
        this.cardinality = other.cardinality;
        this.bitmap = new long[1024];
        System.arraycopy(other.bitmap, 0, this.bitmap, 0, this.bitmap.length);
    }

    BitmapContainer(long[] newBitmap, int newCardinality) {
        if (newBitmap.length != 1024 || newCardinality < 0 || newCardinality > 65536) {
            throw new IllegalArgumentException("newBitmap.length=" + newBitmap.length + ", newCardinality=" + newCardinality);
        }
        this.cardinality = newCardinality;
        this.bitmap = newBitmap;
    }

    private int findFirstZeroBit() {
        return this.findFirstZeroBit(0);
    }

    private int findFirstZeroBit(int iStart) {
        for (int i = iStart; i < this.bitmap.length; ++i) {
            long v = this.bitmap[i];
            if (v == -1L) continue;
            return 64 * i + Long.numberOfTrailingZeros(v ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return -1;
    }

    Container maybeSwitchContainer() {
        Container c = this.maybeSwitchContainerAfterShrinking();
        if (c != this) {
            return c;
        }
        return this.maybeSwitchContainerAfterGrowing();
    }

    private Container maybeSwitchContainerToArrayOrRun() {
        if (this.cardinality == 0) {
            return Container.empty();
        }
        if (this.cardinality <= 3835) {
            return this.toArrayContainer();
        }
        int frontZeroes = 0;
        int i = 0;
        while (this.bitmap[i++] == 0L) {
            ++frontZeroes;
        }
        int backZeroes = 0;
        i = 1023;
        while (this.bitmap[i--] == 0L) {
            ++backZeroes;
        }
        int bitsAvailableInNonZeroWords = (1024 - frontZeroes - backZeroes) * 8 * 8;
        int runsUpperBound1 = bitsAvailableInNonZeroWords / 2;
        int zeroBitsInNonZeroWords = bitsAvailableInNonZeroWords - this.cardinality;
        int runsUpperBound2 = 1 + zeroBitsInNonZeroWords;
        if (Math.min(runsUpperBound1, runsUpperBound2) < 1917) {
            return this.toRunContainer();
        }
        return this;
    }

    private Container maybeSwitchContainerAfterGrowing() {
        if (this.cardinality < 65535) {
            return this;
        }
        if (this.cardinality == 65535) {
            int v = this.findFirstZeroBit();
            if (v == 0) {
                return Container.singleRange(1, 65536);
            }
            if (v == 65535) {
                return Container.singleRange(0, 65535);
            }
            return Container.twoRanges(0, v, v + 1, 65536);
        }
        return Container.full();
    }

    private Container maybeSwitchContainerAfterShrinking() {
        if (this.cardinality == 0) {
            return Container.empty();
        }
        if (this.cardinality == 1) {
            return Container.singleton(ContainerUtil.lowbits(this.first()));
        }
        if (this.cardinality == 2) {
            return Container.twoValues(ContainerUtil.lowbits(this.first()), ContainerUtil.lowbits(this.last()));
        }
        if (this.cardinality <= 3835) {
            return this.toArrayContainer();
        }
        return this;
    }

    @Override
    public Container add(int begin, int end) {
        if (end == begin) {
            return this.cowRef();
        }
        if (begin > end || end > 65536) {
            throw new IllegalArgumentException("Invalid range [" + begin + "," + end + ")");
        }
        BitmapContainer ans = this.deepCopy();
        return ans.iaddImpl(begin, end);
    }

    @Override
    public Container iset(short x) {
        return this.setImpl(x, () -> this, this::deepCopyIfShared);
    }

    @Override
    public Container set(short x) {
        return this.setImpl(x, this::cowRef, this::deepCopy);
    }

    @Override
    Container iset(short x, PositionHint positionHint) {
        positionHint.reset();
        return this.iset(x);
    }

    @Override
    Container set(short x, PositionHint positionHint) {
        positionHint.reset();
        return this.set(x);
    }

    private Container setImpl(short x, Supplier<BitmapContainer> self, Supplier<BitmapContainer> copy) {
        if (this.contains(x)) {
            return self.get();
        }
        BitmapContainer ans = copy.get();
        ans.setUnsafe(x);
        return ans.maybeSwitchContainerAfterGrowing();
    }

    void setUnsafe(short x) {
        long newval;
        int xAsInt = ContainerUtil.toIntUnsigned(x);
        long previous = this.bitmap[xAsInt / 64];
        this.bitmap[xAsInt / 64] = newval = previous | 1L << xAsInt;
        this.cardinality = (int)((long)this.cardinality + ((previous ^ newval) >>> xAsInt));
    }

    @Override
    public ArrayContainer and(ArrayContainer value2) {
        ArrayContainer answer = new ArrayContainer(value2.content.length);
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            short v;
            answer.content[answer.cardinality] = v = value2.content[k];
            answer.cardinality = (int)((long)answer.cardinality + this.bitValue(v));
        }
        return answer;
    }

    @Override
    public Container and(BitmapContainer value2) {
        return this.iandImpl(value2, false);
    }

    @Override
    public Container and(RunContainer x) {
        return x.and(this);
    }

    @Override
    public Container andRange(int rangeStart, int rangeEnd) {
        return this.andRangeImpl(false, rangeStart, rangeEnd);
    }

    @Override
    public Container iandRange(int rangeStart, int rangeEnd) {
        return this.andRangeImpl(!this.shared, rangeStart, rangeEnd);
    }

    private Container andRangeImpl(boolean inPlace, int rangeStart, int rangeEnd) {
        int rLast;
        if (rangeEnd <= rangeStart || this.isEmpty()) {
            return Container.empty();
        }
        int first = this.first();
        if (first >= rangeEnd) {
            return Container.empty();
        }
        if (this.cardinality == 1) {
            if (first < rangeStart) {
                return Container.empty();
            }
            return Container.singleton(ContainerUtil.lowbits(first));
        }
        int last = this.last();
        if (last < rangeStart) {
            return Container.empty();
        }
        if (rangeStart <= first && last <= rangeEnd - 1) {
            if (inPlace) {
                return this;
            }
            return this.cowRef();
        }
        int rFirst = Math.max(first, rangeStart);
        ValuesInRangeContext ctx = new ValuesInRangeContext(rFirst, (rLast = Math.min(last, rangeEnd - 1)) + 1);
        int newCard = ctx.cardinalityInRange(this.bitmap);
        if (newCard == 0) {
            return Container.empty();
        }
        if (newCard <= 2) {
            ValuesInRangeIter it = new ValuesInRangeIter(this.bitmap, ctx);
            if (!it.hasNext()) {
                throw new IllegalStateException();
            }
            short v0 = it.next();
            if (!it.hasNext()) {
                return Container.singleton(v0);
            }
            short v1 = it.next();
            if (it.hasNext()) {
                throw new IllegalStateException("v=" + it.next());
            }
            return Container.twoValues(v0, v1);
        }
        if (newCard <= 3835) {
            ArrayContainer ans = new ArrayContainer(newCard);
            ValuesInRangeIter it = new ValuesInRangeIter(this.bitmap, ctx);
            while (it.hasNext()) {
                ans.content[ans.cardinality++] = it.next();
            }
            return ans;
        }
        BitmapContainer ans = inPlace ? this : new BitmapContainer();
        long v = this.bitmap[ctx.iFirst] & ctx.maskFirst;
        if (ctx.iFirst == ctx.iLast) {
            ans.bitmap[ctx.iFirst] = v &= ctx.maskLast;
            ans.cardinality = Long.bitCount(v);
            return ans;
        }
        ans.bitmap[ctx.iFirst] = v;
        ans.cardinality = Long.bitCount(v);
        for (int i = ctx.iFirst + 1; i < ctx.iLast; ++i) {
            ans.bitmap[i] = v = this.bitmap[i];
            ans.cardinality += Long.bitCount(v);
        }
        ans.bitmap[ctx.iLast] = v = this.bitmap[ctx.iLast] & ctx.maskLast;
        ans.cardinality += Long.bitCount(v);
        return ans;
    }

    @Override
    public Container andNot(ArrayContainer value2) {
        if (value2.isEmpty()) {
            return this.cowRef();
        }
        BitmapContainer answer = this.deepCopy();
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            long aft;
            short v = value2.content[k];
            int i = ContainerUtil.toIntUnsigned(v) >>> 6;
            long w = answer.bitmap[i];
            answer.bitmap[i] = aft = w & (1L << v ^ 0xFFFFFFFFFFFFFFFFL);
            answer.cardinality = (int)((long)answer.cardinality - ((w ^ aft) >>> v));
        }
        return answer.maybeSwitchContainerAfterShrinking();
    }

    @Override
    public Container andNot(BitmapContainer value2) {
        if (value2.isEmpty()) {
            return this.cowRef();
        }
        return this.iandNotImpl(value2, false);
    }

    @Override
    public Container andNot(RunContainer x) {
        if (x.isEmpty()) {
            return this.cowRef();
        }
        BitmapContainer answer = this.deepCopy();
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            int start = ContainerUtil.toIntUnsigned(x.getValue(rlepos));
            int end = start + ContainerUtil.toIntUnsigned(x.getLength(rlepos)) + 1;
            int prevOnesInRange = answer.cardinalityInRange(start, end);
            ContainerUtil.resetBitmapRange(answer.bitmap, start, end);
            answer.updateCardinality(prevOnesInRange, 0);
        }
        return answer.maybeSwitchContainerAfterShrinking();
    }

    @Override
    public BitmapContainer cowRef() {
        this.setCopyOnWrite();
        return this;
    }

    @Override
    public BitmapContainer deepCopy() {
        return new BitmapContainer(this);
    }

    @Override
    public boolean isEmpty() {
        return this.cardinality == 0;
    }

    @Override
    public boolean isAllOnes() {
        return this.cardinality == 65536;
    }

    private static int computeCardinality(BitmapContainer bc) {
        int cardinality = 0;
        for (int k = 0; k < bc.bitmap.length; ++k) {
            cardinality += Long.bitCount(bc.bitmap[k]);
        }
        return cardinality;
    }

    protected int cardinalityInRange(int start, int end) {
        if (end - start > 32768) {
            int before = ContainerUtil.cardinalityInBitmapRange(this.bitmap, 0, start);
            int after = ContainerUtil.cardinalityInBitmapRange(this.bitmap, end, 65536);
            return this.cardinality - before - after;
        }
        return ContainerUtil.cardinalityInBitmapRange(this.bitmap, start, end);
    }

    protected void updateCardinality(int prevOnes, int newOnes) {
        int oldCardinality = this.cardinality;
        this.cardinality = oldCardinality - prevOnes + newOnes;
    }

    @Override
    public boolean contains(short i) {
        int x = ContainerUtil.toIntUnsigned(i);
        return (this.bitmap[x / 64] & 1L << x) != 0L;
    }

    @Override
    public boolean contains(int rangeStart, int rangeEnd) {
        ValuesInRangeContext ctx = new ValuesInRangeContext(rangeStart, rangeEnd);
        if (ctx.iFirst == ctx.iLast) {
            return (this.bitmap[ctx.iLast] & ctx.maskFirst & ctx.maskLast) == (ctx.maskFirst & ctx.maskLast);
        }
        if ((this.bitmap[ctx.iFirst] & ctx.maskFirst) != ctx.maskFirst) {
            return false;
        }
        if ((this.bitmap[ctx.iLast] & ctx.maskLast) != ctx.maskLast) {
            return false;
        }
        for (int i = ctx.iFirst + 1; i < this.bitmap.length && i < ctx.iLast; ++i) {
            if (this.bitmap[i] == -1L) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean contains(BitmapContainer bitmapContainer) {
        if (this.cardinality < bitmapContainer.cardinality) {
            return false;
        }
        for (int i = 0; i < bitmapContainer.bitmap.length; ++i) {
            long v = bitmapContainer.bitmap[i];
            if ((this.bitmap[i] & v) == v) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean contains(RunContainer runContainer) {
        int numRuns = runContainer.numberOfRuns();
        if (this.cardinality < numRuns) {
            return false;
        }
        for (int i = 0; i < numRuns; ++i) {
            int length;
            int start = ContainerUtil.toIntUnsigned(runContainer.getValue(i));
            if (this.contains(start, start + (length = ContainerUtil.toIntUnsigned(runContainer.getLength(i))) + 1)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean contains(ArrayContainer arrayContainer) {
        if (this.cardinality < arrayContainer.cardinality) {
            return false;
        }
        for (int i = 0; i < arrayContainer.cardinality; ++i) {
            if (this.contains(arrayContainer.content[i])) continue;
            return false;
        }
        return true;
    }

    protected long bitValue(short i) {
        int x = ContainerUtil.toIntUnsigned(i);
        return this.bitmap[x / 64] >>> x & 1L;
    }

    protected void fillArray(short[] array) {
        int pos = 0;
        int base = 0;
        long[] lArray = this.bitmap;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            for (long bits = lArray[i]; bits != 0L; bits &= bits - 1L) {
                array[pos++] = (short)(base + Long.numberOfTrailingZeros(bits));
            }
            base += 64;
        }
    }

    int fillArrayWithSkipValue(short[] array, short valueToSkip, PositionHint positionHintOut) {
        int pos = 0;
        int base = 0;
        long[] lArray = this.bitmap;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            for (long bits = lArray[i]; bits != 0L; bits &= bits - 1L) {
                short v = (short)(base + Long.numberOfTrailingZeros(bits));
                if (v != valueToSkip) {
                    array[pos++] = v;
                    continue;
                }
                MutableInteger.setIfNotNull(positionHintOut, pos);
            }
            base += 64;
        }
        return pos;
    }

    @Override
    public Container iflip(short x) {
        long mask;
        boolean isOnAndWillBeTurnedOff;
        int xAsInt = ContainerUtil.toIntUnsigned(x);
        int index = xAsInt / 64;
        long bef = this.bitmap[index];
        boolean bl = isOnAndWillBeTurnedOff = (bef & (mask = 1L << xAsInt)) != 0L;
        if (isOnAndWillBeTurnedOff && this.cardinality <= 3835) {
            if (this.cardinality > 3) {
                ArrayContainer ac = new ArrayContainer(this.cardinality - 1);
                ac.loadDataWithSkipValue(this, x, null);
                return ac;
            }
            if (this.cardinality == 1) {
                return Container.empty();
            }
            int first = -1;
            int second = -1;
            ShortIterator it = this.getShortIterator();
            while (it.hasNext()) {
                int v = it.nextAsInt();
                if (v == xAsInt) continue;
                if (first == -1) {
                    first = v;
                    continue;
                }
                second = v;
                break;
            }
            if (first != -1) {
                if (second != -1) {
                    if (first + 1 == second) {
                        return BitmapContainer.makeSingleRangeContainer(first, second + 1);
                    }
                    return BitmapContainer.makeTwoValuesContainer(ContainerUtil.lowbits(first), ContainerUtil.lowbits(second));
                }
                return BitmapContainer.makeSingletonContainer(ContainerUtil.lowbits(first));
            }
            throw new IllegalStateException("first=-1");
        }
        BitmapContainer ans = this.deepCopyIfShared();
        ans.cardinality = (int)((long)ans.cardinality + (1L - 2L * ((bef & mask) >>> xAsInt)));
        int n = index;
        ans.bitmap[n] = ans.bitmap[n] ^ mask;
        if (isOnAndWillBeTurnedOff) {
            return ans.maybeSwitchContainerAfterShrinking();
        }
        return ans.maybeSwitchContainerAfterGrowing();
    }

    @Override
    public int getCardinality() {
        return this.cardinality;
    }

    @Override
    public ShortAdvanceIterator getReverseShortIterator() {
        return new ReverseShortIterator(this.bitmap);
    }

    @Override
    public ShortIterator getShortIterator() {
        return new ForwardShortIterator(this.bitmap);
    }

    @Override
    public ContainerShortBatchIterator getShortBatchIterator(int skipCount) {
        if (DEBUG && skipCount != 0 && skipCount >= this.cardinality) {
            throw new IllegalArgumentException("initialSeek=" + skipCount);
        }
        return new BitmapShortBatchIterator(this, skipCount);
    }

    @Override
    public SearchRangeIterator getShortRangeIterator(int initialSeek) {
        if (DEBUG && initialSeek != 0 && initialSeek >= this.cardinality) {
            throw new IllegalArgumentException("initialSeek=" + initialSeek);
        }
        return new BitmapContainerRangeIterator(this, initialSeek);
    }

    @Override
    public Container iadd(int begin, int end) {
        if (end == begin) {
            return this;
        }
        if (begin > end || end > 65536) {
            throw new IllegalArgumentException("Invalid range [" + begin + "," + end + ")");
        }
        BitmapContainer ans = this.deepCopyIfShared();
        return ans.iaddImpl(begin, end);
    }

    private Container iaddImpl(int begin, int end) {
        int prevOnesInRange = this.cardinalityInRange(begin, end);
        ContainerUtil.setBitmapRange(this.bitmap, begin, end);
        this.updateCardinality(prevOnesInRange, end - begin);
        return this.maybeSwitchContainerAfterGrowing();
    }

    @Override
    public Container iappend(int begin, int end) {
        BitmapContainer ans = this.deepCopyIfShared();
        ContainerUtil.setBitmapRange(ans.bitmap, begin, end);
        ans.cardinality += end - begin;
        return ans.maybeSwitchContainerAfterGrowing();
    }

    @Override
    public Container iand(ArrayContainer b2) {
        return this.and(b2);
    }

    @Override
    public Container iand(BitmapContainer b2) {
        return this.iandImpl(b2, true);
    }

    private Container iandImpl(BitmapContainer b2, boolean inPlace) {
        if (b2.isEmpty()) {
            return Container.empty();
        }
        int newCardinality = 0;
        int ixFirstNonZero = -1;
        int ixSecondNonZero = -1;
        for (int k = 0; k < this.bitmap.length; ++k) {
            long r = this.bitmap[k] & b2.bitmap[k];
            if (r == 0L) continue;
            if (ixFirstNonZero == -1) {
                ixFirstNonZero = k;
            } else if (ixSecondNonZero == -1) {
                ixSecondNonZero = k;
            }
            newCardinality += Long.bitCount(r);
        }
        if (newCardinality == 0) {
            return Container.empty();
        }
        if (newCardinality == 1) {
            long v = this.bitmap[ixFirstNonZero] & b2.bitmap[ixFirstNonZero];
            return Container.singleton(ContainerUtil.lowbits(64 * ixFirstNonZero + Long.numberOfTrailingZeros(v)));
        }
        if (newCardinality == 2) {
            int v1;
            long v0word = this.bitmap[ixFirstNonZero] & b2.bitmap[ixFirstNonZero];
            int v0 = 64 * ixFirstNonZero + Long.numberOfTrailingZeros(v0word);
            if (ixSecondNonZero == -1) {
                v1 = (ixFirstNonZero + 1) * 64 - Long.numberOfLeadingZeros(v0word) - 1;
            } else {
                long v1word = this.bitmap[ixSecondNonZero] & b2.bitmap[ixSecondNonZero];
                v1 = 64 * ixSecondNonZero + Long.numberOfTrailingZeros(v1word);
            }
            return Container.twoValues(ContainerUtil.lowbits(v0), ContainerUtil.lowbits(v1));
        }
        if (newCardinality > 3835) {
            BitmapContainer ans = inPlace ? this.deepCopyIfShared() : new BitmapContainer();
            for (int k = 0; k < ans.bitmap.length; ++k) {
                ans.bitmap[k] = this.bitmap[k] & b2.bitmap[k];
            }
            ans.cardinality = newCardinality;
            return ans;
        }
        ArrayContainer ac = new ArrayContainer(newCardinality);
        ContainerUtil.fillArrayAND(ac.content, this.bitmap, b2.bitmap);
        ac.cardinality = newCardinality;
        return ac;
    }

    @Override
    public Container iand(RunContainer x) {
        if (x.isEmpty()) {
            return Container.empty();
        }
        int card = x.getCardinality();
        if (card <= 3835) {
            ArrayContainer answer = new ArrayContainer(card);
            answer.cardinality = 0;
            for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
                int runStart = ContainerUtil.toIntUnsigned(x.getValue(rlepos));
                int runEnd = runStart + ContainerUtil.toIntUnsigned(x.getLength(rlepos));
                for (int runValue = runStart; runValue <= runEnd; ++runValue) {
                    answer.content[answer.cardinality] = (short)runValue;
                    answer.cardinality = (int)((long)answer.cardinality + this.bitValue((short)runValue));
                }
            }
            return answer.maybeSwitchContainer();
        }
        BitmapContainer ans = this.deepCopyIfShared();
        return ans.iandImpl(x);
    }

    private Container iandImpl(RunContainer x) {
        int start = 0;
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            int end = ContainerUtil.toIntUnsigned(x.getValue(rlepos));
            int prevOnes = this.cardinalityInRange(start, end);
            ContainerUtil.resetBitmapRange(this.bitmap, start, end);
            this.updateCardinality(prevOnes, 0);
            start = end + ContainerUtil.toIntUnsigned(x.getLength(rlepos)) + 1;
        }
        int ones = this.cardinalityInRange(start, 65536);
        ContainerUtil.resetBitmapRange(this.bitmap, start, 65536);
        this.updateCardinality(ones, 0);
        return this.maybeSwitchContainerAfterShrinking();
    }

    @Override
    public Container iandNot(ArrayContainer b2) {
        if (b2.isEmpty()) {
            return this;
        }
        BitmapContainer ans = this.deepCopyIfShared();
        return ans.iandNotImpl(b2);
    }

    private Container iandNotImpl(ArrayContainer b2) {
        for (int k = 0; k < b2.cardinality; ++k) {
            int x = ContainerUtil.toIntUnsigned(b2.content[k]);
            int index = x / 64;
            long bef = this.bitmap[index];
            long mask = 1L << x;
            long aft = bef & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            this.cardinality = (int)((long)this.cardinality - (aft - bef >>> 63));
            this.bitmap[index] = aft;
        }
        return this.maybeSwitchContainerAfterShrinking();
    }

    @Override
    public Container iandNot(BitmapContainer b2) {
        if (b2.isEmpty()) {
            return this;
        }
        return this.iandNotImpl(b2, true);
    }

    private Container iandNotImpl(BitmapContainer b2, boolean inPlace) {
        int newCardinality = 0;
        int ixFirstNonZero = -1;
        int ixSecondNonZero = -1;
        for (int k = 0; k < this.bitmap.length; ++k) {
            long v = this.bitmap[k] & (b2.bitmap[k] ^ 0xFFFFFFFFFFFFFFFFL);
            if (v == 0L) continue;
            if (ixFirstNonZero == -1) {
                ixFirstNonZero = k;
            } else if (ixSecondNonZero == -1) {
                ixSecondNonZero = k;
            }
            newCardinality += Long.bitCount(v);
        }
        if (newCardinality == 0) {
            return Container.empty();
        }
        if (newCardinality == 1) {
            long v = this.bitmap[ixFirstNonZero] & (b2.bitmap[ixFirstNonZero] ^ 0xFFFFFFFFFFFFFFFFL);
            return Container.singleton(ContainerUtil.lowbits(64 * ixFirstNonZero + Long.numberOfTrailingZeros(v)));
        }
        if (newCardinality == 2) {
            int v1;
            long v0word = this.bitmap[ixFirstNonZero] & (b2.bitmap[ixFirstNonZero] ^ 0xFFFFFFFFFFFFFFFFL);
            int v0 = 64 * ixFirstNonZero + Long.numberOfTrailingZeros(v0word);
            if (ixSecondNonZero == -1) {
                v1 = (ixFirstNonZero + 1) * 64 - Long.numberOfLeadingZeros(v0word) - 1;
            } else {
                long v2word = this.bitmap[ixSecondNonZero] & (b2.bitmap[ixSecondNonZero] ^ 0xFFFFFFFFFFFFFFFFL);
                v1 = 64 * ixSecondNonZero + (63 - Long.numberOfLeadingZeros(v2word));
            }
            return Container.twoValues(ContainerUtil.lowbits(v0), ContainerUtil.lowbits(v1));
        }
        if (newCardinality > 3835) {
            BitmapContainer ans = inPlace ? this.deepCopyIfShared() : new BitmapContainer();
            for (int k = 0; k < this.bitmap.length; ++k) {
                ans.bitmap[k] = this.bitmap[k] & (b2.bitmap[k] ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ans.cardinality = newCardinality;
            return ans;
        }
        ArrayContainer ac = new ArrayContainer(newCardinality);
        ContainerUtil.fillArrayANDNOT(ac.content, this.bitmap, b2.bitmap);
        ac.cardinality = newCardinality;
        return ac.maybeSwitchContainer();
    }

    @Override
    public Container iandNot(RunContainer x) {
        if (x.isEmpty()) {
            return this;
        }
        BitmapContainer ans = this.deepCopyIfShared();
        return ans.iandNotImpl(x);
    }

    private Container iandNotImpl(RunContainer x) {
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            int start = ContainerUtil.toIntUnsigned(x.getValue(rlepos));
            int end = start + ContainerUtil.toIntUnsigned(x.getLength(rlepos)) + 1;
            int prevOnesInRange = this.cardinalityInRange(start, end);
            ContainerUtil.resetBitmapRange(this.bitmap, start, end);
            this.updateCardinality(prevOnesInRange, 0);
        }
        return this.maybeSwitchContainerAfterShrinking();
    }

    @Override
    public Container inot(int firstOfRange, int lastOfRange) {
        BitmapContainer ans = this.deepCopyIfShared();
        return ans.inotImpl(firstOfRange, lastOfRange);
    }

    private Container inotImpl(int firstOfRange, int lastOfRange) {
        int prevOnes = this.cardinalityInRange(firstOfRange, lastOfRange);
        ContainerUtil.flipBitmapRange(this.bitmap, firstOfRange, lastOfRange);
        this.updateCardinality(prevOnes, lastOfRange - firstOfRange - prevOnes);
        return this.maybeSwitchContainer();
    }

    @Override
    public Container ior(ArrayContainer value2) {
        if (this.shared) {
            return this.or(value2);
        }
        if (this.isAllOnes()) {
            return Container.full();
        }
        if (value2.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return value2.cowRef();
        }
        BitmapContainer ans = this.deepCopyIfShared();
        return ans.iorImpl(value2);
    }

    private BitmapContainer iorImpl(ArrayContainer value2) {
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            long aft;
            int i = ContainerUtil.toIntUnsigned(value2.content[k]) >>> 6;
            long bef = this.bitmap[i];
            this.bitmap[i] = aft = bef | 1L << value2.content[k];
            this.cardinality = (int)((long)this.cardinality + (bef - aft >>> 63));
        }
        return this;
    }

    @Override
    public Container ior(BitmapContainer b2) {
        if (this.shared) {
            return this.or(b2);
        }
        if (this.isAllOnes() || b2.isAllOnes()) {
            return Container.full();
        }
        if (b2.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return b2.cowRef();
        }
        BitmapContainer ans = this.deepCopyIfShared();
        return ans.iorImpl(b2);
    }

    private Container iorImpl(BitmapContainer b2) {
        this.cardinality = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            long w;
            this.bitmap[k] = w = this.bitmap[k] | b2.bitmap[k];
            this.cardinality += Long.bitCount(w);
        }
        if (this.isAllOnes()) {
            return Container.full();
        }
        return this;
    }

    @Override
    public Container ior(RunContainer x) {
        if (this.shared) {
            return this.or(x);
        }
        if (this.isAllOnes()) {
            return Container.full();
        }
        if (x.isEmpty()) {
            return this;
        }
        if (this.isEmpty() || x.isAllOnes()) {
            return x.cowRef();
        }
        return this.iorImpl(x);
    }

    private Container iorImpl(RunContainer x) {
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            int start = ContainerUtil.toIntUnsigned(x.getValue(rlepos));
            int end = start + ContainerUtil.toIntUnsigned(x.getLength(rlepos)) + 1;
            int prevOnesInRange = this.cardinalityInRange(start, end);
            ContainerUtil.setBitmapRange(this.bitmap, start, end);
            this.updateCardinality(prevOnesInRange, end - start);
        }
        if (this.isAllOnes()) {
            return Container.full();
        }
        return this;
    }

    @Override
    public Container iremove(int begin, int end) {
        if (end == begin) {
            return this;
        }
        if (begin > end || end > 65536) {
            throw new IllegalArgumentException("Invalid range [" + begin + "," + end + ")");
        }
        BitmapContainer ans = this.deepCopyIfShared();
        return ans.iremoveImpl(begin, end);
    }

    private Container iremoveImpl(int begin, int end) {
        int prevOnesInRange = this.cardinalityInRange(begin, end);
        ContainerUtil.resetBitmapRange(this.bitmap, begin, end);
        this.updateCardinality(prevOnesInRange, 0);
        return this.maybeSwitchContainerAfterShrinking();
    }

    @Override
    public Container ixor(ArrayContainer value2) {
        if (this.shared) {
            return this.xor(value2);
        }
        if (value2.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return value2.cowRef();
        }
        return this.ixorImpl(value2);
    }

    private Container ixorImpl(ArrayContainer value2) {
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            short vc = value2.content[k];
            long mask = 1L << vc;
            int index = ContainerUtil.toIntUnsigned(vc) >>> 6;
            long ba = this.bitmap[index];
            this.cardinality = (int)((long)this.cardinality + (1L - 2L * ((ba & mask) >>> vc)));
            this.bitmap[index] = ba ^ mask;
        }
        return this.maybeSwitchContainer();
    }

    @Override
    public Container ixor(BitmapContainer b2) {
        int k;
        if (this.shared) {
            return this.xor(b2);
        }
        if (b2.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return b2.cowRef();
        }
        int newCardinality = 0;
        for (k = 0; k < this.bitmap.length; ++k) {
            newCardinality += Long.bitCount(this.bitmap[k] ^ b2.bitmap[k]);
        }
        if (newCardinality > 3835) {
            for (k = 0; k < this.bitmap.length; ++k) {
                this.bitmap[k] = this.bitmap[k] ^ b2.bitmap[k];
            }
            this.cardinality = newCardinality;
            return this;
        }
        ArrayContainer ac = new ArrayContainer(newCardinality);
        ContainerUtil.fillArrayXOR(ac.content, this.bitmap, b2.bitmap);
        ac.cardinality = newCardinality;
        return ac.maybeSwitchContainer();
    }

    @Override
    public Container ixor(RunContainer x) {
        if (this.shared) {
            return this.xor(x);
        }
        if (x.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return x.cowRef();
        }
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            int start = ContainerUtil.toIntUnsigned(x.getValue(rlepos));
            int end = start + ContainerUtil.toIntUnsigned(x.getLength(rlepos)) + 1;
            int prevOnes = this.cardinalityInRange(start, end);
            ContainerUtil.flipBitmapRange(this.bitmap, start, end);
            this.updateCardinality(prevOnes, end - start - prevOnes);
        }
        return this.maybeSwitchContainer();
    }

    protected void loadData(ArrayContainer arrayContainer) {
        this.cardinality = arrayContainer.cardinality;
        for (int k = 0; k < arrayContainer.cardinality; ++k) {
            short x = arrayContainer.content[k];
            this.bitmapSet(x);
        }
    }

    void bitmapSet(short x) {
        int n = ContainerUtil.toIntUnsigned(x) / 64;
        this.bitmap[n] = this.bitmap[n] | 1L << x;
    }

    public int nextSetBit(int i) {
        int x = i >> 6;
        long w = this.bitmap[x];
        if ((w >>>= i) != 0L) {
            return i + Long.numberOfTrailingZeros(w);
        }
        ++x;
        while (x < this.bitmap.length) {
            if (this.bitmap[x] != 0L) {
                return x * 64 + Long.numberOfTrailingZeros(this.bitmap[x]);
            }
            ++x;
        }
        return -1;
    }

    @Override
    public Container not(int firstOfRange, int lastOfRange) {
        BitmapContainer answer = this.deepCopy();
        return answer.inot(firstOfRange, lastOfRange);
    }

    @Override
    int numberOfRuns() {
        int numRuns = 0;
        long nextWord = this.bitmap[0];
        for (int i = 0; i < this.bitmap.length - 1; ++i) {
            long word = nextWord;
            nextWord = this.bitmap[i + 1];
            numRuns = (int)((long)numRuns + ((long)Long.bitCount((word ^ 0xFFFFFFFFFFFFFFFFL) & word << 1) + (word >>> 63 & (nextWord ^ 0xFFFFFFFFFFFFFFFFL))));
        }
        long word = nextWord;
        numRuns += Long.bitCount((word ^ 0xFFFFFFFFFFFFFFFFL) & word << 1);
        if ((word & Long.MIN_VALUE) != 0L) {
            ++numRuns;
        }
        return numRuns;
    }

    @Override
    public Container or(ArrayContainer value2) {
        if (this.isAllOnes()) {
            return Container.full();
        }
        if (value2.isEmpty()) {
            return this.cowRef();
        }
        if (this.isEmpty()) {
            return value2.cowRef();
        }
        BitmapContainer answer = this.deepCopy();
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            long aft;
            short v = value2.content[k];
            int i = ContainerUtil.toIntUnsigned(v) >>> 6;
            long w = answer.bitmap[i];
            answer.bitmap[i] = aft = w | 1L << v;
            answer.cardinality = (int)((long)answer.cardinality + (w - aft >>> 63));
        }
        if (answer.isAllOnes()) {
            return Container.full();
        }
        return answer;
    }

    @Override
    public Container or(BitmapContainer value2) {
        if (this.isAllOnes() || value2.isAllOnes()) {
            return Container.full();
        }
        if (value2.isEmpty()) {
            return this.cowRef();
        }
        if (this.isEmpty()) {
            return value2.cowRef();
        }
        BitmapContainer value1 = this.deepCopy();
        return value1.iorImpl(value2);
    }

    @Override
    public Container or(RunContainer x) {
        return x.or(this);
    }

    public int prevSetBit(int i) {
        int x = i >> 6;
        long w = this.bitmap[x];
        if ((w <<= 64 - i - 1) != 0L) {
            return i - Long.numberOfLeadingZeros(w);
        }
        --x;
        while (x >= 0) {
            if (this.bitmap[x] != 0L) {
                return x * 64 + 63 - Long.numberOfLeadingZeros(this.bitmap[x]);
            }
            --x;
        }
        return -1;
    }

    @Override
    public int rank(short lowbits) {
        int x = ContainerUtil.toIntUnsigned(lowbits);
        int leftover = x + 1 & 0x3F;
        int answer = 0;
        for (int k = 0; k < (x + 1) / 64; ++k) {
            answer += Long.bitCount(this.bitmap[k]);
        }
        if (leftover != 0) {
            answer += Long.bitCount(this.bitmap[(x + 1) / 64] << 64 - leftover);
        }
        return answer;
    }

    @Override
    public Container remove(int begin, int end) {
        if (end == begin) {
            return this.cowRef();
        }
        if (begin > end || end > 65536) {
            throw new IllegalArgumentException("Invalid range [" + begin + "," + end + ")");
        }
        BitmapContainer answer = this.deepCopy();
        return answer.iremoveImpl(begin, end);
    }

    @Override
    public Container iunset(short v) {
        return this.unsetImpl(v, true, null);
    }

    @Override
    public Container unset(short v) {
        return this.unsetImpl(v, false, null);
    }

    @Override
    Container iunset(short x, PositionHint positionHint) {
        return this.unsetImpl(x, true, positionHint);
    }

    @Override
    Container unset(short x, PositionHint positionHint) {
        return this.unsetImpl(x, false, positionHint);
    }

    private Container unsetImpl(short v, boolean inPlace, PositionHint positionHintOut) {
        long mask;
        int x = ContainerUtil.toIntUnsigned(v);
        int index = x / 64;
        long bef = this.bitmap[index];
        if ((bef & (mask = 1L << x)) == 0L) {
            PositionHint.resetIfNotNull(positionHintOut);
            return inPlace ? this : this.cowRef();
        }
        int newCardinality = this.cardinality - 1;
        if (newCardinality > 3835) {
            long aft = bef & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            BitmapContainer ans = inPlace ? this.deepCopyIfShared() : this.deepCopy();
            ans.cardinality = newCardinality;
            ans.bitmap[index] = aft;
            PositionHint.resetIfNotNull(positionHintOut);
            return ans;
        }
        if (newCardinality == 0) {
            return Container.empty();
        }
        if (newCardinality == 1) {
            MutableInteger mi = new MutableInteger(-1);
            this.searchForwardForNonzeroWord(0, (k, word) -> {
                if (k == index && (word &= mask ^ 0xFFFFFFFFFFFFFFFFL) == 0L) {
                    return false;
                }
                mi.value = 64 * k + Long.numberOfTrailingZeros(word);
                return true;
            });
            PositionHint.resetIfNotNull(positionHintOut);
            return Container.singleton(ContainerUtil.lowbits(mi.value));
        }
        if (newCardinality == 2) {
            MutableInteger mi0 = new MutableInteger(-1);
            MutableInteger mi1 = new MutableInteger(-1);
            this.searchForwardForNonzeroWord(0, (k, word) -> {
                if (k == index && (word &= mask ^ 0xFFFFFFFFFFFFFFFFL) == 0L) {
                    return false;
                }
                int trail0s = Long.numberOfTrailingZeros(word);
                int kValue = 64 * k + trail0s;
                if (mi0.value == -1) {
                    mi0.value = kValue;
                    if (Long.bitCount(word) > 1) {
                        int lead0s = Long.numberOfLeadingZeros(word);
                        mi1.value = (k + 1) * 64 - lead0s - 1;
                        return true;
                    }
                    return false;
                }
                mi1.value = kValue;
                return true;
            });
            PositionHint.resetIfNotNull(positionHintOut);
            return Container.twoValues(ContainerUtil.lowbits(mi0.value), ContainerUtil.lowbits(mi1.value));
        }
        ArrayContainer ac = new ArrayContainer(newCardinality);
        ac.loadDataWithSkipValue(this, v, positionHintOut);
        return ac;
    }

    @Override
    public Container runOptimize() {
        Container c = this.maybeSwitchContainer();
        if (c != this) {
            return c;
        }
        return this.maybeSwitchContainerToArrayOrRun();
    }

    @Override
    public short select(int j) {
        int leftover = j;
        for (int k = 0; k < this.bitmap.length; ++k) {
            int w = Long.bitCount(this.bitmap[k]);
            if (w > leftover) {
                return (short)(k * 64 + ContainerUtil.select(this.bitmap[k], leftover));
            }
            leftover -= w;
        }
        throw new IllegalArgumentException("Insufficient cardinality.");
    }

    private ArrayContainer selectToArrayContainer(int startRank, int count) {
        ArrayContainer c = new ArrayContainer(count);
        SeekToRankContext seeker = new SeekToRankContext(startRank);
        int i = seeker.index;
        long word = seeker.wordAtIndexAfterDiscards;
        int base = 64 * i;
        int pos = 0;
        while (true) {
            if (word != 0L) {
                short v = (short)(base + Long.numberOfTrailingZeros(word));
                c.content[pos++] = v;
                if (pos >= count) break;
                word &= word - 1L;
                continue;
            }
            base += 64;
            if (++i >= this.bitmap.length) break;
            word = this.bitmap[i];
        }
        c.cardinality = count;
        return c;
    }

    private BitmapContainer selectToBitmapContainer(int startRank, int count) {
        BitmapContainer c;
        block5: {
            int preCardPlusBitCount;
            c = new BitmapContainer();
            SeekToRankContext seeker = new SeekToRankContext(startRank);
            int i = seeker.index;
            long word = seeker.wordAtIndexAfterDiscards;
            int bitCount = Long.bitCount(word);
            int preCard = 0;
            while ((preCardPlusBitCount = preCard + bitCount) < count) {
                c.bitmap[i] = word;
                if (++i < this.bitmap.length) {
                    preCard = preCardPlusBitCount;
                    word = this.bitmap[i];
                    bitCount = Long.bitCount(word);
                    continue;
                }
                break block5;
            }
            if (bitCount + preCard == count) {
                c.bitmap[i] = word;
            } else {
                int remaining = count - preCard;
                do {
                    long v = Long.lowestOneBit(word);
                    int n = i;
                    c.bitmap[n] = c.bitmap[n] | v;
                    word &= word - 1L;
                } while (--remaining > 0);
            }
        }
        c.cardinality = count;
        return c;
    }

    @Override
    public Container select(int startRank, int endRank) {
        if (endRank <= startRank || endRank > this.cardinality) {
            throw new IllegalArgumentException("startRank=" + startRank + ", endRank=" + endRank + ", cardinality=" + this.cardinality);
        }
        int card = endRank - startRank;
        if (card < 4090) {
            return this.selectToArrayContainer(startRank, card);
        }
        return this.selectToBitmapContainer(startRank, card);
    }

    private int findSecondHalf(int index, int rest, int bitCountPreIndex) {
        long preMask = (1L << rest) - 1L;
        long bitsAtIndex = this.bitmap[index];
        long preMasked = bitsAtIndex & preMask;
        int pos = bitCountPreIndex + Long.bitCount(preMasked);
        long mask = 1L << rest;
        long masked = bitsAtIndex & mask;
        if (masked != 0L) {
            return pos;
        }
        return -pos - 1;
    }

    @Override
    public int find(short x) {
        int value = ContainerUtil.toIntUnsigned(x);
        int index = value >>> 6;
        int r = value & 0x3F;
        int bitCountPreIndex = 0;
        for (int k = 0; k < index; ++k) {
            bitCountPreIndex += Long.bitCount(this.bitmap[k]);
        }
        return this.findSecondHalf(index, r, bitCountPreIndex);
    }

    @Override
    public void selectRanges(RangeConsumer outValues, RangeIterator inPositions) {
        if (!inPositions.hasNext()) {
            return;
        }
        int ostart = -1;
        int oend = -1;
        int wordIndex = 0;
        if (this.isEmpty()) {
            throw new IllegalArgumentException("select Ranges for invalid pos=" + inPositions.start());
        }
        int wordAccumBitCount = Long.bitCount(this.bitmap[0]);
        int prevWordAccumBitCount = 0;
        do {
            inPositions.next();
            int istart = inPositions.start();
            while (istart >= wordAccumBitCount) {
                if (++wordIndex >= this.bitmap.length) {
                    throw new IllegalArgumentException("selectRanges for invalid pos=" + istart);
                }
                prevWordAccumBitCount = wordAccumBitCount;
                wordAccumBitCount += Long.bitCount(this.bitmap[wordIndex]);
            }
            int key = wordIndex * 64 + ContainerUtil.select(this.bitmap[wordIndex], istart - prevWordAccumBitCount);
            if (ostart == -1) {
                ostart = oend = key;
            } else if (oend + 1 == key) {
                oend = key;
            } else {
                outValues.accept(ostart, oend + 1);
                ostart = oend = key;
            }
            int iend = inPositions.end();
            for (int j = istart + 1; j < iend; ++j) {
                while (j >= wordAccumBitCount) {
                    if (++wordIndex >= this.bitmap.length) {
                        throw new IllegalArgumentException("selectRanges for invalid pos=" + j);
                    }
                    prevWordAccumBitCount = wordAccumBitCount;
                    wordAccumBitCount += Long.bitCount(this.bitmap[wordIndex]);
                }
                key = wordIndex * 64 + ContainerUtil.select(this.bitmap[wordIndex], j - prevWordAccumBitCount);
                if (oend + 1 == key) {
                    oend = key;
                    continue;
                }
                outValues.accept(ostart, oend + 1);
                ostart = oend = key;
            }
        } while (inPositions.hasNext());
        outValues.accept(ostart, oend + 1);
    }

    @Override
    public boolean findRanges(RangeConsumer outPositions, RangeIterator inValues, int maxPos) {
        if (!inValues.hasNext()) {
            return false;
        }
        if (this.isEmpty()) {
            throw new IllegalArgumentException("find Ranges for invalid key=" + inValues.start());
        }
        int ostart = -1;
        int oend = -1;
        int k = 0;
        int kAccumBitCount = 0;
        do {
            inValues.next();
            int istart = inValues.start();
            int kistart = istart >>> 6;
            int ristart = istart & 0x3F;
            while (k < kistart) {
                if (k >= this.bitmap.length) {
                    throw new IllegalArgumentException("findRanges for invalid key=" + istart);
                }
                kAccumBitCount += Long.bitCount(this.bitmap[k]);
                ++k;
            }
            int pos = this.findSecondHalf(k, ristart, kAccumBitCount);
            if (pos < 0) {
                throw new IllegalArgumentException("findRanges for invalid key=" + istart);
            }
            if (ostart == -1) {
                if (pos > maxPos) {
                    return true;
                }
                ostart = oend = pos;
            } else {
                if (pos > maxPos) {
                    outPositions.accept(ostart, oend + 1);
                    return true;
                }
                if (oend + 1 == pos) {
                    oend = pos;
                } else {
                    outPositions.accept(ostart, oend + 1);
                    ostart = oend = pos;
                }
            }
            int iend = inValues.end();
            for (int j = istart + 1; j < iend; ++j) {
                int kj = j >>> 6;
                int rj = j & 0x3F;
                while (k < kj) {
                    if (k >= this.bitmap.length) {
                        throw new IllegalArgumentException("findRanges for invalid key=" + j);
                    }
                    kAccumBitCount += Long.bitCount(this.bitmap[k]);
                    ++k;
                }
                pos = this.findSecondHalf(k, rj, kAccumBitCount);
                if (pos < 0) {
                    throw new IllegalArgumentException("findRanges for invalid key=" + j);
                }
                if (pos > maxPos) {
                    outPositions.accept(ostart, oend + 1);
                    return true;
                }
                if (oend + 1 == pos) {
                    oend = pos;
                    continue;
                }
                outPositions.accept(ostart, oend + 1);
                ostart = oend = pos;
            }
        } while (inValues.hasNext());
        outPositions.accept(ostart, oend + 1);
        return false;
    }

    public ArrayContainer toArrayContainer() {
        ArrayContainer ac = new ArrayContainer(this.cardinality);
        ac.loadData(this);
        if (ac.getCardinality() != this.cardinality) {
            throw new RuntimeException("Internal error.");
        }
        return ac;
    }

    public RunContainer toRunContainer() {
        return new RunContainer(this);
    }

    @Override
    public void trim() {
    }

    @Override
    public Container xor(ArrayContainer value2) {
        if (value2.isEmpty()) {
            return this.cowRef();
        }
        if (this.isEmpty()) {
            return value2.cowRef();
        }
        BitmapContainer answer = this.deepCopy();
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            short vc = value2.content[k];
            int index = ContainerUtil.toIntUnsigned(vc) >>> 6;
            long mask = 1L << vc;
            long val = answer.bitmap[index];
            answer.cardinality = (int)((long)answer.cardinality + (1L - 2L * ((val & mask) >>> vc)));
            answer.bitmap[index] = val ^ mask;
        }
        return answer.maybeSwitchContainer();
    }

    @Override
    public Container xor(BitmapContainer value2) {
        if (value2.isEmpty()) {
            return this.cowRef();
        }
        if (this.isEmpty()) {
            return value2.cowRef();
        }
        int newCardinality = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            newCardinality += Long.bitCount(this.bitmap[k] ^ value2.bitmap[k]);
        }
        if (newCardinality > 3835) {
            BitmapContainer answer = new BitmapContainer();
            for (int k = 0; k < answer.bitmap.length; ++k) {
                answer.bitmap[k] = this.bitmap[k] ^ value2.bitmap[k];
            }
            answer.cardinality = newCardinality;
            return answer;
        }
        ArrayContainer ac = new ArrayContainer(newCardinality);
        ContainerUtil.fillArrayXOR(ac.content, this.bitmap, value2.bitmap);
        ac.cardinality = newCardinality;
        return ac.maybeSwitchContainer();
    }

    @Override
    public Container xor(RunContainer x) {
        return x.xor(this);
    }

    private boolean acceptBitsFrom(int x, long win, ShortConsumer sc) {
        for (long w = win; w != 0L; w &= w - 1L) {
            int v = x * 64 + Long.numberOfTrailingZeros(w);
            boolean wantMore = sc.accept((short)v);
            if (wantMore) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEach(ShortConsumer sc) {
        for (int x = 0; x < this.bitmap.length; ++x) {
            long w = this.bitmap[x];
            if (this.acceptBitsFrom(x, w, sc)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEach(int rankOffset, ShortConsumer sc) {
        long w;
        int x;
        int rank = 0;
        for (x = 0; rank < rankOffset && x < this.bitmap.length; ++x) {
            w = this.bitmap[x];
            if (w == 0L) continue;
            int bitCount = Long.bitCount(w);
            int nextRank = rank + bitCount;
            if (nextRank > rankOffset) {
                while (rank < rankOffset) {
                    w &= w - 1L;
                    ++rank;
                }
                if (!this.acceptBitsFrom(x, w, sc)) {
                    return false;
                }
                ++x;
                break;
            }
            rank = nextRank;
        }
        while (x < this.bitmap.length) {
            w = this.bitmap[x];
            if (!this.acceptBitsFrom(x, w, sc)) {
                return false;
            }
            ++x;
        }
        return true;
    }

    @Override
    public boolean forEachRange(int rankOffset, ShortRangeConsumer sc) {
        int v;
        int pendingStart;
        int x;
        int rank = 0;
        long w = 0L;
        for (x = 0; rank <= rankOffset && x < this.bitmap.length; ++x) {
            w = this.bitmap[x];
            if (w == 0L) continue;
            int bitCount = Long.bitCount(w);
            int nextRank = rank + bitCount;
            if (nextRank >= rankOffset) {
                while (rank < rankOffset) {
                    w &= w - 1L;
                    ++rank;
                }
                break;
            }
            rank = nextRank;
        }
        if (w == 0L) {
            do {
                if (x < this.bitmap.length - 1) continue;
                return true;
            } while ((w = this.bitmap[++x]) == 0L);
        }
        int xTimes64 = x * 64;
        int pendingEnd = pendingStart = xTimes64 + Long.numberOfTrailingZeros(w);
        w &= w - 1L;
        while (w != 0L) {
            v = xTimes64 + Long.numberOfTrailingZeros(w);
            if (pendingEnd + 1 == v) {
                pendingEnd = v;
            } else {
                if (!sc.accept((short)pendingStart, (short)pendingEnd)) {
                    return false;
                }
                pendingStart = pendingEnd = v;
            }
            w &= w - 1L;
        }
        ++x;
        while (x < this.bitmap.length) {
            w = this.bitmap[x];
            if (w != 0L) {
                xTimes64 = x * 64;
                do {
                    if (pendingEnd + 1 == (v = xTimes64 + Long.numberOfTrailingZeros(w))) {
                        pendingEnd = v;
                        continue;
                    }
                    if (!sc.accept((short)pendingStart, (short)pendingEnd)) {
                        return false;
                    }
                    pendingStart = pendingEnd = v;
                } while ((w &= w - 1L) != 0L);
            }
            ++x;
        }
        return sc.accept((short)pendingStart, (short)pendingEnd);
    }

    @Override
    public BitmapContainer toBitmapContainer() {
        return this;
    }

    @Override
    public int nextValue(short fromValue) {
        return this.nextSetBit(ContainerUtil.toIntUnsigned(fromValue));
    }

    private void assertNonEmpty() {
        if (this.cardinality == 0) {
            throw new NoSuchElementException("Empty " + this.getContainerName());
        }
    }

    @Override
    public int first() {
        this.assertNonEmpty();
        return this.first(0, null);
    }

    private int first(int startPos, MutableInteger positionOutput) {
        int i;
        for (i = startPos; i < this.bitmap.length - 1 && this.bitmap[i] == 0L; ++i) {
        }
        if (positionOutput != null) {
            positionOutput.value = i;
        }
        return i * 64 + Long.numberOfTrailingZeros(this.bitmap[i]);
    }

    private void searchForwardForNonzeroWord(int startPos, WordMatcher m) {
        for (int i = startPos; i < this.bitmap.length; ++i) {
            long word = this.bitmap[i];
            if (word == 0L || !m.accept(i, this.bitmap[i])) continue;
            return;
        }
    }

    @Override
    public int last() {
        this.assertNonEmpty();
        return this.last(this.bitmap.length - 1, null);
    }

    private int last(int startPos, MutableInteger positionOutput) {
        int i;
        for (i = startPos; i > 0 && this.bitmap[i] == 0L; --i) {
        }
        if (positionOutput != null) {
            positionOutput.value = i;
        }
        return (i + 1) * 64 - Long.numberOfLeadingZeros(this.bitmap[i]) - 1;
    }

    @Override
    public boolean subsetOf(ArrayContainer c) {
        if (this.isEmpty()) {
            return true;
        }
        if (c.isEmpty()) {
            return false;
        }
        if (this.getCardinality() > c.getCardinality()) {
            return false;
        }
        int count = 0;
        for (int i = 0; i < c.getCardinality(); ++i) {
            short k = c.content[i];
            if (!this.contains(k) || ++count != this.getCardinality()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean subsetOf(BitmapContainer c) {
        if (this.isEmpty()) {
            return true;
        }
        if (c.isEmpty()) {
            return false;
        }
        if (this.getCardinality() > c.getCardinality()) {
            return false;
        }
        for (int i = 0; i < this.bitmap.length; ++i) {
            long w1 = this.bitmap[i];
            long w2 = c.bitmap[i];
            if ((w1 | w2) == w2) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean subsetOf(RunContainer c) {
        if (this.isEmpty()) {
            return true;
        }
        if (c.isEmpty()) {
            return false;
        }
        int count = 0;
        for (int i = 0; i < c.nbrruns; ++i) {
            int ival = ContainerUtil.toIntUnsigned(c.getValue(i));
            int ilen = ContainerUtil.toIntUnsigned(c.getLength(i));
            for (int j = ival; j <= ival + ilen; ++j) {
                if (!this.contains(ContainerUtil.lowbits(j)) || ++count != this.getCardinality()) continue;
                return true;
            }
        }
        return false;
    }

    final long endMask(int endBit) {
        if (endBit == 63) {
            return -1L;
        }
        return (1L << endBit + 1) - 1L;
    }

    @Override
    public boolean overlapsRange(int rangeStart, int rangeEnd) {
        int ifirst = rangeStart >>> 6;
        int last = rangeEnd - 1;
        int ilast = last >>> 6;
        int startBit = rangeStart & 0x3F;
        int endBit = last & 0x3F;
        long startMask = (1L << startBit) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        if (ifirst == ilast) {
            long endMask = this.endMask(endBit);
            long v = this.bitmap[ifirst] & startMask & endMask;
            return v != 0L;
        }
        long v = this.bitmap[ifirst] & startMask;
        if (v != 0L) {
            return true;
        }
        for (int j = ifirst + 1; j < ilast; ++j) {
            v = this.bitmap[j];
            if (v == 0L) continue;
            return true;
        }
        long endMask = this.endMask(endBit);
        v = this.bitmap[ilast] & endMask;
        return v != 0L;
    }

    @Override
    public boolean overlaps(ArrayContainer c) {
        for (int i = 0; i < c.getCardinality(); ++i) {
            short k = c.content[i];
            if (!this.contains(k)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean overlaps(BitmapContainer c) {
        for (int i = 0; i < this.bitmap.length; ++i) {
            long w1 = this.bitmap[i];
            long w2 = c.bitmap[i];
            if ((w1 & w2) == 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean overlaps(RunContainer c) {
        for (int i = 0; i < c.nbrruns; ++i) {
            int ival = ContainerUtil.toIntUnsigned(c.getValue(i));
            int ilen = ContainerUtil.toIntUnsigned(c.getLength(i));
            for (int j = ival; j <= ival + ilen; ++j) {
                if (!this.contains(ContainerUtil.lowbits(j))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void setCopyOnWrite() {
        this.shared = true;
    }

    private BitmapContainer deepCopyIfShared() {
        return this.shared ? this.deepCopy() : this;
    }

    @Override
    public int bytesAllocated() {
        return 8192;
    }

    @Override
    public int bytesUsed() {
        return this.bytesAllocated();
    }

    @Override
    public Container toLargeContainer() {
        return this;
    }

    @Override
    public void validate() {
        int computedCard = BitmapContainer.computeCardinality(this);
        if (computedCard != this.cardinality) {
            throw new IllegalStateException("computedCard=" + computedCard + ", cardinality=" + this.cardinality);
        }
    }

    @Override
    public boolean isShared() {
        return this.shared;
    }

    @FunctionalInterface
    private static interface WordMatcher {
        public boolean accept(int var1, long var2);
    }

    private class SeekToRankContext {
        public final int cardinalityBeforeIndex;
        public final int index;
        public final long wordAtIndexAfterDiscards;

        public SeekToRankContext(int startRank) {
            int cardBefore = 0;
            int i = 0;
            long word = 0L;
            while (i < BitmapContainer.this.bitmap.length) {
                word = BitmapContainer.this.bitmap[i];
                if (word == 0L) {
                    ++i;
                    continue;
                }
                int bitCount = Long.bitCount(word);
                int posCard = cardBefore + bitCount;
                if (posCard >= startRank) break;
                cardBefore = posCard;
                ++i;
            }
            this.cardinalityBeforeIndex = cardBefore;
            this.index = i;
            int discard = startRank - cardBefore;
            for (int j = 0; j < discard; ++j) {
                word &= word - 1L;
            }
            this.wordAtIndexAfterDiscards = word;
        }
    }

    static class ValuesInRangeIter
    implements ShortIterator {
        private final long[] bitmap;
        private int x;
        private final int xlast;
        private final long lastMask;
        private long w;

        private void eatZeroesForward() {
            while (this.w == 0L && this.x < this.xlast) {
                this.w = this.bitmap[++this.x];
            }
            if (this.x == this.xlast) {
                this.w &= this.lastMask;
            }
            if (this.w == 0L) {
                ++this.x;
            }
        }

        public ValuesInRangeIter(long[] bitmap, ValuesInRangeContext ctx) {
            this.bitmap = bitmap;
            this.lastMask = ctx.maskLast;
            this.xlast = ctx.iLast;
            this.x = ctx.iFirst;
            this.w = bitmap[this.x] & ctx.maskFirst;
            if (this.x == this.xlast) {
                this.w &= this.lastMask;
                if (this.w == 0L) {
                    ++this.x;
                }
                return;
            }
            this.eatZeroesForward();
        }

        public ValuesInRangeIter(long[] bitmap, int rangeStart, int rangeEnd) {
            this(bitmap, new ValuesInRangeContext(rangeStart, rangeEnd));
        }

        @Override
        public boolean hasNext() {
            return this.x <= this.xlast;
        }

        @Override
        public short next() {
            short answer = (short)(this.x * 64 + Long.numberOfTrailingZeros(this.w));
            this.w &= this.w - 1L;
            this.eatZeroesForward();
            return answer;
        }

        @Override
        public int nextAsInt() {
            return ContainerUtil.toIntUnsigned(this.next());
        }
    }

    static class ValuesInRangeContext {
        public final int iFirst;
        public final int iLast;
        public final long maskFirst;
        public final long maskLast;

        public ValuesInRangeContext(int rangeStart, int rangeEnd) {
            this.iFirst = rangeStart >>> 6;
            int max = rangeEnd - 1;
            this.iLast = max >>> 6;
            this.maskFirst = (1L << rangeStart) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
            long lastShift = (1L << rangeEnd) - 1L;
            this.maskLast = lastShift == 0L ? -1L : lastShift;
        }

        public int cardinalityInRange(long[] bitmap) {
            long w = bitmap[this.iFirst] & this.maskFirst;
            if (this.iFirst == this.iLast) {
                return Long.bitCount(w &= this.maskLast);
            }
            int card = Long.bitCount(w);
            for (int i = this.iFirst + 1; i < this.iLast; ++i) {
                card += Long.bitCount(bitmap[i]);
            }
            return card += Long.bitCount(bitmap[this.iLast] & this.maskLast);
        }
    }

    static class ForwardShortIterator
    implements ShortIterator {
        protected final long[] bitmap;
        protected long w;
        protected int x;

        ForwardShortIterator(long[] p) {
            this.bitmap = p;
            this.x = 0;
            while (this.x < this.bitmap.length && (this.w = this.bitmap[this.x]) == 0L) {
                ++this.x;
            }
        }

        @Override
        public boolean hasNext() {
            return this.x < this.bitmap.length;
        }

        @Override
        public short next() {
            short answer = (short)(this.x * 64 + Long.numberOfTrailingZeros(this.w));
            this.w &= this.w - 1L;
            while (this.w == 0L) {
                ++this.x;
                if (this.x == this.bitmap.length) break;
                this.w = this.bitmap[this.x];
            }
            return answer;
        }

        @Override
        public int nextAsInt() {
            return ContainerUtil.toIntUnsigned(this.next());
        }
    }

    static final class ReverseShortIterator
    implements ShortAdvanceIterator {
        private int curr;
        private long nextWord;
        private int nextPos;
        private long[] bitmap;

        ReverseShortIterator(long[] bitmap) {
            this.wrap(bitmap);
        }

        @Override
        public boolean hasNext() {
            return this.nextPos >= 0;
        }

        private void eatZeroes() {
            while (this.nextWord == 0L) {
                --this.nextPos;
                if (this.nextPos < 0) break;
                this.nextWord = this.bitmap[this.nextPos];
            }
        }

        @Override
        public short next() {
            int shift = Long.numberOfLeadingZeros(this.nextWord) + 1;
            this.curr = (this.nextPos + 1) * 64 - shift;
            this.nextWord &= 1L << 64 - shift ^ 0xFFFFFFFFFFFFFFFFL;
            this.eatZeroes();
            return (short)this.curr;
        }

        @Override
        public int currAsInt() {
            return this.curr;
        }

        @Override
        public short curr() {
            return (short)this.curr;
        }

        @Override
        public int nextAsInt() {
            return ContainerUtil.toIntUnsigned(this.next());
        }

        @Override
        public boolean advance(int v) {
            if (this.curr == -1) {
                if (!this.hasNext()) {
                    return false;
                }
                this.next();
            }
            if (v >= this.curr) {
                return true;
            }
            this.nextPos = v >> 6;
            long mod64 = v & 0x3F;
            long mask = mod64 != 63L ? (1L << (int)(mod64 + 1L)) - 1L : -1L;
            this.nextWord = this.bitmap[this.nextPos] & mask;
            int savedPos = this.nextPos;
            this.eatZeroes();
            if (this.nextPos < 0) {
                while (this.bitmap[savedPos] == 0L) {
                    ++savedPos;
                }
                this.curr = (savedPos + 1) * 64 - Long.numberOfLeadingZeros(this.bitmap[savedPos]) - 1;
                return false;
            }
            this.next();
            return true;
        }

        void wrap(long[] b) {
            this.curr = -1;
            this.bitmap = b;
            this.nextPos = this.bitmap.length - 1;
            while (this.nextPos >= 0 && (this.nextWord = this.bitmap[this.nextPos]) == 0L) {
                --this.nextPos;
            }
        }
    }
}

