/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl.rsp.container;

import io.deephaven.engine.rowset.impl.rsp.container.ArrayContainer;
import io.deephaven.engine.rowset.impl.rsp.container.BitmapContainer;
import io.deephaven.engine.rowset.impl.rsp.container.ContainerShortBatchIterator;
import io.deephaven.engine.rowset.impl.rsp.container.ContainerUtil;
import io.deephaven.engine.rowset.impl.rsp.container.EmptyContainer;
import io.deephaven.engine.rowset.impl.rsp.container.ImmutableContainer;
import io.deephaven.engine.rowset.impl.rsp.container.PositionHint;
import io.deephaven.engine.rowset.impl.rsp.container.RangeConsumer;
import io.deephaven.engine.rowset.impl.rsp.container.RangeIterator;
import io.deephaven.engine.rowset.impl.rsp.container.RunContainer;
import io.deephaven.engine.rowset.impl.rsp.container.SearchRangeIterator;
import io.deephaven.engine.rowset.impl.rsp.container.ShortAdvanceIterator;
import io.deephaven.engine.rowset.impl.rsp.container.ShortConsumer;
import io.deephaven.engine.rowset.impl.rsp.container.ShortIterator;
import io.deephaven.engine.rowset.impl.rsp.container.ShortRangeConsumer;
import io.deephaven.engine.rowset.impl.rsp.container.SingleRangeContainer;
import io.deephaven.engine.rowset.impl.rsp.container.SingletonContainer;
import io.deephaven.engine.rowset.impl.rsp.container.TwoValuesContainer;

public abstract class Container {
    public static final boolean DEBUG = Boolean.getBoolean("io.deephaven.engine.rowset.impl.rsp.container.Container.DEBUG");
    public static final int MAX_RANGE = 65536;
    public static final int MAX_VALUE = 65535;
    protected static final ThreadLocal<short[]> threadLocalBuf = ThreadLocal.withInitial(() -> new short[244]);
    public static final String[] ContainerNames = new String[]{"empty", "singleton", "singlerange", "twovalues", "array", "bitmap", "run"};

    static int shortArraySizeRounding(int sizeToRound) {
        int sz = 12 + 2 * sizeToRound;
        int szMod8 = sz & 7;
        int padding = szMod8 > 0 ? 8 - szMod8 : 0;
        return sizeToRound + padding / 2;
    }

    static int runsShortArraySizeRounding(int nruns) {
        return 2 * Container.runsSizeRounding(nruns);
    }

    static int runsSizeRounding(int nruns) {
        int sz = 12 + 4 * nruns;
        int szMod8 = sz & 7;
        int padding = szMod8 > 0 ? 8 - szMod8 : 0;
        return nruns + padding / 4;
    }

    public final void ifDebugValidate() {
        if (DEBUG) {
            this.validate();
        }
    }

    public Container check() {
        this.validate();
        return this;
    }

    public abstract void validate();

    private static boolean smallContainersDisabled() {
        return !ImmutableContainer.ENABLED;
    }

    public static Container singleton(short v) {
        if (Container.smallContainersDisabled()) {
            short[] vs = new short[Container.shortArraySizeRounding(1)];
            vs[0] = v;
            return new ArrayContainer(vs, 1);
        }
        return new SingletonContainer(v);
    }

    public static Container singleRange(int start, int end) {
        if (DEBUG && (end <= start || start < 0 || end > 65536)) {
            throw new IllegalArgumentException("start=" + start + ", end=" + end);
        }
        return Container.rangeOfOnes(start, end);
    }

    public static Container full() {
        if (Container.smallContainersDisabled()) {
            return new RunContainer(0, 65536);
        }
        return new SingleRangeContainer(0, 65536);
    }

    public static Container rangeOfOnes(int start, int end) {
        if (DEBUG && (start < 0 || end > 65536)) {
            throw new IllegalArgumentException("start=" + start + ", end=" + end);
        }
        if (end <= start) {
            return Container.empty();
        }
        if (end - start == 1) {
            return Container.singleton(ContainerUtil.lowbits(start));
        }
        if (Container.smallContainersDisabled()) {
            return new RunContainer(start, end);
        }
        return new SingleRangeContainer(start, end);
    }

    public static Container twoValues(short v1, short v2) {
        int iv1 = ContainerUtil.toIntUnsigned(v1);
        int iv2 = ContainerUtil.toIntUnsigned(v2);
        if (DEBUG && iv2 <= iv1) {
            throw new IllegalStateException("iv1=" + iv1 + " && iv2=" + iv2);
        }
        if (Container.smallContainersDisabled()) {
            short[] vs = new short[Container.shortArraySizeRounding(2)];
            vs[0] = v1;
            vs[1] = v2;
            return new ArrayContainer(vs, 2);
        }
        if (iv2 - 1 == iv1) {
            return Container.singleRange(iv1, iv2 + 1);
        }
        return new TwoValuesContainer(v1, v2);
    }

    public static Container twoRanges(int start1, int end1, int start2, int end2) {
        if (DEBUG && (end1 <= start1 || end2 <= start2 || start1 < 0 || start2 < 0 || end1 > 65536 || end2 > 65536 || start2 <= end1)) {
            throw new IllegalArgumentException("start1=" + start1 + ", end1=" + end1 + ", start2=" + start2 + ", end2=" + end2);
        }
        if (Container.smallContainersDisabled()) {
            return new RunContainer(start1, end1, start2, end2);
        }
        if (end1 - start1 == 1 && end2 - start2 == 1) {
            return new TwoValuesContainer(ContainerUtil.lowbits(start1), ContainerUtil.lowbits(start2));
        }
        return new RunContainer(start1, end1, start2, end2);
    }

    static Container makeSingletonContainer(short v) {
        if (Container.smallContainersDisabled()) {
            return new ArrayContainer(v);
        }
        return new SingletonContainer(v);
    }

    static Container makeTwoValuesContainer(short v1, short v2) {
        if (Container.smallContainersDisabled()) {
            return new ArrayContainer(v1, v2);
        }
        return new TwoValuesContainer(v1, v2);
    }

    static Container makeSingleRangeContainer(int start, int end) {
        if (Container.smallContainersDisabled()) {
            return new RunContainer(start, end);
        }
        return new SingleRangeContainer(start, end);
    }

    public static Container empty() {
        if (Container.smallContainersDisabled()) {
            return new ArrayContainer();
        }
        return EmptyContainer.instance;
    }

    public abstract Container add(int var1, int var2);

    public abstract Container iset(short var1);

    public abstract Container set(short var1);

    private String myType() {
        return this.getClass().getSimpleName();
    }

    public abstract Container and(ArrayContainer var1);

    public abstract Container and(BitmapContainer var1);

    public abstract Container and(RunContainer var1);

    private Container and(SingletonContainer sc) {
        return this.contains(sc.value) ? sc : Container.empty();
    }

    private Container and(SingleRangeContainer sr) {
        return this.andRange(sr.first(), sr.last() + 1);
    }

    private Container and(TwoValuesContainer tv) {
        boolean has1 = this.contains(tv.v1);
        boolean has2 = this.contains(tv.v2);
        if (has1) {
            if (has2) {
                return tv.cowRef();
            }
            return Container.singleton(tv.v1);
        }
        if (has2) {
            return Container.singleton(tv.v2);
        }
        return Container.empty();
    }

    public Container and(Container x) {
        if (this.isEmpty() || x.isEmpty()) {
            return Container.empty();
        }
        if (x instanceof SingletonContainer) {
            return this.and((SingletonContainer)x);
        }
        if (x instanceof SingleRangeContainer) {
            return this.and((SingleRangeContainer)x);
        }
        if (x instanceof TwoValuesContainer) {
            return this.and((TwoValuesContainer)x);
        }
        if (x instanceof ArrayContainer) {
            return this.and((ArrayContainer)x);
        }
        if (x instanceof BitmapContainer) {
            return this.and((BitmapContainer)x);
        }
        if (x instanceof RunContainer) {
            return this.and((RunContainer)x);
        }
        throw new IllegalStateException(x.myType());
    }

    public abstract Container andRange(int var1, int var2);

    public abstract Container iandRange(int var1, int var2);

    public abstract Container andNot(ArrayContainer var1);

    public abstract Container andNot(BitmapContainer var1);

    public abstract Container andNot(RunContainer var1);

    private Container andNot(SingletonContainer sc) {
        return this.unset(sc.value);
    }

    private Container andNot(SingleRangeContainer sr) {
        return this.remove(sr.first(), sr.last() + 1);
    }

    private Container andNot(TwoValuesContainer tv) {
        PositionHint hint = new PositionHint();
        return this.unset(tv.v1, hint).iunset(tv.v2, hint);
    }

    public Container andNot(Container x) {
        if (this.isEmpty()) {
            return Container.empty();
        }
        if (x.isEmpty()) {
            return this.cowRef();
        }
        if (x instanceof SingletonContainer) {
            return this.andNot((SingletonContainer)x);
        }
        if (x instanceof SingleRangeContainer) {
            return this.andNot((SingleRangeContainer)x);
        }
        if (x instanceof TwoValuesContainer) {
            return this.andNot((TwoValuesContainer)x);
        }
        if (x instanceof ArrayContainer) {
            return this.andNot((ArrayContainer)x);
        }
        if (x instanceof BitmapContainer) {
            return this.andNot((BitmapContainer)x);
        }
        if (x instanceof RunContainer) {
            return this.andNot((RunContainer)x);
        }
        throw new IllegalStateException(x.myType());
    }

    public abstract Container deepCopy();

    public abstract Container cowRef();

    public abstract boolean isEmpty();

    public abstract boolean isAllOnes();

    public boolean isSingleElement() {
        return this.getCardinality() == 1;
    }

    @Deprecated
    public final boolean isFull() {
        return this.isAllOnes();
    }

    public abstract boolean contains(short var1);

    public abstract boolean contains(int var1, int var2);

    protected abstract boolean contains(ArrayContainer var1);

    protected abstract boolean contains(BitmapContainer var1);

    protected abstract boolean contains(RunContainer var1);

    public boolean contains(Container subset) {
        if (subset.isEmpty()) {
            return true;
        }
        if (this.isEmpty()) {
            return false;
        }
        if (subset instanceof SingletonContainer) {
            SingletonContainer sc = (SingletonContainer)subset;
            return this.contains(sc.value);
        }
        if (subset instanceof SingleRangeContainer) {
            SingleRangeContainer sr = (SingleRangeContainer)subset;
            return this.contains(sr.first(), sr.last() + 1);
        }
        if (subset instanceof TwoValuesContainer) {
            TwoValuesContainer tv = (TwoValuesContainer)subset;
            return this.contains(tv.v1) && this.contains(tv.v2);
        }
        if (subset instanceof ArrayContainer) {
            return this.contains((ArrayContainer)subset);
        }
        if (subset instanceof BitmapContainer) {
            return this.contains((BitmapContainer)subset);
        }
        if (subset instanceof RunContainer) {
            return this.contains((RunContainer)subset);
        }
        throw new IllegalStateException(subset.myType());
    }

    public abstract Container iflip(short var1);

    public abstract int getCardinality();

    public String getContainerName() {
        if (this instanceof EmptyContainer) {
            return ContainerNames[0];
        }
        if (this instanceof SingletonContainer) {
            return ContainerNames[1];
        }
        if (this instanceof SingleRangeContainer) {
            return ContainerNames[2];
        }
        if (this instanceof TwoValuesContainer) {
            return ContainerNames[3];
        }
        if (this instanceof ArrayContainer) {
            return ContainerNames[4];
        }
        if (this instanceof BitmapContainer) {
            return ContainerNames[5];
        }
        if (this instanceof RunContainer) {
            return ContainerNames[6];
        }
        throw new IllegalStateException(this.myType());
    }

    public abstract boolean forEach(ShortConsumer var1);

    public abstract boolean forEach(int var1, ShortConsumer var2);

    public abstract boolean forEachRange(int var1, ShortRangeConsumer var2);

    public abstract ShortAdvanceIterator getReverseShortIterator();

    public abstract ShortIterator getShortIterator();

    public abstract ContainerShortBatchIterator getShortBatchIterator(int var1);

    public abstract SearchRangeIterator getShortRangeIterator(int var1);

    public abstract Container iadd(int var1, int var2);

    public abstract Container iappend(int var1, int var2);

    public abstract Container iand(ArrayContainer var1);

    public abstract Container iand(BitmapContainer var1);

    public abstract Container iand(RunContainer var1);

    private Container iand(SingleRangeContainer sr) {
        return this.iandRange(sr.first(), sr.last() + 1);
    }

    public Container iand(Container x) {
        if (this.isEmpty() || x.isEmpty()) {
            return Container.empty();
        }
        if (x instanceof SingletonContainer) {
            return this.and((SingletonContainer)x);
        }
        if (x instanceof SingleRangeContainer) {
            return this.iand((SingleRangeContainer)x);
        }
        if (x instanceof TwoValuesContainer) {
            return this.and((TwoValuesContainer)x);
        }
        if (x instanceof ArrayContainer) {
            return this.iand((ArrayContainer)x);
        }
        if (x instanceof BitmapContainer) {
            return this.iand((BitmapContainer)x);
        }
        if (x instanceof RunContainer) {
            return this.iand((RunContainer)x);
        }
        throw new IllegalStateException(x.myType());
    }

    public abstract Container iandNot(ArrayContainer var1);

    public abstract Container iandNot(BitmapContainer var1);

    public abstract Container iandNot(RunContainer var1);

    private Container iandNot(SingletonContainer sc) {
        return this.iunset(sc.value);
    }

    private Container iandNot(SingleRangeContainer sr) {
        return this.iremove(sr.first(), sr.last() + 1);
    }

    private Container iandNot(TwoValuesContainer tv) {
        PositionHint hint = new PositionHint();
        return this.iunset(tv.v1, hint).iunset(tv.v2, hint);
    }

    public Container iandNot(Container x) {
        if (this.isEmpty()) {
            return Container.empty();
        }
        if (x.isEmpty()) {
            return this;
        }
        if (x instanceof SingletonContainer) {
            return this.iandNot((SingletonContainer)x);
        }
        if (x instanceof SingleRangeContainer) {
            return this.iandNot((SingleRangeContainer)x);
        }
        if (x instanceof TwoValuesContainer) {
            return this.iandNot((TwoValuesContainer)x);
        }
        if (x instanceof ArrayContainer) {
            return this.iandNot((ArrayContainer)x);
        }
        if (x instanceof BitmapContainer) {
            return this.iandNot((BitmapContainer)x);
        }
        if (x instanceof RunContainer) {
            return this.iandNot((RunContainer)x);
        }
        throw new IllegalStateException(x.myType());
    }

    public abstract Container inot(int var1, int var2);

    public abstract Container ior(ArrayContainer var1);

    public abstract Container ior(BitmapContainer var1);

    public abstract Container ior(RunContainer var1);

    private Container ior(SingletonContainer sc) {
        return this.iset(sc.value);
    }

    private Container ior(SingleRangeContainer sr) {
        return this.iadd(sr.first(), sr.last() + 1);
    }

    private Container ior(TwoValuesContainer tv) {
        PositionHint hint = new PositionHint();
        Container ans = this.iset(tv.v1, hint);
        return ans.iset(tv.v2, hint);
    }

    public Container ior(Container x) {
        if (this.isEmpty()) {
            if (x.isEmpty()) {
                return Container.empty();
            }
            return x.cowRef();
        }
        if (x.isEmpty()) {
            return this;
        }
        if (x instanceof SingletonContainer) {
            return this.ior((SingletonContainer)x);
        }
        if (x instanceof SingleRangeContainer) {
            return this.ior((SingleRangeContainer)x);
        }
        if (x instanceof TwoValuesContainer) {
            return this.ior((TwoValuesContainer)x);
        }
        if (x instanceof ArrayContainer) {
            return this.ior((ArrayContainer)x);
        }
        if (x instanceof BitmapContainer) {
            return this.ior((BitmapContainer)x);
        }
        if (x instanceof RunContainer) {
            return this.ior((RunContainer)x);
        }
        throw new IllegalStateException(x.myType());
    }

    public abstract Container iremove(int var1, int var2);

    public abstract Container ixor(ArrayContainer var1);

    public abstract Container ixor(BitmapContainer var1);

    public abstract Container ixor(RunContainer var1);

    private Container ixor(SingletonContainer sc) {
        return this.iflip(sc.value);
    }

    private Container ixor(SingleRangeContainer sr) {
        return this.inot(sr.first(), sr.last() + 1);
    }

    private Container ixor(TwoValuesContainer tv) {
        return this.iflip(tv.v1).iflip(tv.v2);
    }

    public Container ixor(Container x) {
        if (this.isEmpty()) {
            return x.cowRef();
        }
        if (x.isEmpty()) {
            return this;
        }
        if (x instanceof SingletonContainer) {
            return this.ixor((SingletonContainer)x);
        }
        if (x instanceof SingleRangeContainer) {
            return this.ixor((SingleRangeContainer)x);
        }
        if (x instanceof TwoValuesContainer) {
            return this.ixor((TwoValuesContainer)x);
        }
        if (x instanceof ArrayContainer) {
            return this.ixor((ArrayContainer)x);
        }
        if (x instanceof BitmapContainer) {
            return this.ixor((BitmapContainer)x);
        }
        if (x instanceof RunContainer) {
            return this.ixor((RunContainer)x);
        }
        throw new IllegalStateException(x.myType());
    }

    public abstract Container not(int var1, int var2);

    abstract int numberOfRuns();

    public int numberOfRanges() {
        return this.numberOfRuns();
    }

    public abstract Container or(ArrayContainer var1);

    public abstract Container or(BitmapContainer var1);

    public abstract Container or(RunContainer var1);

    private Container or(SingletonContainer sc) {
        return this.set(sc.value);
    }

    private Container or(SingleRangeContainer sr) {
        return this.add(sr.first(), sr.last() + 1);
    }

    private Container or(TwoValuesContainer tv) {
        PositionHint hint = new PositionHint();
        Container ans = this.set(tv.v1, hint);
        return ans.iset(tv.v2, hint);
    }

    public Container or(Container x) {
        if (this.isEmpty()) {
            if (x.isEmpty()) {
                return Container.empty();
            }
            return x.deepCopy();
        }
        if (x.isEmpty()) {
            return this.deepCopy();
        }
        if (x instanceof SingletonContainer) {
            return this.or((SingletonContainer)x);
        }
        if (x instanceof SingleRangeContainer) {
            return this.or((SingleRangeContainer)x);
        }
        if (x instanceof TwoValuesContainer) {
            return this.or((TwoValuesContainer)x);
        }
        if (x instanceof ArrayContainer) {
            return this.or((ArrayContainer)x);
        }
        if (x instanceof BitmapContainer) {
            return this.or((BitmapContainer)x);
        }
        if (x instanceof RunContainer) {
            return this.or((RunContainer)x);
        }
        throw new IllegalStateException(x.myType());
    }

    public abstract int rank(short var1);

    public abstract Container remove(int var1, int var2);

    @Deprecated
    public final Container remove(short x) {
        return this.iunset(x);
    }

    public abstract Container unset(short var1);

    public abstract Container iunset(short var1);

    public abstract Container runOptimize();

    public abstract short select(int var1);

    public abstract Container select(int var1, int var2);

    public abstract int find(short var1);

    public abstract void selectRanges(RangeConsumer var1, RangeIterator var2);

    public abstract boolean findRanges(RangeConsumer var1, RangeIterator var2, int var3);

    public abstract void trim();

    public abstract Container xor(ArrayContainer var1);

    public abstract Container xor(BitmapContainer var1);

    public abstract Container xor(RunContainer var1);

    private Container xor(SingletonContainer sc) {
        return this.cowRef().iflip(sc.value);
    }

    private Container xor(SingleRangeContainer sr) {
        return this.not(sr.first(), sr.last() + 1);
    }

    private Container xor(TwoValuesContainer tv) {
        return this.cowRef().iflip(tv.v1).iflip(tv.v2);
    }

    public Container xor(Container x) {
        if (this.isEmpty()) {
            if (x.isEmpty()) {
                return Container.empty();
            }
            return x.cowRef();
        }
        if (x.isEmpty()) {
            return this.cowRef();
        }
        if (x instanceof SingletonContainer) {
            return this.xor((SingletonContainer)x);
        }
        if (x instanceof SingleRangeContainer) {
            return this.xor((SingleRangeContainer)x);
        }
        if (x instanceof TwoValuesContainer) {
            return this.xor((TwoValuesContainer)x);
        }
        if (x instanceof ArrayContainer) {
            return this.xor((ArrayContainer)x);
        }
        if (x instanceof BitmapContainer) {
            return this.xor((BitmapContainer)x);
        }
        if (x instanceof RunContainer) {
            return this.xor((RunContainer)x);
        }
        throw new IllegalStateException(x.myType());
    }

    public abstract BitmapContainer toBitmapContainer();

    abstract Container toLargeContainer();

    public abstract int nextValue(short var1);

    public abstract int first();

    public abstract int last();

    public abstract boolean subsetOf(ArrayContainer var1);

    public abstract boolean subsetOf(BitmapContainer var1);

    public abstract boolean subsetOf(RunContainer var1);

    private boolean subsetOf(SingletonContainer sc) {
        return this.getCardinality() == 1 && this.first() == sc.intValue();
    }

    private boolean subsetOf(SingleRangeContainer sr) {
        return sr.first() <= this.first() && this.last() <= sr.last();
    }

    private boolean subsetOf(TwoValuesContainer tv) {
        int card = this.getCardinality();
        if (card > 2) {
            return false;
        }
        if (card == 2) {
            return this.first() == tv.first() && this.last() == tv.last();
        }
        int v = this.first();
        return v == tv.v1AsInt() || v == tv.v2AsInt();
    }

    public boolean subsetOf(Container x) {
        if (this.isEmpty()) {
            return true;
        }
        if (x.isEmpty()) {
            return false;
        }
        if (x instanceof SingletonContainer) {
            return this.subsetOf((SingletonContainer)x);
        }
        if (x instanceof SingleRangeContainer) {
            return this.subsetOf((SingleRangeContainer)x);
        }
        if (x instanceof TwoValuesContainer) {
            return this.subsetOf((TwoValuesContainer)x);
        }
        if (x instanceof ArrayContainer) {
            return this.subsetOf((ArrayContainer)x);
        }
        if (x instanceof BitmapContainer) {
            return this.subsetOf((BitmapContainer)x);
        }
        if (x instanceof RunContainer) {
            return this.subsetOf((RunContainer)x);
        }
        throw new IllegalStateException(x.myType());
    }

    public final boolean intersects(Container x) {
        return this.overlaps(x);
    }

    public final boolean intersects(int start, int end) {
        return this.overlapsRange(start, end);
    }

    public abstract boolean overlaps(ArrayContainer var1);

    public abstract boolean overlaps(BitmapContainer var1);

    public abstract boolean overlaps(RunContainer var1);

    public abstract boolean overlapsRange(int var1, int var2);

    private boolean overlaps(SingletonContainer sc) {
        return this.contains(sc.value);
    }

    private boolean overlaps(SingleRangeContainer sr) {
        return this.overlapsRange(sr.first(), sr.last() + 1);
    }

    private boolean overlaps(TwoValuesContainer tv) {
        return this.contains(tv.v1) || this.contains(tv.v2);
    }

    public boolean overlaps(Container x) {
        if (this.isEmpty() || x.isEmpty()) {
            return false;
        }
        if (x instanceof SingletonContainer) {
            return this.overlaps((SingletonContainer)x);
        }
        if (x instanceof SingleRangeContainer) {
            return this.overlaps((SingleRangeContainer)x);
        }
        if (x instanceof TwoValuesContainer) {
            return this.overlaps((TwoValuesContainer)x);
        }
        if (x instanceof ArrayContainer) {
            return this.overlaps((ArrayContainer)x);
        }
        if (x instanceof BitmapContainer) {
            return this.overlaps((BitmapContainer)x);
        }
        if (x instanceof RunContainer) {
            return this.overlaps((RunContainer)x);
        }
        throw new IllegalStateException(x.myType());
    }

    public abstract void setCopyOnWrite();

    public abstract int bytesAllocated();

    public abstract int bytesUsed();

    abstract Container iset(short var1, PositionHint var2);

    abstract Container set(short var1, PositionHint var2);

    abstract Container iunset(short var1, PositionHint var2);

    abstract Container unset(short var1, PositionHint var2);

    public String toString() {
        int range;
        StringBuilder sb = new StringBuilder();
        SearchRangeIterator rit = this.getShortRangeIterator(0);
        int maxRanges = 99;
        sb.append("{ ");
        for (range = 0; rit.hasNext() && range < 99; ++range) {
            rit.next();
            int first = rit.start();
            int last = rit.end() - 1;
            if (range > 0) {
                sb.append(",");
            }
            sb.append(first);
            if (last == first) continue;
            sb.append("-").append(last);
        }
        if (rit.hasNext()) {
            int prevStart = -1;
            int prevLast = -1;
            int prevRange = range;
            while (rit.hasNext()) {
                rit.next();
                prevStart = rit.start();
                prevLast = rit.end() - 1;
                ++prevRange;
            }
            if (prevRange > range + 1) {
                sb.append(", ... ");
            }
            sb.append(",");
            sb.append(prevStart);
            if (prevLast != prevStart) {
                sb.append("-").append(prevLast);
            }
        }
        sb.append(" }");
        return sb.toString();
    }

    public abstract boolean isShared();

    final boolean sameContents(Container other) {
        if (other.getCardinality() != this.getCardinality()) {
            return false;
        }
        return this.subsetOf(other);
    }
}

