/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl.rsp.container;

import io.deephaven.engine.rowset.impl.rsp.container.ArrayContainer;
import io.deephaven.engine.rowset.impl.rsp.container.BitmapContainer;
import io.deephaven.engine.rowset.impl.rsp.container.Container;
import io.deephaven.engine.rowset.impl.rsp.container.ContainerShortBatchIterator;
import io.deephaven.engine.rowset.impl.rsp.container.ContainerUtil;
import io.deephaven.engine.rowset.impl.rsp.container.ImmutableContainer;
import io.deephaven.engine.rowset.impl.rsp.container.PositionHint;
import io.deephaven.engine.rowset.impl.rsp.container.RangeConsumer;
import io.deephaven.engine.rowset.impl.rsp.container.RangeIterator;
import io.deephaven.engine.rowset.impl.rsp.container.RunContainer;
import io.deephaven.engine.rowset.impl.rsp.container.SearchRangeIterator;
import io.deephaven.engine.rowset.impl.rsp.container.ShortAdvanceIterator;
import io.deephaven.engine.rowset.impl.rsp.container.ShortConsumer;
import io.deephaven.engine.rowset.impl.rsp.container.ShortIterator;
import io.deephaven.engine.rowset.impl.rsp.container.ShortRangeConsumer;
import io.deephaven.engine.rowset.impl.rsp.container.SingletonContainer;

public final class EmptyContainer
extends ImmutableContainer {
    protected static final EmptyContainer instance = new EmptyContainer();
    private static final Iter iter = new Iter();
    private static final SearchRangeIter searchRangeIter = new SearchRangeIter();

    private EmptyContainer() {
    }

    @Override
    public Container add(int begin, int end) {
        int card = end - begin;
        if (card <= 0) {
            return this;
        }
        if (card == 1) {
            return Container.singleton(ContainerUtil.lowbits(begin));
        }
        return Container.singleRange(begin, end);
    }

    @Override
    public Container set(short x) {
        return Container.singleton(x);
    }

    @Override
    Container set(short x, PositionHint positionHint) {
        positionHint.reset();
        return this.set(x);
    }

    @Override
    public EmptyContainer and(ArrayContainer x) {
        return this;
    }

    @Override
    public EmptyContainer and(BitmapContainer x) {
        return this;
    }

    @Override
    public EmptyContainer and(RunContainer x) {
        return this;
    }

    @Override
    public EmptyContainer andRange(int start, int end) {
        return this;
    }

    @Override
    public EmptyContainer andNot(ArrayContainer x) {
        return this;
    }

    @Override
    public EmptyContainer andNot(BitmapContainer x) {
        return this;
    }

    @Override
    public EmptyContainer andNot(RunContainer x) {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean isAllOnes() {
        return false;
    }

    @Override
    public boolean contains(short x) {
        return false;
    }

    @Override
    public boolean contains(int rangeStart, int rangeEnd) {
        return rangeEnd <= rangeStart;
    }

    @Override
    protected boolean contains(RunContainer runContainer) {
        return runContainer.isEmpty();
    }

    @Override
    protected boolean contains(ArrayContainer arrayContainer) {
        return arrayContainer.isEmpty();
    }

    @Override
    protected boolean contains(BitmapContainer bitmapContainer) {
        return bitmapContainer.isEmpty();
    }

    @Override
    public Container iflip(short x) {
        return new SingletonContainer(x);
    }

    @Override
    public int getCardinality() {
        return 0;
    }

    @Override
    public boolean forEach(ShortConsumer sc) {
        return true;
    }

    @Override
    public boolean forEach(int rankOffset, ShortConsumer sc) {
        return true;
    }

    @Override
    public boolean forEachRange(int rankOffset, ShortRangeConsumer sc) {
        return true;
    }

    @Override
    public ShortAdvanceIterator getReverseShortIterator() {
        return iter;
    }

    @Override
    public ShortIterator getShortIterator() {
        return iter;
    }

    @Override
    public ContainerShortBatchIterator getShortBatchIterator(int skipFromStartCount) {
        return iter;
    }

    @Override
    public SearchRangeIterator getShortRangeIterator(int skipFromStartCount) {
        return searchRangeIter;
    }

    @Override
    public Container not(int rangeStart, int rangeEnd) {
        return Container.singleRange(rangeStart, rangeEnd);
    }

    @Override
    int numberOfRuns() {
        return 0;
    }

    @Override
    public Container or(ArrayContainer x) {
        return x.cowRef();
    }

    @Override
    public Container or(BitmapContainer x) {
        return x.cowRef();
    }

    @Override
    public Container or(RunContainer x) {
        return x.cowRef();
    }

    @Override
    public int rank(short lowbits) {
        return 0;
    }

    @Override
    public EmptyContainer remove(int begin, int end) {
        return this;
    }

    @Override
    public EmptyContainer unset(short x) {
        return this;
    }

    @Override
    Container unset(short x, PositionHint positionHint) {
        positionHint.reset();
        return this.unset(x);
    }

    @Override
    public EmptyContainer runOptimize() {
        return this;
    }

    @Override
    public short select(int j) {
        throw new IllegalStateException("j=" + j);
    }

    @Override
    public Container select(int startRank, int endRank) {
        if (endRank <= startRank) {
            return this;
        }
        throw new IllegalArgumentException("startRank=" + startRank + ", endRank=" + endRank);
    }

    @Override
    public int find(short x) {
        return -1;
    }

    @Override
    public void selectRanges(RangeConsumer outValues, RangeIterator inPositions) {
        if (inPositions.hasNext()) {
            throw new IllegalStateException();
        }
    }

    @Override
    public boolean findRanges(RangeConsumer outPositions, RangeIterator inValues, int maxPos) {
        if (inValues.hasNext()) {
            throw new IllegalStateException();
        }
        return false;
    }

    @Override
    public void trim() {
    }

    @Override
    public Container xor(ArrayContainer x) {
        return x.cowRef();
    }

    @Override
    public Container xor(BitmapContainer x) {
        return x.cowRef();
    }

    @Override
    public Container xor(RunContainer x) {
        return x.cowRef();
    }

    @Override
    public BitmapContainer toBitmapContainer() {
        return new BitmapContainer();
    }

    @Override
    public int nextValue(short fromValue) {
        throw new IllegalStateException("fromValue=" + fromValue);
    }

    @Override
    public int first() {
        throw new IllegalStateException();
    }

    @Override
    public int last() {
        throw new IllegalStateException();
    }

    @Override
    public boolean subsetOf(ArrayContainer x) {
        return true;
    }

    @Override
    public boolean subsetOf(BitmapContainer x) {
        return true;
    }

    @Override
    public boolean subsetOf(RunContainer x) {
        return true;
    }

    @Override
    public boolean overlaps(ArrayContainer x) {
        return false;
    }

    @Override
    public boolean overlaps(BitmapContainer x) {
        return false;
    }

    @Override
    public boolean overlaps(RunContainer x) {
        return false;
    }

    @Override
    public boolean overlapsRange(int start, int end) {
        return false;
    }

    @Override
    public void setCopyOnWrite() {
    }

    @Override
    public int bytesAllocated() {
        return 0;
    }

    @Override
    public int bytesUsed() {
        return 0;
    }

    @Override
    public String toString() {
        return "{ }";
    }

    @Override
    public Container toLargeContainer() {
        return new ArrayContainer();
    }

    @Override
    public void validate() {
    }

    private static final class SearchRangeIter
    implements SearchRangeIterator {
        private SearchRangeIter() {
        }

        @Override
        public boolean advance(int v) {
            return false;
        }

        @Override
        public boolean search(ContainerUtil.TargetComparator comp) {
            return false;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public int start() {
            throw new IllegalStateException();
        }

        @Override
        public int end() {
            throw new IllegalStateException();
        }

        @Override
        public void next() {
            throw new IllegalStateException();
        }
    }

    private static final class Iter
    implements ShortAdvanceIterator,
    ContainerShortBatchIterator {
        private Iter() {
        }

        @Override
        public int next(short[] buffer, int offset, int maxCount) {
            return 0;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public boolean forEach(ShortConsumer sc) {
            return true;
        }

        @Override
        public short next() {
            throw new IllegalStateException();
        }

        @Override
        public int nextAsInt() {
            throw new IllegalStateException();
        }

        @Override
        public short curr() {
            throw new IllegalStateException();
        }

        @Override
        public int currAsInt() {
            throw new IllegalStateException();
        }

        @Override
        public boolean advance(int v) {
            return false;
        }
    }
}

