/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl.rsp.container;

import io.deephaven.engine.rowset.impl.rsp.container.AbortableRangeConsumer;
import java.util.Arrays;

public interface RangeIterator {
    public boolean hasNext();

    public int start();

    public int end();

    public void next();

    default public boolean forEachRange(AbortableRangeConsumer rc) {
        while (this.hasNext()) {
            this.next();
            boolean wantMore = rc.accept(this.start(), this.end());
            if (wantMore) continue;
            return false;
        }
        return true;
    }

    default public int next(short[] buffer, int offset, int maxRanges) {
        int count;
        for (count = 0; this.hasNext() && count < maxRanges; ++count) {
            this.next();
            buffer[offset + 2 * count] = (short)this.start();
            buffer[offset + 2 * count + 1] = (short)(this.end() - 1);
        }
        return count;
    }

    public static class ArrayBacked
    implements RangeIterator {
        private final int[] ranges;
        private int pos;

        public ArrayBacked(int[] ranges) {
            if ((ranges.length & 1) != 0) {
                throw new IllegalArgumentException("Invalid array for range, odd size=" + ranges.length);
            }
            this.ranges = Arrays.copyOf(ranges, ranges.length);
            this.pos = -2;
        }

        private ArrayBacked(ArrayBacked other) {
            this.ranges = other.ranges;
            this.pos = other.pos;
        }

        public ArrayBacked copy() {
            return new ArrayBacked(this);
        }

        @Override
        public boolean hasNext() {
            return this.pos + 2 < this.ranges.length;
        }

        @Override
        public int start() {
            return this.ranges[this.pos];
        }

        @Override
        public int end() {
            return this.ranges[this.pos + 1];
        }

        @Override
        public void next() {
            this.pos += 2;
        }

        @Override
        public int next(short[] buffer, int offset, int maxShortCount) {
            throw new UnsupportedOperationException();
        }
    }

    public static class Single
    implements RangeIterator {
        int start;
        int end;
        boolean hasNext;

        public Single(int start, int end) {
            if (end < start || start < 0) {
                throw new IllegalArgumentException("Invalid range start=" + start + ", endI=" + end);
            }
            this.start = start;
            this.end = end;
            this.hasNext = true;
        }

        private Single(Single other) {
            this.start = other.start;
            this.end = other.end;
            this.hasNext = other.hasNext;
        }

        public Single copy() {
            return new Single(this);
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public int start() {
            return this.start;
        }

        @Override
        public int end() {
            return this.end;
        }

        @Override
        public void next() {
            this.hasNext = false;
        }

        @Override
        public int next(short[] buffer, int offset, int maxShortCount) {
            throw new UnsupportedOperationException();
        }
    }
}

