/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl.rsp.container;

import io.deephaven.engine.rowset.impl.rsp.container.ContainerUtil;
import io.deephaven.engine.rowset.impl.rsp.container.RunContainer;
import io.deephaven.engine.rowset.impl.rsp.container.SearchRangeIterator;

final class RunContainerRangeIterator
implements SearchRangeIterator {
    private final RunContainer parent;
    private int pos;
    private int start;
    private int end;

    RunContainerRangeIterator(RunContainer p) {
        this(p, 0);
    }

    RunContainerRangeIterator(RunContainer p, int initialSkipCount) {
        this.pos = 0;
        this.parent = p;
        this.end = -1;
        int numRuns = this.parent.numberOfRuns();
        if (numRuns == 0) {
            return;
        }
        if (initialSkipCount == 0) {
            this.start = this.runStart(this.pos);
            return;
        }
        int remaining = initialSkipCount;
        do {
            int runSize;
            if (remaining < (runSize = ContainerUtil.toIntUnsigned(this.parent.getLength(this.pos)) + 1)) {
                this.start = this.runStart(this.pos) + remaining;
                break;
            }
            remaining -= runSize;
            ++this.pos;
        } while (this.pos < numRuns);
    }

    RunContainerRangeIterator(RunContainerRangeIterator other) {
        this.pos = other.pos;
        this.start = other.start;
        this.end = other.end;
        this.parent = other.parent;
    }

    public RunContainerRangeIterator copy() {
        return new RunContainerRangeIterator(this);
    }

    @Override
    public boolean hasNext() {
        if (this.end == -1) {
            return this.pos < this.parent.nbrruns;
        }
        return this.pos + 1 < this.parent.nbrruns;
    }

    private int runStart(int i) {
        return ContainerUtil.toIntUnsigned(this.parent.getValue(i));
    }

    @Override
    public int start() {
        return this.start;
    }

    private int runLast(int i) {
        return this.runLast(this.runStart(i), i);
    }

    private int runLast(int runStart, int i) {
        return runStart + ContainerUtil.toIntUnsigned(this.parent.getLength(i));
    }

    @Override
    public int end() {
        return this.end;
    }

    @Override
    public void next() {
        if (this.end == -1) {
            this.end = this.runLast(this.pos) + 1;
            return;
        }
        ++this.pos;
        this.start = this.runStart(this.pos);
        this.end = this.runLast(this.start, this.pos) + 1;
    }

    @Override
    public int next(short[] buffer, int offset, int maxRanges) {
        int e;
        int s;
        int count = 0;
        if (this.end == -1 && maxRanges > 0) {
            buffer[offset] = (short)this.start;
            int e2 = this.runLast(this.pos);
            buffer[offset + 1] = (short)e2;
            ++count;
            if (this.pos + 1 >= this.parent.nbrruns || maxRanges < 2) {
                this.end = e2 + 1;
                return 1;
            }
        } else if (maxRanges <= 0) {
            return 0;
        }
        do {
            ++this.pos;
            s = this.runStart(this.pos);
            e = this.runLast(s, this.pos);
            buffer[offset + 2 * count] = (short)s;
            buffer[offset + 2 * count + 1] = (short)e;
        } while (++count < maxRanges && this.pos + 1 < this.parent.nbrruns);
        this.start = s;
        this.end = e + 1;
        return count;
    }

    @Override
    public boolean advance(int v) {
        if (this.end == -1) {
            if (!this.hasNext()) {
                return false;
            }
            this.next();
        }
        if (this.end - 1 >= v) {
            this.start = Math.max(this.start, v);
            return true;
        }
        int left = Math.max(0, this.pos);
        int right = this.parent.nbrruns - 1;
        if (this.runLast(right) < v) {
            this.pos = this.parent.nbrruns;
            return false;
        }
        while (true) {
            this.pos = (left + right) / 2;
            if (this.runLast(this.pos) < v) {
                left = this.pos + 1;
                continue;
            }
            if (right == this.pos) {
                int runStart = this.runStart(this.pos);
                this.start = Math.max(runStart, v);
                this.end = this.runLast(runStart, this.pos) + 1;
                return true;
            }
            right = this.pos;
        }
    }

    @Override
    public boolean search(ContainerUtil.TargetComparator comp) {
        int posNext;
        int posNextStart;
        int c;
        if (this.end == -1) {
            if (!this.hasNext()) {
                return false;
            }
            this.next();
        }
        if (comp.directionFrom(this.start) < 0) {
            return false;
        }
        int posStart = this.start;
        int right = this.parent.nbrruns - 1;
        while (this.pos + 32 < right) {
            int mid = (this.pos + right) / 2;
            int midStart = this.runStart(mid);
            c = comp.directionFrom(midStart);
            if (c < 0) {
                right = mid - 1;
                continue;
            }
            this.pos = mid;
            posStart = midStart;
        }
        while (this.pos < right && (c = comp.directionFrom(posNextStart = this.runStart(posNext = this.pos + 1))) >= 0) {
            this.pos = posNext;
            posStart = posNextStart;
        }
        this.end = this.runLast(this.pos) + 1;
        this.start = ContainerUtil.rangeSearch(posStart, this.end, comp);
        assert (this.start != -1);
        return true;
    }
}

