/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl.rsp.container;

import io.deephaven.engine.rowset.impl.rsp.container.ContainerShortBatchIterator;
import io.deephaven.engine.rowset.impl.rsp.container.ContainerUtil;
import io.deephaven.engine.rowset.impl.rsp.container.RunContainer;
import io.deephaven.engine.rowset.impl.rsp.container.ShortConsumer;

public class RunShortBatchIterator
implements ContainerShortBatchIterator {
    private final RunContainer runs;
    private int run = 0;
    private int cursor = 0;

    public RunShortBatchIterator(RunContainer runs, int initialSkipCount) {
        this.runs = runs;
        int numRuns = runs.numberOfRuns();
        int remaining = initialSkipCount;
        do {
            int runSize;
            if (remaining < (runSize = ContainerUtil.toIntUnsigned(runs.getLength(this.run)) + 1)) {
                this.cursor = remaining;
                break;
            }
            remaining -= runSize;
            ++this.run;
        } while (this.run < numRuns);
    }

    @Override
    public int next(short[] buffer, int offset, int maxCount) {
        int count = 0;
        do {
            int runStart = ContainerUtil.toIntUnsigned(this.runs.getValue(this.run));
            int runLength = ContainerUtil.toIntUnsigned(this.runs.getLength(this.run));
            int chunkStart = runStart + this.cursor;
            int chunkEnd = chunkStart + Math.min(runLength - this.cursor, maxCount - count - 1);
            int chunk = chunkEnd - chunkStart + 1;
            for (int i = 0; i < chunk; ++i) {
                buffer[offset + count + i] = (short)(chunkStart + i);
            }
            count += chunk;
            if (runStart + runLength == chunkEnd) {
                ++this.run;
                this.cursor = 0;
                continue;
            }
            this.cursor += chunk;
        } while (count < maxCount && this.run != this.runs.numberOfRuns());
        return count;
    }

    @Override
    public boolean hasNext() {
        return this.run < this.runs.numberOfRuns();
    }

    @Override
    public boolean forEach(ShortConsumer sc) {
        int numRuns = this.runs.numberOfRuns();
        while (this.run < numRuns) {
            int runStart = ContainerUtil.toIntUnsigned(this.runs.getValue(this.run));
            int runLength = ContainerUtil.toIntUnsigned(this.runs.getLength(this.run));
            boolean wantMore = true;
            while (this.cursor <= runLength) {
                wantMore = sc.accept((short)(runStart + this.cursor));
                ++this.cursor;
                if (wantMore) continue;
            }
            if (this.cursor > runLength) {
                ++this.run;
                this.cursor = 0;
            }
            if (wantMore) continue;
            return false;
        }
        return true;
    }
}

