/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.process;

import io.deephaven.process.BaseboardOshi;
import io.deephaven.process.FirmwareOshi;
import io.deephaven.process.ImmutableComputerSystemOshi;
import io.deephaven.process.ProcessStyle;
import io.deephaven.properties.PropertySet;
import io.deephaven.properties.PropertyVisitor;
import org.immutables.value.Value;
import oshi.hardware.ComputerSystem;

@Value.Immutable
@ProcessStyle
public abstract class ComputerSystemOshi
implements PropertySet {
    private static final String MANUFACTURER = "manufacturer";
    private static final String MODEL = "model";
    private static final String FIRMWARE = "firmware";
    private static final String BASEBOARD = "baseboard";

    @Value.Parameter
    public abstract String getManufacturer();

    @Value.Parameter
    public abstract String getModel();

    @Value.Parameter
    public abstract FirmwareOshi getFirmware();

    @Value.Parameter
    public abstract BaseboardOshi getBaseboard();

    @Override
    public final void traverse(PropertyVisitor visitor) {
        visitor.visit(MANUFACTURER, this.getManufacturer());
        visitor.visit(MODEL, this.getManufacturer());
        visitor.visitProperties(FIRMWARE, this.getFirmware());
        visitor.visitProperties(BASEBOARD, this.getBaseboard());
    }

    public static ComputerSystemOshi from(ComputerSystem computerSystem) {
        return ImmutableComputerSystemOshi.builder().manufacturer(computerSystem.getManufacturer()).model(computerSystem.getModel()).firmware(FirmwareOshi.from(computerSystem.getFirmware())).baseboard(BaseboardOshi.from(computerSystem.getBaseboard())).build();
    }
}

