/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.process;

import io.deephaven.process.DnsServers;
import io.deephaven.process.NetworkOshi;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Generated(from="NetworkOshi", generator="Immutables")
final class ImmutableNetworkOshi
extends NetworkOshi {
    private final String hostName;
    private final String domainName;
    private final DnsServers dnsServers;
    private final String ipv4DefaultGateway;
    private final String ipv6DefaultGateway;

    private ImmutableNetworkOshi(String hostName, Optional<String> domainName, DnsServers dnsServers, Optional<String> ipv4DefaultGateway, Optional<String> ipv6DefaultGateway) {
        this.hostName = Objects.requireNonNull(hostName, "hostName");
        this.domainName = domainName.orElse(null);
        this.dnsServers = Objects.requireNonNull(dnsServers, "dnsServers");
        this.ipv4DefaultGateway = ipv4DefaultGateway.orElse(null);
        this.ipv6DefaultGateway = ipv6DefaultGateway.orElse(null);
    }

    private ImmutableNetworkOshi(Builder builder) {
        this.hostName = builder.hostName;
        this.domainName = builder.domainName;
        this.dnsServers = builder.dnsServers;
        this.ipv4DefaultGateway = builder.ipv4DefaultGateway;
        this.ipv6DefaultGateway = builder.ipv6DefaultGateway;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public Optional<String> getDomainName() {
        return Optional.ofNullable(this.domainName);
    }

    @Override
    public DnsServers getDnsServers() {
        return this.dnsServers;
    }

    @Override
    public Optional<String> getIpv4DefaultGateway() {
        return Optional.ofNullable(this.ipv4DefaultGateway);
    }

    @Override
    public Optional<String> getIpv6DefaultGateway() {
        return Optional.ofNullable(this.ipv6DefaultGateway);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNetworkOshi && this.equalTo((ImmutableNetworkOshi)another);
    }

    private boolean equalTo(ImmutableNetworkOshi another) {
        return this.hostName.equals(another.hostName) && Objects.equals(this.domainName, another.domainName) && this.dnsServers.equals(another.dnsServers) && Objects.equals(this.ipv4DefaultGateway, another.ipv4DefaultGateway) && Objects.equals(this.ipv6DefaultGateway, another.ipv6DefaultGateway);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.hostName.hashCode();
        h += (h << 5) + Objects.hashCode(this.domainName);
        h += (h << 5) + this.dnsServers.hashCode();
        h += (h << 5) + Objects.hashCode(this.ipv4DefaultGateway);
        h += (h << 5) + Objects.hashCode(this.ipv6DefaultGateway);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("NetworkOshi{");
        builder.append("hostName=").append(this.hostName);
        if (this.domainName != null) {
            builder.append(", ");
            builder.append("domainName=").append(this.domainName);
        }
        builder.append(", ");
        builder.append("dnsServers=").append(this.dnsServers);
        if (this.ipv4DefaultGateway != null) {
            builder.append(", ");
            builder.append("ipv4DefaultGateway=").append(this.ipv4DefaultGateway);
        }
        if (this.ipv6DefaultGateway != null) {
            builder.append(", ");
            builder.append("ipv6DefaultGateway=").append(this.ipv6DefaultGateway);
        }
        return builder.append("}").toString();
    }

    public static ImmutableNetworkOshi of(String hostName, Optional<String> domainName, DnsServers dnsServers, Optional<String> ipv4DefaultGateway, Optional<String> ipv6DefaultGateway) {
        return new ImmutableNetworkOshi(hostName, domainName, dnsServers, ipv4DefaultGateway, ipv6DefaultGateway);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NetworkOshi", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_HOST_NAME = 1L;
        private static final long INIT_BIT_DNS_SERVERS = 2L;
        private static final long OPT_BIT_DOMAIN_NAME = 1L;
        private static final long OPT_BIT_IPV4_DEFAULT_GATEWAY = 2L;
        private static final long OPT_BIT_IPV6_DEFAULT_GATEWAY = 4L;
        private long initBits = 3L;
        private long optBits;
        private String hostName;
        private String domainName;
        private DnsServers dnsServers;
        private String ipv4DefaultGateway;
        private String ipv6DefaultGateway;

        private Builder() {
        }

        public final Builder hostName(String hostName) {
            Builder.checkNotIsSet(this.hostNameIsSet(), "hostName");
            this.hostName = Objects.requireNonNull(hostName, "hostName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder domainName(String domainName) {
            Builder.checkNotIsSet(this.domainNameIsSet(), "domainName");
            this.domainName = Objects.requireNonNull(domainName, "domainName");
            this.optBits |= 1L;
            return this;
        }

        public final Builder domainName(Optional<String> domainName) {
            Builder.checkNotIsSet(this.domainNameIsSet(), "domainName");
            this.domainName = domainName.orElse(null);
            this.optBits |= 1L;
            return this;
        }

        public final Builder dnsServers(DnsServers dnsServers) {
            Builder.checkNotIsSet(this.dnsServersIsSet(), "dnsServers");
            this.dnsServers = Objects.requireNonNull(dnsServers, "dnsServers");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder ipv4DefaultGateway(String ipv4DefaultGateway) {
            Builder.checkNotIsSet(this.ipv4DefaultGatewayIsSet(), "ipv4DefaultGateway");
            this.ipv4DefaultGateway = Objects.requireNonNull(ipv4DefaultGateway, "ipv4DefaultGateway");
            this.optBits |= 2L;
            return this;
        }

        public final Builder ipv4DefaultGateway(Optional<String> ipv4DefaultGateway) {
            Builder.checkNotIsSet(this.ipv4DefaultGatewayIsSet(), "ipv4DefaultGateway");
            this.ipv4DefaultGateway = ipv4DefaultGateway.orElse(null);
            this.optBits |= 2L;
            return this;
        }

        public final Builder ipv6DefaultGateway(String ipv6DefaultGateway) {
            Builder.checkNotIsSet(this.ipv6DefaultGatewayIsSet(), "ipv6DefaultGateway");
            this.ipv6DefaultGateway = Objects.requireNonNull(ipv6DefaultGateway, "ipv6DefaultGateway");
            this.optBits |= 4L;
            return this;
        }

        public final Builder ipv6DefaultGateway(Optional<String> ipv6DefaultGateway) {
            Builder.checkNotIsSet(this.ipv6DefaultGatewayIsSet(), "ipv6DefaultGateway");
            this.ipv6DefaultGateway = ipv6DefaultGateway.orElse(null);
            this.optBits |= 4L;
            return this;
        }

        public ImmutableNetworkOshi build() {
            this.checkRequiredAttributes();
            return new ImmutableNetworkOshi(this);
        }

        private boolean domainNameIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean ipv4DefaultGatewayIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean ipv6DefaultGatewayIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean hostNameIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean dnsServersIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of NetworkOshi is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.hostNameIsSet()) {
                attributes.add("hostName");
            }
            if (!this.dnsServersIsSet()) {
                attributes.add("dnsServers");
            }
            return "Cannot build NetworkOshi, some of required attributes are not set " + attributes;
        }
    }
}

