/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.process;

import io.deephaven.process.OperatingSystemVersionOshi;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Generated(from="OperatingSystemVersionOshi", generator="Immutables")
final class ImmutableOperatingSystemVersionOshi
extends OperatingSystemVersionOshi {
    private final String version;
    private final String codeName;
    private final String buildNumber;

    private ImmutableOperatingSystemVersionOshi(Optional<String> version, Optional<String> codeName, Optional<String> buildNumber) {
        this.version = version.orElse(null);
        this.codeName = codeName.orElse(null);
        this.buildNumber = buildNumber.orElse(null);
    }

    private ImmutableOperatingSystemVersionOshi(Builder builder) {
        this.version = builder.version;
        this.codeName = builder.codeName;
        this.buildNumber = builder.buildNumber;
    }

    @Override
    public Optional<String> getVersion() {
        return Optional.ofNullable(this.version);
    }

    @Override
    public Optional<String> getCodeName() {
        return Optional.ofNullable(this.codeName);
    }

    @Override
    public Optional<String> getBuildNumber() {
        return Optional.ofNullable(this.buildNumber);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOperatingSystemVersionOshi && this.equalTo((ImmutableOperatingSystemVersionOshi)another);
    }

    private boolean equalTo(ImmutableOperatingSystemVersionOshi another) {
        return Objects.equals(this.version, another.version) && Objects.equals(this.codeName, another.codeName) && Objects.equals(this.buildNumber, another.buildNumber);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.version);
        h += (h << 5) + Objects.hashCode(this.codeName);
        h += (h << 5) + Objects.hashCode(this.buildNumber);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("OperatingSystemVersionOshi{");
        if (this.version != null) {
            builder.append("version=").append(this.version);
        }
        if (this.codeName != null) {
            if (builder.length() > 27) {
                builder.append(", ");
            }
            builder.append("codeName=").append(this.codeName);
        }
        if (this.buildNumber != null) {
            if (builder.length() > 27) {
                builder.append(", ");
            }
            builder.append("buildNumber=").append(this.buildNumber);
        }
        return builder.append("}").toString();
    }

    public static ImmutableOperatingSystemVersionOshi of(Optional<String> version, Optional<String> codeName, Optional<String> buildNumber) {
        return new ImmutableOperatingSystemVersionOshi(version, codeName, buildNumber);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OperatingSystemVersionOshi", generator="Immutables")
    public static final class Builder {
        private static final long OPT_BIT_VERSION = 1L;
        private static final long OPT_BIT_CODE_NAME = 2L;
        private static final long OPT_BIT_BUILD_NUMBER = 4L;
        private long optBits;
        private String version;
        private String codeName;
        private String buildNumber;

        private Builder() {
        }

        public final Builder version(String version) {
            Builder.checkNotIsSet(this.versionIsSet(), "version");
            this.version = Objects.requireNonNull(version, "version");
            this.optBits |= 1L;
            return this;
        }

        public final Builder version(Optional<String> version) {
            Builder.checkNotIsSet(this.versionIsSet(), "version");
            this.version = version.orElse(null);
            this.optBits |= 1L;
            return this;
        }

        public final Builder codeName(String codeName) {
            Builder.checkNotIsSet(this.codeNameIsSet(), "codeName");
            this.codeName = Objects.requireNonNull(codeName, "codeName");
            this.optBits |= 2L;
            return this;
        }

        public final Builder codeName(Optional<String> codeName) {
            Builder.checkNotIsSet(this.codeNameIsSet(), "codeName");
            this.codeName = codeName.orElse(null);
            this.optBits |= 2L;
            return this;
        }

        public final Builder buildNumber(String buildNumber) {
            Builder.checkNotIsSet(this.buildNumberIsSet(), "buildNumber");
            this.buildNumber = Objects.requireNonNull(buildNumber, "buildNumber");
            this.optBits |= 4L;
            return this;
        }

        public final Builder buildNumber(Optional<String> buildNumber) {
            Builder.checkNotIsSet(this.buildNumberIsSet(), "buildNumber");
            this.buildNumber = buildNumber.orElse(null);
            this.optBits |= 4L;
            return this;
        }

        public ImmutableOperatingSystemVersionOshi build() {
            return new ImmutableOperatingSystemVersionOshi(this);
        }

        private boolean versionIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean codeNameIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean buildNumberIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of OperatingSystemVersionOshi is strict, attribute is already set: ".concat(name));
            }
        }
    }
}

