/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.process;

import io.deephaven.process.JvmArguments;
import io.deephaven.process.RuntimeMxBeanInfo;
import io.deephaven.process.SystemProperties;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="RuntimeMxBeanInfo", generator="Immutables")
final class ImmutableRuntimeMxBeanInfo
extends RuntimeMxBeanInfo {
    private final SystemProperties systemProperties;
    private final JvmArguments jvmArguments;
    private final String managementSpecVersion;
    private final boolean isBootClassPathSupported;
    private final long startTime;

    private ImmutableRuntimeMxBeanInfo(SystemProperties systemProperties, JvmArguments jvmArguments, String managementSpecVersion, boolean isBootClassPathSupported, long startTime) {
        this.systemProperties = Objects.requireNonNull(systemProperties, "systemProperties");
        this.jvmArguments = Objects.requireNonNull(jvmArguments, "jvmArguments");
        this.managementSpecVersion = Objects.requireNonNull(managementSpecVersion, "managementSpecVersion");
        this.isBootClassPathSupported = isBootClassPathSupported;
        this.startTime = startTime;
    }

    private ImmutableRuntimeMxBeanInfo(Builder builder) {
        this.systemProperties = builder.systemProperties;
        this.jvmArguments = builder.jvmArguments;
        this.managementSpecVersion = builder.managementSpecVersion;
        this.isBootClassPathSupported = builder.isBootClassPathSupported;
        this.startTime = builder.startTime;
    }

    @Override
    public SystemProperties getSystemProperties() {
        return this.systemProperties;
    }

    @Override
    public JvmArguments getJvmArguments() {
        return this.jvmArguments;
    }

    @Override
    public String getManagementSpecVersion() {
        return this.managementSpecVersion;
    }

    @Override
    public boolean isBootClassPathSupported() {
        return this.isBootClassPathSupported;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRuntimeMxBeanInfo && this.equalTo((ImmutableRuntimeMxBeanInfo)another);
    }

    private boolean equalTo(ImmutableRuntimeMxBeanInfo another) {
        return this.systemProperties.equals(another.systemProperties) && this.jvmArguments.equals(another.jvmArguments) && this.managementSpecVersion.equals(another.managementSpecVersion) && this.isBootClassPathSupported == another.isBootClassPathSupported && this.startTime == another.startTime;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.systemProperties.hashCode();
        h += (h << 5) + this.jvmArguments.hashCode();
        h += (h << 5) + this.managementSpecVersion.hashCode();
        h += (h << 5) + Boolean.hashCode(this.isBootClassPathSupported);
        h += (h << 5) + Long.hashCode(this.startTime);
        return h;
    }

    public String toString() {
        return "RuntimeMxBeanInfo{systemProperties=" + this.systemProperties + ", jvmArguments=" + this.jvmArguments + ", managementSpecVersion=" + this.managementSpecVersion + ", isBootClassPathSupported=" + this.isBootClassPathSupported + ", startTime=" + this.startTime + "}";
    }

    public static ImmutableRuntimeMxBeanInfo of(SystemProperties systemProperties, JvmArguments jvmArguments, String managementSpecVersion, boolean isBootClassPathSupported, long startTime) {
        return new ImmutableRuntimeMxBeanInfo(systemProperties, jvmArguments, managementSpecVersion, isBootClassPathSupported, startTime);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RuntimeMxBeanInfo", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_SYSTEM_PROPERTIES = 1L;
        private static final long INIT_BIT_JVM_ARGUMENTS = 2L;
        private static final long INIT_BIT_MANAGEMENT_SPEC_VERSION = 4L;
        private static final long INIT_BIT_IS_BOOT_CLASS_PATH_SUPPORTED = 8L;
        private static final long INIT_BIT_START_TIME = 16L;
        private long initBits = 31L;
        private SystemProperties systemProperties;
        private JvmArguments jvmArguments;
        private String managementSpecVersion;
        private boolean isBootClassPathSupported;
        private long startTime;

        private Builder() {
        }

        public final Builder systemProperties(SystemProperties systemProperties) {
            Builder.checkNotIsSet(this.systemPropertiesIsSet(), "systemProperties");
            this.systemProperties = Objects.requireNonNull(systemProperties, "systemProperties");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder jvmArguments(JvmArguments jvmArguments) {
            Builder.checkNotIsSet(this.jvmArgumentsIsSet(), "jvmArguments");
            this.jvmArguments = Objects.requireNonNull(jvmArguments, "jvmArguments");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder managementSpecVersion(String managementSpecVersion) {
            Builder.checkNotIsSet(this.managementSpecVersionIsSet(), "managementSpecVersion");
            this.managementSpecVersion = Objects.requireNonNull(managementSpecVersion, "managementSpecVersion");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder isBootClassPathSupported(boolean isBootClassPathSupported) {
            Builder.checkNotIsSet(this.isBootClassPathSupportedIsSet(), "isBootClassPathSupported");
            this.isBootClassPathSupported = isBootClassPathSupported;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder startTime(long startTime) {
            Builder.checkNotIsSet(this.startTimeIsSet(), "startTime");
            this.startTime = startTime;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableRuntimeMxBeanInfo build() {
            this.checkRequiredAttributes();
            return new ImmutableRuntimeMxBeanInfo(this);
        }

        private boolean systemPropertiesIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean jvmArgumentsIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean managementSpecVersionIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean isBootClassPathSupportedIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean startTimeIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of RuntimeMxBeanInfo is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.systemPropertiesIsSet()) {
                attributes.add("systemProperties");
            }
            if (!this.jvmArgumentsIsSet()) {
                attributes.add("jvmArguments");
            }
            if (!this.managementSpecVersionIsSet()) {
                attributes.add("managementSpecVersion");
            }
            if (!this.isBootClassPathSupportedIsSet()) {
                attributes.add("isBootClassPathSupported");
            }
            if (!this.startTimeIsSet()) {
                attributes.add("startTime");
            }
            return "Cannot build RuntimeMxBeanInfo, some of required attributes are not set " + attributes;
        }
    }
}

