/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.process;

import io.deephaven.process.ImmutableMemoryPoolsMxBeanInfo;
import io.deephaven.process.MemoryUsageInfo;
import io.deephaven.process.ProcessStyle;
import io.deephaven.properties.PropertySet;
import io.deephaven.properties.PropertyVisitor;
import java.lang.management.MemoryPoolMXBean;
import java.util.List;
import java.util.Map;
import org.immutables.value.Value;

@Value.Immutable
@ProcessStyle
public abstract class MemoryPoolsMxBeanInfo
implements PropertySet {
    public static MemoryPoolsMxBeanInfo of(List<MemoryPoolMXBean> pools) {
        ImmutableMemoryPoolsMxBeanInfo.Builder builder = ImmutableMemoryPoolsMxBeanInfo.builder();
        for (MemoryPoolMXBean pool : pools) {
            builder.putUsages(pool.getName(), MemoryUsageInfo.of(pool.getUsage()));
        }
        return builder.build();
    }

    @Value.Parameter
    public abstract Map<String, MemoryUsageInfo> usages();

    @Override
    public void traverse(PropertyVisitor visitor) {
        for (Map.Entry<String, MemoryUsageInfo> e : this.usages().entrySet()) {
            visitor.visitProperties(e.getKey(), e.getValue());
        }
    }
}

