/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.process;

import io.deephaven.process.DnsServers;
import io.deephaven.process.ImmutableNetworkOshi;
import io.deephaven.process.ProcessStyle;
import io.deephaven.properties.PropertySet;
import io.deephaven.properties.PropertyVisitor;
import java.util.Arrays;
import java.util.Optional;
import org.immutables.value.Value;
import oshi.software.os.NetworkParams;

@Value.Immutable
@ProcessStyle
public abstract class NetworkOshi
implements PropertySet {
    private static final String HOSTNAME = "hostname";
    private static final String DOMAINNAME = "domainname";
    private static final String GATEWAY_IPV_4 = "gateway.ipv4";
    private static final String GATEWAY_IPV_6 = "gateway.ipv6";
    private static final String DNS = "dns";

    @Value.Parameter
    public abstract String getHostName();

    @Value.Parameter
    public abstract Optional<String> getDomainName();

    @Value.Parameter
    public abstract DnsServers getDnsServers();

    @Value.Parameter
    public abstract Optional<String> getIpv4DefaultGateway();

    @Value.Parameter
    public abstract Optional<String> getIpv6DefaultGateway();

    @Override
    public final void traverse(PropertyVisitor visitor) {
        visitor.visit(HOSTNAME, this.getHostName());
        visitor.maybeVisit(DOMAINNAME, this.getDomainName());
        visitor.visitProperties(DNS, this.getDnsServers());
        visitor.maybeVisit(GATEWAY_IPV_4, this.getIpv4DefaultGateway());
        visitor.maybeVisit(GATEWAY_IPV_6, this.getIpv6DefaultGateway());
    }

    public static NetworkOshi from(NetworkParams network) {
        return ImmutableNetworkOshi.builder().hostName(network.getHostName()).domainName(network.getDomainName().isEmpty() ? Optional.empty() : Optional.of(network.getDomainName())).dnsServers(DnsServers.of(Arrays.asList(network.getDnsServers()))).ipv4DefaultGateway(network.getIpv4DefaultGateway().isEmpty() ? Optional.empty() : Optional.of(network.getIpv4DefaultGateway())).ipv6DefaultGateway(network.getIpv6DefaultGateway().isEmpty() ? Optional.empty() : Optional.of(network.getIpv6DefaultGateway())).build();
    }
}

