/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.process;

import io.deephaven.process.ImmutableOperatingSystemVersionOshi;
import io.deephaven.process.ProcessStyle;
import io.deephaven.properties.PropertySet;
import io.deephaven.properties.PropertyVisitor;
import java.util.Optional;
import org.immutables.value.Value;
import oshi.software.os.OperatingSystem;

@Value.Immutable
@ProcessStyle
public abstract class OperatingSystemVersionOshi
implements PropertySet {
    private static final String VERSION = "version";
    private static final String NAME = "name";
    private static final String BUILD = "build";

    @Value.Parameter
    public abstract Optional<String> getVersion();

    @Value.Parameter
    public abstract Optional<String> getCodeName();

    @Value.Parameter
    public abstract Optional<String> getBuildNumber();

    @Override
    public final void traverse(PropertyVisitor visitor) {
        visitor.maybeVisit(VERSION, this.getVersion());
        visitor.maybeVisit(NAME, this.getCodeName());
        visitor.maybeVisit(BUILD, this.getBuildNumber());
    }

    public static OperatingSystemVersionOshi from(OperatingSystem.OSVersionInfo info) {
        return ImmutableOperatingSystemVersionOshi.builder().version(Optional.ofNullable(info.getVersion())).codeName(Optional.ofNullable(info.getCodeName())).buildNumber(Optional.ofNullable(info.getBuildNumber())).build();
    }
}

