/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.process;

import io.deephaven.process.ImmutableSystemCpuOshi;
import io.deephaven.process.ProcessStyle;
import io.deephaven.properties.PropertySet;
import io.deephaven.properties.PropertyVisitor;
import java.util.OptionalLong;
import org.immutables.value.Value;
import oshi.hardware.CentralProcessor;

@Value.Immutable
@ProcessStyle
public abstract class SystemCpuOshi
implements PropertySet {
    private static final String VENDOR = "vendor";
    private static final String NAME = "name";
    private static final String PROCESSOR_ID = "processor-id";
    private static final String STEPPING = "stepping";
    private static final String MODEL = "model";
    private static final String FAMILY = "family";
    private static final String LOGICAL = "logical";
    private static final String PHYSICAL = "physical";
    private static final String SOCKETS = "sockets";
    private static final String IS_64_BIT = "is64bit";
    private static final String VENDOR_FREQUENCY = "vendor-frequency";

    @Value.Parameter
    public abstract String getVendor();

    @Value.Parameter
    public abstract String getName();

    @Value.Parameter
    public abstract OptionalLong getVendorFreq();

    @Value.Parameter
    public abstract String getProcessorID();

    @Value.Parameter
    public abstract String getStepping();

    @Value.Parameter
    public abstract String getModel();

    @Value.Parameter
    public abstract String getFamily();

    @Value.Parameter
    public abstract int getLogicalProcessorCount();

    @Value.Parameter
    public abstract int getPhysicalProcessorCount();

    @Value.Parameter
    public abstract int getPhysicalPackageCount();

    @Value.Parameter
    public abstract boolean is64bit();

    @Override
    public final void traverse(PropertyVisitor visitor) {
        visitor.visit(VENDOR, this.getVendor());
        visitor.visit(NAME, this.getName());
        visitor.visit(PROCESSOR_ID, this.getProcessorID());
        visitor.visit(STEPPING, this.getStepping());
        visitor.visit(MODEL, this.getModel());
        visitor.visit(FAMILY, this.getFamily());
        visitor.visit(LOGICAL, this.getLogicalProcessorCount());
        visitor.visit(PHYSICAL, this.getPhysicalProcessorCount());
        visitor.visit(SOCKETS, this.getPhysicalPackageCount());
        visitor.visit(IS_64_BIT, this.is64bit());
        visitor.maybeVisit(VENDOR_FREQUENCY, this.getVendorFreq());
    }

    public static SystemCpuOshi from(CentralProcessor centralProcessor) {
        CentralProcessor.ProcessorIdentifier identifier = centralProcessor.getProcessorIdentifier();
        return ImmutableSystemCpuOshi.builder().vendor(identifier.getVendor()).name(identifier.getName()).processorID(identifier.getProcessorID()).stepping(identifier.getStepping()).model(identifier.getModel()).family(identifier.getFamily()).logicalProcessorCount(centralProcessor.getLogicalProcessorCount()).physicalProcessorCount(centralProcessor.getPhysicalProcessorCount()).physicalPackageCount(centralProcessor.getPhysicalPackageCount()).is64bit(identifier.isCpu64bit()).vendorFreq(identifier.getVendorFreq() == -1L ? OptionalLong.empty() : OptionalLong.of(identifier.getVendorFreq())).build();
    }
}

