/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.process;

import io.deephaven.process.ImmutableSystemMemoryOshi;
import io.deephaven.process.ProcessStyle;
import io.deephaven.properties.PropertySet;
import io.deephaven.properties.PropertyVisitor;
import org.immutables.value.Value;
import oshi.hardware.GlobalMemory;

@Value.Immutable
@ProcessStyle
public abstract class SystemMemoryOshi
implements PropertySet {
    private static final String PHYSICAL = "physical";
    private static final String SWAP = "swap";
    private static final String PAGE_SIZE = "page-size";

    @Value.Parameter
    public abstract long getPhysicalTotal();

    @Value.Parameter
    public abstract long getSwapTotal();

    @Value.Parameter
    public abstract long getPageSize();

    @Override
    public final void traverse(PropertyVisitor visitor) {
        visitor.visit(PHYSICAL, this.getPhysicalTotal());
        visitor.visit(SWAP, this.getSwapTotal());
        visitor.visit(PAGE_SIZE, this.getPageSize());
    }

    public static SystemMemoryOshi from(GlobalMemory memory) {
        return ImmutableSystemMemoryOshi.builder().physicalTotal(memory.getTotal()).swapTotal(memory.getVirtualMemory().getSwapTotal()).pageSize(memory.getPageSize()).build();
    }
}

