/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.process;

import io.deephaven.process.EnvironmentVariables;
import io.deephaven.process.StringMapWrapper;
import io.deephaven.process.Wrapped;
import java.util.LinkedHashMap;
import java.util.Map;
import org.immutables.value.Value;

@Value.Immutable
@Wrapped
abstract class _EnvironmentVariables
extends StringMapWrapper {
    private static final String[] PREFIXES = new String[]{"PQ_"};

    _EnvironmentVariables() {
    }

    static EnvironmentVariables of() {
        Map<String, String> env = System.getenv();
        LinkedHashMap<String, String> toLog = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : env.entrySet()) {
            if (!_EnvironmentVariables.matchesPrefix(entry.getKey())) continue;
            toLog.put(entry.getKey(), entry.getValue());
        }
        return EnvironmentVariables.of(toLog);
    }

    private static boolean matchesPrefix(String key) {
        for (String prefix : PREFIXES) {
            if (!key.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

