/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.properties;

import io.deephaven.properties.PropertySet;
import io.deephaven.properties.PropertyVisitor;
import io.deephaven.properties.PropertyVisitorStringBase;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class SplayedPath {
    private static final char FS_SEPARATOR = '/';
    private static final Pattern SEPARATOR_PATTERN = Pattern.compile(Character.toString('.'), 16);
    private static final String VALUE_NAME = "__value";
    private static final Path VALUE_PATH = Paths.get("__value", new String[0]);
    private final Path path;
    private final boolean trim;
    private final boolean isValueBased;
    private final Writer writer;

    public SplayedPath(Path path, boolean trim, boolean isValueBased) {
        this.path = Objects.requireNonNull(path);
        if (!path.getFileSystem().equals(FileSystems.getDefault())) {
            throw new UnsupportedOperationException(String.format("Expected path to be a default filesystem path. Instead is: %s", path.getFileSystem()));
        }
        this.trim = trim;
        this.isValueBased = isValueBased;
        this.writer = new Writer();
    }

    public boolean exists() {
        return Files.isDirectory(this.path, new LinkOption[0]);
    }

    private void check() throws IOException {
        if (!this.exists()) {
            throw new IOException(String.format("Path does not exist, or is not a directory: '%s'", this.path));
        }
    }

    public void write(PropertySet properties) throws IOException {
        this.check();
        try {
            this.writer.visitProperties(properties);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public Map<String, String> toStringMap() throws IOException {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        this.readTo(PropertyVisitor.of(map::put));
        return map;
    }

    public void readTo(PropertyVisitor visitor) throws IOException {
        try (Stream<Path> stream = Files.walk(this.path, FileVisitOption.FOLLOW_LINKS);){
            Iterator it = stream.iterator();
            while (it.hasNext()) {
                BasicFileAttributes attributes;
                Path key = (Path)it.next();
                if (this.isValueBased && !key.endsWith(VALUE_PATH) || !(attributes = Files.readAttributes(key, BasicFileAttributes.class, new LinkOption[0])).isRegularFile()) continue;
                String keyString = this.pathToString(key);
                String value = this.toString(Files.readAllBytes(key));
                visitor.visit(keyString, value);
            }
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    private byte[] toBytes(String value) {
        return (this.trim ? value.trim() : value).getBytes(StandardCharsets.UTF_8);
    }

    private String toString(byte[] bytes) {
        return this.trim ? new String(bytes, StandardCharsets.UTF_8).trim() : new String(bytes, StandardCharsets.UTF_8);
    }

    private String pathToString(Path key) {
        String relative;
        if (this.isValueBased) {
            if (!key.endsWith(VALUE_PATH)) {
                throw new IllegalStateException(String.format("Expected path to be a value path, is not: '%s'", key));
            }
            key = key.getParent();
        }
        if ((relative = this.path.relativize(key).toString()).indexOf(46) != -1) {
            throw new IllegalStateException(String.format("Unable to translate path that has '%s' in it.", Character.valueOf('.')));
        }
        return relative.replace('/', '.');
    }

    private Path stringToPath(String key) {
        Path next = this.path;
        for (String part : SEPARATOR_PATTERN.split(key)) {
            next = next.resolve(part);
        }
        return this.isValueBased ? next.resolve(VALUE_NAME) : next;
    }

    private class Writer
    extends PropertyVisitorStringBase {
        private Writer() {
        }

        @Override
        public void visit(String key, String value) {
            try {
                this.write(key, value);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private void write(String key, String value) throws IOException {
            Path path = SplayedPath.this.stringToPath(key);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.write(path, SplayedPath.this.toBytes(value), new OpenOption[0]);
        }
    }
}

