/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.process;

import io.deephaven.process.ImmutableBaseboardOshi;
import io.deephaven.process.ProcessStyle;
import io.deephaven.properties.PropertySet;
import io.deephaven.properties.PropertyVisitor;
import org.immutables.value.Value;
import oshi.hardware.Baseboard;

@Value.Immutable
@ProcessStyle
public abstract class BaseboardOshi
implements PropertySet {
    private static final String MANUFACTURER = "manufacturer";
    private static final String MODEL = "model";
    private static final String VERSION = "version";
    private static final String SERIAL_NUMBER = "serial";

    @Value.Parameter
    public abstract String getManufacturer();

    @Value.Parameter
    public abstract String getModel();

    @Value.Parameter
    public abstract String getVersion();

    @Value.Parameter
    public abstract String getSerialNumber();

    @Override
    public final void traverse(PropertyVisitor visitor) {
        visitor.visit(MANUFACTURER, this.getManufacturer());
        visitor.visit(MODEL, this.getModel());
        visitor.visit(VERSION, this.getVersion());
        visitor.visit(SERIAL_NUMBER, this.getSerialNumber());
    }

    public static BaseboardOshi from(Baseboard baseboard) {
        return ImmutableBaseboardOshi.builder().manufacturer(baseboard.getManufacturer()).model(baseboard.getModel()).version(baseboard.getVersion()).serialNumber(baseboard.getSerialNumber()).build();
    }
}

