/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.process;

import io.deephaven.process.ImmutableFirmwareOshi;
import io.deephaven.process.ProcessStyle;
import io.deephaven.properties.PropertySet;
import io.deephaven.properties.PropertyVisitor;
import org.immutables.value.Value;
import oshi.hardware.Firmware;

@Value.Immutable
@ProcessStyle
public abstract class FirmwareOshi
implements PropertySet {
    private static final String MANUFACTURER = "manufacturer";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String VERSION = "version";
    private static final String RELEASE_DATE = "release-date";

    @Value.Parameter
    public abstract String getManufacturer();

    @Value.Parameter
    public abstract String getName();

    @Value.Parameter
    public abstract String getDescription();

    @Value.Parameter
    public abstract String getVersion();

    @Value.Parameter
    public abstract String getReleaseDate();

    @Override
    public final void traverse(PropertyVisitor visitor) {
        visitor.visit(MANUFACTURER, this.getManufacturer());
        visitor.visit(NAME, this.getName());
        visitor.visit(DESCRIPTION, this.getDescription());
        visitor.visit(VERSION, this.getVersion());
        visitor.visit(RELEASE_DATE, this.getReleaseDate());
    }

    public static FirmwareOshi from(Firmware firmware) {
        return ImmutableFirmwareOshi.builder().manufacturer(firmware.getManufacturer()).name(firmware.getName()).description(firmware.getDescription()).version(firmware.getVersion()).releaseDate(firmware.getReleaseDate()).build();
    }
}

