/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.process;

import io.deephaven.process.ApplicationArguments;
import io.deephaven.process.ApplicationConfig;
import io.deephaven.process.EnvironmentVariables;
import io.deephaven.process.HostPathInfo;
import io.deephaven.process.MemoryMxBeanInfo;
import io.deephaven.process.MemoryPoolsMxBeanInfo;
import io.deephaven.process.ProcessInfo;
import io.deephaven.process.ProcessUniqueId;
import io.deephaven.process.RuntimeMxBeanInfo;
import io.deephaven.process.SystemInfoOshi;
import io.deephaven.process.ThreadMxBeanInfo;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Generated(from="ProcessInfo", generator="Immutables")
final class ImmutableProcessInfo
extends ProcessInfo {
    private final ProcessUniqueId id;
    private final RuntimeMxBeanInfo runtimeInfo;
    private final EnvironmentVariables environmentVariables;
    private final ThreadMxBeanInfo threadInfo;
    private final MemoryMxBeanInfo memoryInfo;
    private final MemoryPoolsMxBeanInfo memoryPoolsInfo;
    private final ApplicationArguments applicationArguments;
    private final ApplicationConfig applicationConfig;
    private final HostPathInfo hostPathInfo;
    private final SystemInfoOshi systemInfo;

    private ImmutableProcessInfo(ProcessUniqueId id, RuntimeMxBeanInfo runtimeInfo, EnvironmentVariables environmentVariables, ThreadMxBeanInfo threadInfo, MemoryMxBeanInfo memoryInfo, MemoryPoolsMxBeanInfo memoryPoolsInfo, ApplicationArguments applicationArguments, ApplicationConfig applicationConfig, HostPathInfo hostPathInfo, Optional<? extends SystemInfoOshi> systemInfo) {
        this.id = Objects.requireNonNull(id, "id");
        this.runtimeInfo = Objects.requireNonNull(runtimeInfo, "runtimeInfo");
        this.environmentVariables = Objects.requireNonNull(environmentVariables, "environmentVariables");
        this.threadInfo = Objects.requireNonNull(threadInfo, "threadInfo");
        this.memoryInfo = Objects.requireNonNull(memoryInfo, "memoryInfo");
        this.memoryPoolsInfo = Objects.requireNonNull(memoryPoolsInfo, "memoryPoolsInfo");
        this.applicationArguments = Objects.requireNonNull(applicationArguments, "applicationArguments");
        this.applicationConfig = Objects.requireNonNull(applicationConfig, "applicationConfig");
        this.hostPathInfo = Objects.requireNonNull(hostPathInfo, "hostPathInfo");
        this.systemInfo = systemInfo.orElse(null);
    }

    private ImmutableProcessInfo(Builder builder) {
        this.id = builder.id;
        this.runtimeInfo = builder.runtimeInfo;
        this.environmentVariables = builder.environmentVariables;
        this.threadInfo = builder.threadInfo;
        this.memoryInfo = builder.memoryInfo;
        this.memoryPoolsInfo = builder.memoryPoolsInfo;
        this.applicationArguments = builder.applicationArguments;
        this.applicationConfig = builder.applicationConfig;
        this.hostPathInfo = builder.hostPathInfo;
        this.systemInfo = builder.systemInfo;
    }

    @Override
    public ProcessUniqueId getId() {
        return this.id;
    }

    @Override
    public RuntimeMxBeanInfo getRuntimeInfo() {
        return this.runtimeInfo;
    }

    @Override
    public EnvironmentVariables getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Override
    public ThreadMxBeanInfo getThreadInfo() {
        return this.threadInfo;
    }

    @Override
    public MemoryMxBeanInfo getMemoryInfo() {
        return this.memoryInfo;
    }

    @Override
    public MemoryPoolsMxBeanInfo getMemoryPoolsInfo() {
        return this.memoryPoolsInfo;
    }

    @Override
    public ApplicationArguments getApplicationArguments() {
        return this.applicationArguments;
    }

    @Override
    public ApplicationConfig getApplicationConfig() {
        return this.applicationConfig;
    }

    @Override
    public HostPathInfo getHostPathInfo() {
        return this.hostPathInfo;
    }

    @Override
    public Optional<SystemInfoOshi> getSystemInfo() {
        return Optional.ofNullable(this.systemInfo);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProcessInfo && this.equalTo((ImmutableProcessInfo)another);
    }

    private boolean equalTo(ImmutableProcessInfo another) {
        return this.id.equals(another.id) && this.runtimeInfo.equals(another.runtimeInfo) && this.environmentVariables.equals(another.environmentVariables) && this.threadInfo.equals(another.threadInfo) && this.memoryInfo.equals(another.memoryInfo) && this.memoryPoolsInfo.equals(another.memoryPoolsInfo) && this.applicationArguments.equals(another.applicationArguments) && this.applicationConfig.equals(another.applicationConfig) && this.hostPathInfo.equals(another.hostPathInfo) && Objects.equals(this.systemInfo, another.systemInfo);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.runtimeInfo.hashCode();
        h += (h << 5) + this.environmentVariables.hashCode();
        h += (h << 5) + this.threadInfo.hashCode();
        h += (h << 5) + this.memoryInfo.hashCode();
        h += (h << 5) + this.memoryPoolsInfo.hashCode();
        h += (h << 5) + this.applicationArguments.hashCode();
        h += (h << 5) + this.applicationConfig.hashCode();
        h += (h << 5) + this.hostPathInfo.hashCode();
        h += (h << 5) + Objects.hashCode(this.systemInfo);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ProcessInfo{");
        builder.append("id=").append(this.id);
        builder.append(", ");
        builder.append("runtimeInfo=").append(this.runtimeInfo);
        builder.append(", ");
        builder.append("environmentVariables=").append(this.environmentVariables);
        builder.append(", ");
        builder.append("threadInfo=").append(this.threadInfo);
        builder.append(", ");
        builder.append("memoryInfo=").append(this.memoryInfo);
        builder.append(", ");
        builder.append("memoryPoolsInfo=").append(this.memoryPoolsInfo);
        builder.append(", ");
        builder.append("applicationArguments=").append(this.applicationArguments);
        builder.append(", ");
        builder.append("applicationConfig=").append(this.applicationConfig);
        builder.append(", ");
        builder.append("hostPathInfo=").append(this.hostPathInfo);
        if (this.systemInfo != null) {
            builder.append(", ");
            builder.append("systemInfo=").append(this.systemInfo);
        }
        return builder.append("}").toString();
    }

    public static ImmutableProcessInfo of(ProcessUniqueId id, RuntimeMxBeanInfo runtimeInfo, EnvironmentVariables environmentVariables, ThreadMxBeanInfo threadInfo, MemoryMxBeanInfo memoryInfo, MemoryPoolsMxBeanInfo memoryPoolsInfo, ApplicationArguments applicationArguments, ApplicationConfig applicationConfig, HostPathInfo hostPathInfo, Optional<? extends SystemInfoOshi> systemInfo) {
        return new ImmutableProcessInfo(id, runtimeInfo, environmentVariables, threadInfo, memoryInfo, memoryPoolsInfo, applicationArguments, applicationConfig, hostPathInfo, systemInfo);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ProcessInfo", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_RUNTIME_INFO = 2L;
        private static final long INIT_BIT_ENVIRONMENT_VARIABLES = 4L;
        private static final long INIT_BIT_THREAD_INFO = 8L;
        private static final long INIT_BIT_MEMORY_INFO = 16L;
        private static final long INIT_BIT_MEMORY_POOLS_INFO = 32L;
        private static final long INIT_BIT_APPLICATION_ARGUMENTS = 64L;
        private static final long INIT_BIT_APPLICATION_CONFIG = 128L;
        private static final long INIT_BIT_HOST_PATH_INFO = 256L;
        private static final long OPT_BIT_SYSTEM_INFO = 1L;
        private long initBits = 511L;
        private long optBits;
        private ProcessUniqueId id;
        private RuntimeMxBeanInfo runtimeInfo;
        private EnvironmentVariables environmentVariables;
        private ThreadMxBeanInfo threadInfo;
        private MemoryMxBeanInfo memoryInfo;
        private MemoryPoolsMxBeanInfo memoryPoolsInfo;
        private ApplicationArguments applicationArguments;
        private ApplicationConfig applicationConfig;
        private HostPathInfo hostPathInfo;
        private SystemInfoOshi systemInfo;

        private Builder() {
        }

        public final Builder id(ProcessUniqueId id) {
            Builder.checkNotIsSet(this.idIsSet(), "id");
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder runtimeInfo(RuntimeMxBeanInfo runtimeInfo) {
            Builder.checkNotIsSet(this.runtimeInfoIsSet(), "runtimeInfo");
            this.runtimeInfo = Objects.requireNonNull(runtimeInfo, "runtimeInfo");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder environmentVariables(EnvironmentVariables environmentVariables) {
            Builder.checkNotIsSet(this.environmentVariablesIsSet(), "environmentVariables");
            this.environmentVariables = Objects.requireNonNull(environmentVariables, "environmentVariables");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder threadInfo(ThreadMxBeanInfo threadInfo) {
            Builder.checkNotIsSet(this.threadInfoIsSet(), "threadInfo");
            this.threadInfo = Objects.requireNonNull(threadInfo, "threadInfo");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder memoryInfo(MemoryMxBeanInfo memoryInfo) {
            Builder.checkNotIsSet(this.memoryInfoIsSet(), "memoryInfo");
            this.memoryInfo = Objects.requireNonNull(memoryInfo, "memoryInfo");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder memoryPoolsInfo(MemoryPoolsMxBeanInfo memoryPoolsInfo) {
            Builder.checkNotIsSet(this.memoryPoolsInfoIsSet(), "memoryPoolsInfo");
            this.memoryPoolsInfo = Objects.requireNonNull(memoryPoolsInfo, "memoryPoolsInfo");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder applicationArguments(ApplicationArguments applicationArguments) {
            Builder.checkNotIsSet(this.applicationArgumentsIsSet(), "applicationArguments");
            this.applicationArguments = Objects.requireNonNull(applicationArguments, "applicationArguments");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder applicationConfig(ApplicationConfig applicationConfig) {
            Builder.checkNotIsSet(this.applicationConfigIsSet(), "applicationConfig");
            this.applicationConfig = Objects.requireNonNull(applicationConfig, "applicationConfig");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder hostPathInfo(HostPathInfo hostPathInfo) {
            Builder.checkNotIsSet(this.hostPathInfoIsSet(), "hostPathInfo");
            this.hostPathInfo = Objects.requireNonNull(hostPathInfo, "hostPathInfo");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public final Builder systemInfo(SystemInfoOshi systemInfo) {
            Builder.checkNotIsSet(this.systemInfoIsSet(), "systemInfo");
            this.systemInfo = Objects.requireNonNull(systemInfo, "systemInfo");
            this.optBits |= 1L;
            return this;
        }

        public final Builder systemInfo(Optional<? extends SystemInfoOshi> systemInfo) {
            Builder.checkNotIsSet(this.systemInfoIsSet(), "systemInfo");
            this.systemInfo = systemInfo.orElse(null);
            this.optBits |= 1L;
            return this;
        }

        public ImmutableProcessInfo build() {
            this.checkRequiredAttributes();
            return new ImmutableProcessInfo(this);
        }

        private boolean systemInfoIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean idIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean runtimeInfoIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean environmentVariablesIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean threadInfoIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean memoryInfoIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private boolean memoryPoolsInfoIsSet() {
            return (this.initBits & 0x20L) == 0L;
        }

        private boolean applicationArgumentsIsSet() {
            return (this.initBits & 0x40L) == 0L;
        }

        private boolean applicationConfigIsSet() {
            return (this.initBits & 0x80L) == 0L;
        }

        private boolean hostPathInfoIsSet() {
            return (this.initBits & 0x100L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of ProcessInfo is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.idIsSet()) {
                attributes.add("id");
            }
            if (!this.runtimeInfoIsSet()) {
                attributes.add("runtimeInfo");
            }
            if (!this.environmentVariablesIsSet()) {
                attributes.add("environmentVariables");
            }
            if (!this.threadInfoIsSet()) {
                attributes.add("threadInfo");
            }
            if (!this.memoryInfoIsSet()) {
                attributes.add("memoryInfo");
            }
            if (!this.memoryPoolsInfoIsSet()) {
                attributes.add("memoryPoolsInfo");
            }
            if (!this.applicationArgumentsIsSet()) {
                attributes.add("applicationArguments");
            }
            if (!this.applicationConfigIsSet()) {
                attributes.add("applicationConfig");
            }
            if (!this.hostPathInfoIsSet()) {
                attributes.add("hostPathInfo");
            }
            return "Cannot build ProcessInfo, some of required attributes are not set " + attributes;
        }
    }
}

