/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.process;

import io.deephaven.process.SystemCpuOshi;
import java.util.ArrayList;
import java.util.Objects;
import java.util.OptionalLong;
import org.immutables.value.Generated;

@Generated(from="SystemCpuOshi", generator="Immutables")
final class ImmutableSystemCpuOshi
extends SystemCpuOshi {
    private final String vendor;
    private final String name;
    private final Long vendorFreq;
    private final String processorID;
    private final String stepping;
    private final String model;
    private final String family;
    private final int logicalProcessorCount;
    private final int physicalProcessorCount;
    private final int physicalPackageCount;
    private final boolean is64bit;

    private ImmutableSystemCpuOshi(String vendor, String name, OptionalLong vendorFreq, String processorID, String stepping, String model, String family, int logicalProcessorCount, int physicalProcessorCount, int physicalPackageCount, boolean is64bit) {
        this.vendor = Objects.requireNonNull(vendor, "vendor");
        this.name = Objects.requireNonNull(name, "name");
        this.vendorFreq = vendorFreq.isPresent() ? Long.valueOf(vendorFreq.getAsLong()) : null;
        this.processorID = Objects.requireNonNull(processorID, "processorID");
        this.stepping = Objects.requireNonNull(stepping, "stepping");
        this.model = Objects.requireNonNull(model, "model");
        this.family = Objects.requireNonNull(family, "family");
        this.logicalProcessorCount = logicalProcessorCount;
        this.physicalProcessorCount = physicalProcessorCount;
        this.physicalPackageCount = physicalPackageCount;
        this.is64bit = is64bit;
    }

    private ImmutableSystemCpuOshi(Builder builder) {
        this.vendor = builder.vendor;
        this.name = builder.name;
        this.vendorFreq = builder.vendorFreq;
        this.processorID = builder.processorID;
        this.stepping = builder.stepping;
        this.model = builder.model;
        this.family = builder.family;
        this.logicalProcessorCount = builder.logicalProcessorCount;
        this.physicalProcessorCount = builder.physicalProcessorCount;
        this.physicalPackageCount = builder.physicalPackageCount;
        this.is64bit = builder.is64bit;
    }

    @Override
    public String getVendor() {
        return this.vendor;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public OptionalLong getVendorFreq() {
        return this.vendorFreq != null ? OptionalLong.of(this.vendorFreq) : OptionalLong.empty();
    }

    @Override
    public String getProcessorID() {
        return this.processorID;
    }

    @Override
    public String getStepping() {
        return this.stepping;
    }

    @Override
    public String getModel() {
        return this.model;
    }

    @Override
    public String getFamily() {
        return this.family;
    }

    @Override
    public int getLogicalProcessorCount() {
        return this.logicalProcessorCount;
    }

    @Override
    public int getPhysicalProcessorCount() {
        return this.physicalProcessorCount;
    }

    @Override
    public int getPhysicalPackageCount() {
        return this.physicalPackageCount;
    }

    @Override
    public boolean is64bit() {
        return this.is64bit;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSystemCpuOshi && this.equalTo((ImmutableSystemCpuOshi)another);
    }

    private boolean equalTo(ImmutableSystemCpuOshi another) {
        return this.vendor.equals(another.vendor) && this.name.equals(another.name) && Objects.equals(this.vendorFreq, another.vendorFreq) && this.processorID.equals(another.processorID) && this.stepping.equals(another.stepping) && this.model.equals(another.model) && this.family.equals(another.family) && this.logicalProcessorCount == another.logicalProcessorCount && this.physicalProcessorCount == another.physicalProcessorCount && this.physicalPackageCount == another.physicalPackageCount && this.is64bit == another.is64bit;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.vendor.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.vendorFreq);
        h += (h << 5) + this.processorID.hashCode();
        h += (h << 5) + this.stepping.hashCode();
        h += (h << 5) + this.model.hashCode();
        h += (h << 5) + this.family.hashCode();
        h += (h << 5) + this.logicalProcessorCount;
        h += (h << 5) + this.physicalProcessorCount;
        h += (h << 5) + this.physicalPackageCount;
        h += (h << 5) + Boolean.hashCode(this.is64bit);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SystemCpuOshi{");
        builder.append("vendor=").append(this.vendor);
        builder.append(", ");
        builder.append("name=").append(this.name);
        if (this.vendorFreq != null) {
            builder.append(", ");
            builder.append("vendorFreq=").append(this.vendorFreq);
        }
        builder.append(", ");
        builder.append("processorID=").append(this.processorID);
        builder.append(", ");
        builder.append("stepping=").append(this.stepping);
        builder.append(", ");
        builder.append("model=").append(this.model);
        builder.append(", ");
        builder.append("family=").append(this.family);
        builder.append(", ");
        builder.append("logicalProcessorCount=").append(this.logicalProcessorCount);
        builder.append(", ");
        builder.append("physicalProcessorCount=").append(this.physicalProcessorCount);
        builder.append(", ");
        builder.append("physicalPackageCount=").append(this.physicalPackageCount);
        builder.append(", ");
        builder.append("is64bit=").append(this.is64bit);
        return builder.append("}").toString();
    }

    public static ImmutableSystemCpuOshi of(String vendor, String name, OptionalLong vendorFreq, String processorID, String stepping, String model, String family, int logicalProcessorCount, int physicalProcessorCount, int physicalPackageCount, boolean is64bit) {
        return new ImmutableSystemCpuOshi(vendor, name, vendorFreq, processorID, stepping, model, family, logicalProcessorCount, physicalProcessorCount, physicalPackageCount, is64bit);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SystemCpuOshi", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_VENDOR = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_PROCESSOR_I_D = 4L;
        private static final long INIT_BIT_STEPPING = 8L;
        private static final long INIT_BIT_MODEL = 16L;
        private static final long INIT_BIT_FAMILY = 32L;
        private static final long INIT_BIT_LOGICAL_PROCESSOR_COUNT = 64L;
        private static final long INIT_BIT_PHYSICAL_PROCESSOR_COUNT = 128L;
        private static final long INIT_BIT_PHYSICAL_PACKAGE_COUNT = 256L;
        private static final long INIT_BIT_IS64BIT = 512L;
        private static final long OPT_BIT_VENDOR_FREQ = 1L;
        private long initBits = 1023L;
        private long optBits;
        private String vendor;
        private String name;
        private Long vendorFreq;
        private String processorID;
        private String stepping;
        private String model;
        private String family;
        private int logicalProcessorCount;
        private int physicalProcessorCount;
        private int physicalPackageCount;
        private boolean is64bit;

        private Builder() {
        }

        public final Builder vendor(String vendor) {
            Builder.checkNotIsSet(this.vendorIsSet(), "vendor");
            this.vendor = Objects.requireNonNull(vendor, "vendor");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String name) {
            Builder.checkNotIsSet(this.nameIsSet(), "name");
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder vendorFreq(long vendorFreq) {
            Builder.checkNotIsSet(this.vendorFreqIsSet(), "vendorFreq");
            this.vendorFreq = vendorFreq;
            this.optBits |= 1L;
            return this;
        }

        public final Builder vendorFreq(OptionalLong vendorFreq) {
            Builder.checkNotIsSet(this.vendorFreqIsSet(), "vendorFreq");
            this.vendorFreq = vendorFreq.isPresent() ? Long.valueOf(vendorFreq.getAsLong()) : null;
            this.optBits |= 1L;
            return this;
        }

        public final Builder processorID(String processorID) {
            Builder.checkNotIsSet(this.processorIDIsSet(), "processorID");
            this.processorID = Objects.requireNonNull(processorID, "processorID");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder stepping(String stepping) {
            Builder.checkNotIsSet(this.steppingIsSet(), "stepping");
            this.stepping = Objects.requireNonNull(stepping, "stepping");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder model(String model) {
            Builder.checkNotIsSet(this.modelIsSet(), "model");
            this.model = Objects.requireNonNull(model, "model");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder family(String family) {
            Builder.checkNotIsSet(this.familyIsSet(), "family");
            this.family = Objects.requireNonNull(family, "family");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder logicalProcessorCount(int logicalProcessorCount) {
            Builder.checkNotIsSet(this.logicalProcessorCountIsSet(), "logicalProcessorCount");
            this.logicalProcessorCount = logicalProcessorCount;
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder physicalProcessorCount(int physicalProcessorCount) {
            Builder.checkNotIsSet(this.physicalProcessorCountIsSet(), "physicalProcessorCount");
            this.physicalProcessorCount = physicalProcessorCount;
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder physicalPackageCount(int physicalPackageCount) {
            Builder.checkNotIsSet(this.physicalPackageCountIsSet(), "physicalPackageCount");
            this.physicalPackageCount = physicalPackageCount;
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public final Builder is64bit(boolean is64bit) {
            Builder.checkNotIsSet(this.is64bitIsSet(), "is64bit");
            this.is64bit = is64bit;
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        public ImmutableSystemCpuOshi build() {
            this.checkRequiredAttributes();
            return new ImmutableSystemCpuOshi(this);
        }

        private boolean vendorFreqIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean vendorIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean nameIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean processorIDIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean steppingIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean modelIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private boolean familyIsSet() {
            return (this.initBits & 0x20L) == 0L;
        }

        private boolean logicalProcessorCountIsSet() {
            return (this.initBits & 0x40L) == 0L;
        }

        private boolean physicalProcessorCountIsSet() {
            return (this.initBits & 0x80L) == 0L;
        }

        private boolean physicalPackageCountIsSet() {
            return (this.initBits & 0x100L) == 0L;
        }

        private boolean is64bitIsSet() {
            return (this.initBits & 0x200L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of SystemCpuOshi is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.vendorIsSet()) {
                attributes.add("vendor");
            }
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.processorIDIsSet()) {
                attributes.add("processorID");
            }
            if (!this.steppingIsSet()) {
                attributes.add("stepping");
            }
            if (!this.modelIsSet()) {
                attributes.add("model");
            }
            if (!this.familyIsSet()) {
                attributes.add("family");
            }
            if (!this.logicalProcessorCountIsSet()) {
                attributes.add("logicalProcessorCount");
            }
            if (!this.physicalProcessorCountIsSet()) {
                attributes.add("physicalProcessorCount");
            }
            if (!this.physicalPackageCountIsSet()) {
                attributes.add("physicalPackageCount");
            }
            if (!this.is64bitIsSet()) {
                attributes.add("is64bit");
            }
            return "Cannot build SystemCpuOshi, some of required attributes are not set " + attributes;
        }
    }
}

