/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.process;

import io.deephaven.process.ComputerSystemOshi;
import io.deephaven.process.OperatingSystemOshi;
import io.deephaven.process.SystemCpuOshi;
import io.deephaven.process.SystemInfoOshi;
import io.deephaven.process.SystemMemoryOshi;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="SystemInfoOshi", generator="Immutables")
final class ImmutableSystemInfoOshi
extends SystemInfoOshi {
    private final OperatingSystemOshi operatingSystem;
    private final ComputerSystemOshi computerSystem;
    private final SystemMemoryOshi systemMemory;
    private final SystemCpuOshi systemCpu;

    private ImmutableSystemInfoOshi(OperatingSystemOshi operatingSystem, ComputerSystemOshi computerSystem, SystemMemoryOshi systemMemory, SystemCpuOshi systemCpu) {
        this.operatingSystem = Objects.requireNonNull(operatingSystem, "operatingSystem");
        this.computerSystem = Objects.requireNonNull(computerSystem, "computerSystem");
        this.systemMemory = Objects.requireNonNull(systemMemory, "systemMemory");
        this.systemCpu = Objects.requireNonNull(systemCpu, "systemCpu");
    }

    private ImmutableSystemInfoOshi(Builder builder) {
        this.operatingSystem = builder.operatingSystem;
        this.computerSystem = builder.computerSystem;
        this.systemMemory = builder.systemMemory;
        this.systemCpu = builder.systemCpu;
    }

    @Override
    public OperatingSystemOshi getOperatingSystem() {
        return this.operatingSystem;
    }

    @Override
    public ComputerSystemOshi getComputerSystem() {
        return this.computerSystem;
    }

    @Override
    public SystemMemoryOshi getSystemMemory() {
        return this.systemMemory;
    }

    @Override
    public SystemCpuOshi getSystemCpu() {
        return this.systemCpu;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSystemInfoOshi && this.equalTo((ImmutableSystemInfoOshi)another);
    }

    private boolean equalTo(ImmutableSystemInfoOshi another) {
        return this.operatingSystem.equals(another.operatingSystem) && this.computerSystem.equals(another.computerSystem) && this.systemMemory.equals(another.systemMemory) && this.systemCpu.equals(another.systemCpu);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.operatingSystem.hashCode();
        h += (h << 5) + this.computerSystem.hashCode();
        h += (h << 5) + this.systemMemory.hashCode();
        h += (h << 5) + this.systemCpu.hashCode();
        return h;
    }

    public String toString() {
        return "SystemInfoOshi{operatingSystem=" + this.operatingSystem + ", computerSystem=" + this.computerSystem + ", systemMemory=" + this.systemMemory + ", systemCpu=" + this.systemCpu + "}";
    }

    public static ImmutableSystemInfoOshi of(OperatingSystemOshi operatingSystem, ComputerSystemOshi computerSystem, SystemMemoryOshi systemMemory, SystemCpuOshi systemCpu) {
        return new ImmutableSystemInfoOshi(operatingSystem, computerSystem, systemMemory, systemCpu);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SystemInfoOshi", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_OPERATING_SYSTEM = 1L;
        private static final long INIT_BIT_COMPUTER_SYSTEM = 2L;
        private static final long INIT_BIT_SYSTEM_MEMORY = 4L;
        private static final long INIT_BIT_SYSTEM_CPU = 8L;
        private long initBits = 15L;
        private OperatingSystemOshi operatingSystem;
        private ComputerSystemOshi computerSystem;
        private SystemMemoryOshi systemMemory;
        private SystemCpuOshi systemCpu;

        private Builder() {
        }

        public final Builder operatingSystem(OperatingSystemOshi operatingSystem) {
            Builder.checkNotIsSet(this.operatingSystemIsSet(), "operatingSystem");
            this.operatingSystem = Objects.requireNonNull(operatingSystem, "operatingSystem");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder computerSystem(ComputerSystemOshi computerSystem) {
            Builder.checkNotIsSet(this.computerSystemIsSet(), "computerSystem");
            this.computerSystem = Objects.requireNonNull(computerSystem, "computerSystem");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder systemMemory(SystemMemoryOshi systemMemory) {
            Builder.checkNotIsSet(this.systemMemoryIsSet(), "systemMemory");
            this.systemMemory = Objects.requireNonNull(systemMemory, "systemMemory");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder systemCpu(SystemCpuOshi systemCpu) {
            Builder.checkNotIsSet(this.systemCpuIsSet(), "systemCpu");
            this.systemCpu = Objects.requireNonNull(systemCpu, "systemCpu");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableSystemInfoOshi build() {
            this.checkRequiredAttributes();
            return new ImmutableSystemInfoOshi(this);
        }

        private boolean operatingSystemIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean computerSystemIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean systemMemoryIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean systemCpuIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of SystemInfoOshi is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.operatingSystemIsSet()) {
                attributes.add("operatingSystem");
            }
            if (!this.computerSystemIsSet()) {
                attributes.add("computerSystem");
            }
            if (!this.systemMemoryIsSet()) {
                attributes.add("systemMemory");
            }
            if (!this.systemCpuIsSet()) {
                attributes.add("systemCpu");
            }
            return "Cannot build SystemInfoOshi, some of required attributes are not set " + attributes;
        }
    }
}

