/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.process;

import io.deephaven.process.SystemMemoryOshi;
import java.util.ArrayList;
import org.immutables.value.Generated;

@Generated(from="SystemMemoryOshi", generator="Immutables")
final class ImmutableSystemMemoryOshi
extends SystemMemoryOshi {
    private final long physicalTotal;
    private final long swapTotal;
    private final long pageSize;

    private ImmutableSystemMemoryOshi(long physicalTotal, long swapTotal, long pageSize) {
        this.physicalTotal = physicalTotal;
        this.swapTotal = swapTotal;
        this.pageSize = pageSize;
    }

    private ImmutableSystemMemoryOshi(Builder builder) {
        this.physicalTotal = builder.physicalTotal;
        this.swapTotal = builder.swapTotal;
        this.pageSize = builder.pageSize;
    }

    @Override
    public long getPhysicalTotal() {
        return this.physicalTotal;
    }

    @Override
    public long getSwapTotal() {
        return this.swapTotal;
    }

    @Override
    public long getPageSize() {
        return this.pageSize;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSystemMemoryOshi && this.equalTo((ImmutableSystemMemoryOshi)another);
    }

    private boolean equalTo(ImmutableSystemMemoryOshi another) {
        return this.physicalTotal == another.physicalTotal && this.swapTotal == another.swapTotal && this.pageSize == another.pageSize;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.physicalTotal);
        h += (h << 5) + Long.hashCode(this.swapTotal);
        h += (h << 5) + Long.hashCode(this.pageSize);
        return h;
    }

    public String toString() {
        return "SystemMemoryOshi{physicalTotal=" + this.physicalTotal + ", swapTotal=" + this.swapTotal + ", pageSize=" + this.pageSize + "}";
    }

    public static ImmutableSystemMemoryOshi of(long physicalTotal, long swapTotal, long pageSize) {
        return new ImmutableSystemMemoryOshi(physicalTotal, swapTotal, pageSize);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SystemMemoryOshi", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_PHYSICAL_TOTAL = 1L;
        private static final long INIT_BIT_SWAP_TOTAL = 2L;
        private static final long INIT_BIT_PAGE_SIZE = 4L;
        private long initBits = 7L;
        private long physicalTotal;
        private long swapTotal;
        private long pageSize;

        private Builder() {
        }

        public final Builder physicalTotal(long physicalTotal) {
            Builder.checkNotIsSet(this.physicalTotalIsSet(), "physicalTotal");
            this.physicalTotal = physicalTotal;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder swapTotal(long swapTotal) {
            Builder.checkNotIsSet(this.swapTotalIsSet(), "swapTotal");
            this.swapTotal = swapTotal;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder pageSize(long pageSize) {
            Builder.checkNotIsSet(this.pageSizeIsSet(), "pageSize");
            this.pageSize = pageSize;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableSystemMemoryOshi build() {
            this.checkRequiredAttributes();
            return new ImmutableSystemMemoryOshi(this);
        }

        private boolean physicalTotalIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean swapTotalIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean pageSizeIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of SystemMemoryOshi is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.physicalTotalIsSet()) {
                attributes.add("physicalTotal");
            }
            if (!this.swapTotalIsSet()) {
                attributes.add("swapTotal");
            }
            if (!this.pageSizeIsSet()) {
                attributes.add("pageSize");
            }
            return "Cannot build SystemMemoryOshi, some of required attributes are not set " + attributes;
        }
    }
}

