/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.process;

import io.deephaven.process.ImmutableMemoryUsageInfo;
import io.deephaven.process.ProcessStyle;
import io.deephaven.properties.PropertySet;
import io.deephaven.properties.PropertyVisitor;
import java.lang.management.MemoryUsage;
import java.util.OptionalLong;
import org.immutables.value.Value;

@Value.Immutable
@ProcessStyle
public abstract class MemoryUsageInfo
implements PropertySet {
    private static final String INIT = "init";
    private static final String MAX = "max";

    public static MemoryUsageInfo of(MemoryUsage usage) {
        ImmutableMemoryUsageInfo.Builder builder = ImmutableMemoryUsageInfo.builder();
        if (usage.getInit() != -1L) {
            builder.init(usage.getInit());
        }
        if (usage.getMax() != -1L) {
            builder.max(usage.getMax());
        }
        return builder.build();
    }

    @Value.Parameter
    public abstract OptionalLong init();

    @Value.Parameter
    public abstract OptionalLong max();

    @Override
    public final void traverse(PropertyVisitor visitor) {
        visitor.maybeVisit(INIT, this.init());
        visitor.maybeVisit(MAX, this.max());
    }
}

