/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.process;

import io.deephaven.process.ApplicationArguments;
import io.deephaven.process.ApplicationConfig;
import io.deephaven.process.EnvironmentVariables;
import io.deephaven.process.HostPathInfo;
import io.deephaven.process.MemoryMxBeanInfo;
import io.deephaven.process.MemoryPoolsMxBeanInfo;
import io.deephaven.process.ProcessStyle;
import io.deephaven.process.ProcessUniqueId;
import io.deephaven.process.RuntimeMxBeanInfo;
import io.deephaven.process.SystemInfoOshi;
import io.deephaven.process.ThreadMxBeanInfo;
import io.deephaven.properties.PropertySet;
import io.deephaven.properties.PropertyVisitor;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
@ProcessStyle
public abstract class ProcessInfo
implements PropertySet {
    private static final int VERSION = 3;
    private static final String META_ID = "meta.id";
    private static final String META_VERSION = "meta.version";
    private static final String RUNTIME_MX = "runtime-mx";
    private static final String ENVIRONMENT = "env-var";
    private static final String THREAD_MX = "thread-mx";
    private static final String MEMORY_MX = "memory-mx";
    private static final String MEMORY_POOL_MX = "memory-pool-mx";
    private static final String APP_ARGS = "app-args";
    private static final String APP_CONFIG = "app-config";
    private static final String HOST_PATH_INFO = "host-path-info";
    private static final String SYSTEM_INFO = "system-info";

    @Value.Parameter
    public abstract ProcessUniqueId getId();

    @Value.Parameter
    public abstract RuntimeMxBeanInfo getRuntimeInfo();

    @Value.Parameter
    public abstract EnvironmentVariables getEnvironmentVariables();

    @Value.Parameter
    public abstract ThreadMxBeanInfo getThreadInfo();

    @Value.Parameter
    public abstract MemoryMxBeanInfo getMemoryInfo();

    @Value.Parameter
    public abstract MemoryPoolsMxBeanInfo getMemoryPoolsInfo();

    @Value.Parameter
    public abstract ApplicationArguments getApplicationArguments();

    @Value.Parameter
    public abstract ApplicationConfig getApplicationConfig();

    @Value.Parameter
    public abstract HostPathInfo getHostPathInfo();

    @Value.Parameter
    public abstract Optional<SystemInfoOshi> getSystemInfo();

    @Override
    public final void traverse(PropertyVisitor visitor) {
        visitor.visit(META_ID, this.getId().value());
        visitor.visit(META_VERSION, 3);
        visitor.visitProperties(RUNTIME_MX, this.getRuntimeInfo());
        visitor.visitProperties(ENVIRONMENT, this.getEnvironmentVariables());
        visitor.visitProperties(THREAD_MX, this.getThreadInfo());
        visitor.visitProperties(MEMORY_MX, this.getMemoryInfo());
        visitor.visitProperties(MEMORY_POOL_MX, this.getMemoryPoolsInfo());
        visitor.visitProperties(APP_ARGS, this.getApplicationArguments());
        visitor.visitProperties(APP_CONFIG, this.getApplicationConfig());
        visitor.visitProperties(HOST_PATH_INFO, this.getHostPathInfo());
        visitor.maybeVisitProperties(SYSTEM_INFO, this.getSystemInfo());
    }
}

