/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.properties;

import io.deephaven.properties.PropertyVisitor;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public interface PropertySet {
    public static PropertySet of(Properties properties) {
        return new PropertiesImpl(properties);
    }

    public static PropertySet of(Map<String, String> map) {
        return new StringMapImpl(map);
    }

    public static PropertySet of(List<String> list) {
        return new StringListImpl(list);
    }

    public void traverse(PropertyVisitor var1);

    public static class PropertiesImpl
    implements PropertySet {
        private final Properties properties;

        PropertiesImpl(Properties properties) {
            this.properties = Objects.requireNonNull(properties, "properties");
        }

        @Override
        public void traverse(PropertyVisitor visitor) {
            for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                visitor.visit((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public static class StringListImpl
    implements PropertySet {
        private final List<String> list;

        StringListImpl(List<String> list) {
            this.list = Objects.requireNonNull(list, "list");
        }

        @Override
        public void traverse(PropertyVisitor visitor) {
            int len = this.list.size();
            visitor.visit("len", len);
            for (int i = 0; i < len; ++i) {
                visitor.visit(Integer.toString(i), this.list.get(i));
            }
        }
    }

    public static class StringMapImpl
    implements PropertySet {
        private final Map<String, String> map;

        StringMapImpl(Map<String, String> map) {
            this.map = Objects.requireNonNull(map, "map");
        }

        @Override
        public void traverse(PropertyVisitor visitor) {
            for (Map.Entry<String, String> entry : this.map.entrySet()) {
                visitor.visit(entry.getKey(), entry.getValue());
            }
        }
    }
}

