/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.properties;

import io.deephaven.properties.PropertySet;
import io.deephaven.properties.PropertyVisitorPrefixed;
import io.deephaven.properties.PropertyVisitorPrintStream;
import io.deephaven.properties.PropertyVisitorStringBase;
import java.io.PrintStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.BiConsumer;

public interface PropertyVisitor {
    public static final char SEPARATOR = '.';

    public static PropertyVisitor stdout() {
        return PropertyVisitor.of(System.out);
    }

    public static PropertyVisitor stderr() {
        return PropertyVisitor.of(System.err);
    }

    public static PropertyVisitor of(PrintStream out) {
        return new PropertyVisitorPrintStream(out);
    }

    public static PropertyVisitor of(BiConsumer<String, String> consumer) {
        return new PropertyVisitorStringBase.BiConsumerStringImpl(consumer);
    }

    public static Map<String, String> toStringMap(PropertySet properties) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        PropertyVisitor.of(map::put).visitProperties(properties);
        return map;
    }

    public void visit(String var1, String var2);

    public void visit(String var1, int var2);

    public void visit(String var1, long var2);

    public void visit(String var1, boolean var2);

    default public void visitProperties(PropertySet properties) {
        properties.traverse(this);
    }

    default public void visitProperties(String key, PropertySet properties) {
        new PropertyVisitorPrefixed(key + ".", this).visitProperties(properties);
    }

    default public void maybeVisit(String key, Optional<String> value) {
        value.ifPresent(x -> this.visit(key, (String)x));
    }

    default public void maybeVisit(String key, OptionalInt value) {
        value.ifPresent(x -> this.visit(key, x));
    }

    default public void maybeVisit(String key, OptionalLong value) {
        value.ifPresent(x -> this.visit(key, x));
    }

    default public void maybeVisitProperties(String key, Optional<? extends PropertySet> properties) {
        properties.ifPresent(x -> this.visitProperties(key, (PropertySet)x));
    }
}

